/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import parser.ast.PropertiesFile;
import prism.UndefinedConstants;
import userinterface.properties.GUIExperiment;
import userinterface.properties.GUIMultiProperties;

public class GUIExperimentTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private ExperimentTableModel expModel;
    private GUIMultiProperties guiProps;

    public GUIExperimentTable(GUIMultiProperties gUIMultiProperties) {
        this.guiProps = gUIMultiProperties;
        this.initComponents();
        TableColumn tableColumn = this.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new ProgressBarRenderer());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setRowHeight(this.getFontMetrics(font).getHeight() + 4);
    }

    public void deleteSelected() {
        while (this.getSelectedRowCount() > 0) {
            int n = this.getSelectedRow();
            this.removeExperiment(n);
        }
    }

    public int newExperiment(PropertiesFile propertiesFile, UndefinedConstants undefinedConstants, boolean bl) {
        GUIExperiment gUIExperiment = new GUIExperiment(this, this.guiProps, propertiesFile, undefinedConstants, bl);
        return this.expModel.addExperiment(gUIExperiment);
    }

    public void removeExperiment(int n) {
        this.expModel.removeExperiment(n);
    }

    public void startExperiment(int n) {
        this.expModel.getExperiment(n).startExperiment();
    }

    public void progressChanged() {
        this.repaint();
    }

    public void stop() {
        this.expModel.stop();
    }

    public int getNumExperiments() {
        return this.expModel.getNumExperiments();
    }

    public GUIExperiment getExperiment(int n) {
        return this.expModel.getExperiment(n);
    }

    private void initComponents() {
        this.expModel = new ExperimentTableModel();
        this.setModel(this.expModel);
    }

    class ProgressBarRenderer
    implements TableCellRenderer {
        ProgressBarRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof JProgressBar) {
                JProgressBar jProgressBar = new JProgressBar();
                if (bl) {
                    jProgressBar.setBackground(GUIExperimentTable.this.getSelectionBackground());
                } else {
                    jProgressBar.setBackground(GUIExperimentTable.this.getBackground());
                }
                return (JProgressBar)object;
            }
            return new JPanel();
        }
    }

    class ExperimentTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        ArrayList<GUIExperiment> experiments = new ArrayList();

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Property";
                }
                case 1: {
                    return "Defined Constants";
                }
                case 2: {
                    return "Progress";
                }
                case 3: {
                    return "Status";
                }
                case 4: {
                    return "Method";
                }
            }
            return "";
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return this.experiments.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            GUIExperiment gUIExperiment = this.getExperiment(n);
            switch (n2) {
                case 0: {
                    return gUIExperiment.getPropertyString();
                }
                case 1: {
                    return gUIExperiment.getDefinedConstantsString();
                }
                case 2: {
                    JProgressBar jProgressBar = new JProgressBar();
                    if (gUIExperiment.getTotalIterations() > 0) {
                        jProgressBar.setMaximum(gUIExperiment.getTotalIterations());
                        jProgressBar.setValue(gUIExperiment.getCurrentIterations());
                        jProgressBar.setStringPainted(true);
                        jProgressBar.setBackground(Color.white);
                        int n3 = (int)((double)gUIExperiment.getCurrentIterations() / (double)gUIExperiment.getTotalIterations() * 100.0);
                        jProgressBar.setString("" + gUIExperiment.getCurrentIterations() + "/" + gUIExperiment.getTotalIterations() + " (" + n3 + "%)");
                    } else {
                        jProgressBar.setMaximum(1);
                        jProgressBar.setValue(1);
                        jProgressBar.setStringPainted(true);
                        jProgressBar.setBackground(Color.white);
                        jProgressBar.setString("0/0 (100%)");
                    }
                    return jProgressBar;
                }
                case 3: {
                    if (!gUIExperiment.isFinished()) {
                        return "Running";
                    }
                    return gUIExperiment.getCurrentIterations() < gUIExperiment.getTotalIterations() ? "Stopped" : "Done";
                }
                case 4: {
                    if (gUIExperiment.isUseSimulation()) {
                        return "Simulation";
                    }
                    return "Verification";
                }
            }
            return "";
        }

        public GUIExperiment getExperiment(int n) {
            return this.experiments.get(n);
        }

        public int getNumExperiments() {
            return this.experiments.size();
        }

        public int addExperiment(GUIExperiment gUIExperiment) {
            this.experiments.add(gUIExperiment);
            int n = this.experiments.size() - 1;
            this.fireTableRowsInserted(n, n);
            GUIExperimentTable.this.scrollRectToVisible(GUIExperimentTable.this.getCellRect(n, 0, true));
            return this.experiments.indexOf(gUIExperiment);
        }

        public void removeExperiment(int n) {
            GUIExperiment gUIExperiment = this.getExperiment(n);
            gUIExperiment.clear();
            this.experiments.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public void stop() {
            for (int i = 0; i < this.getNumExperiments(); ++i) {
                this.getExperiment(i).stop();
            }
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    return String.class;
                }
                case 2: {
                    return JProgressBar.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return Object.class;
        }
    }
}

