/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Observer;
import prism.Prism;
import userinterface.model.graphicModel.Decision;
import userinterface.model.graphicModel.ExpressionLabel;
import userinterface.model.graphicModel.Nail;
import userinterface.model.graphicModel.State;
import userinterface.model.graphicModel.StringLabel;
import userinterface.util.PropertyOwner;
import userinterface.util.SingleProperty;

public class Transition
implements PropertyOwner {
    protected State from;
    protected ArrayList nails;
    protected State to;
    protected Prism pr;
    private ExpressionLabel guard;
    private StringLabel sync;
    private StringLabel assignment;
    private ExpressionLabel probability;
    private boolean docked;
    private boolean selected;
    protected Point2D middle;
    private ArrayList intersects;

    public Transition(State state, State state2, Prism prism) {
        this.from = state;
        this.to = state2;
        this.pr = prism;
        this.guard = new ExpressionLabel("", this, "Guard", true, "A Boolean expression that describes the when the transition can occur.", prism);
        this.guard.setOffsetX(-10.0);
        this.guard.setOffsetY(-10.0);
        this.guard.setColour(Color.blue);
        this.sync = new StringLabel("", this, "Sync", false, "A string describing the name of the synchronisation action for this transition.  If this is left blank, the transition is performed asynchronously.");
        this.sync.setOffsetX(-10.0);
        this.sync.setOffsetY(0.0);
        this.sync.setColour(new Color(216, 168, 23));
        this.assignment = new StringLabel("", this, "Assignment", true, "A list of '&'-separated local variable updates.");
        this.assignment.setOffsetX(-10.0);
        this.assignment.setOffsetY(10.0);
        this.assignment.setColour(Color.red);
        this.probability = new ExpressionLabel("", this, "Probability", true, "A Boolean expression that describes the probability of this transition.", prism);
        this.probability.setOffsetX(-10.0);
        this.probability.setOffsetY(-20.0);
        this.probability.setColour(Color.black);
        this.nails = new ArrayList();
        this.docked = true;
        this.selected = false;
        state.associateTransition(this);
        state2.associateTransition(this);
        this.workOutMiddle();
    }

    public Transition(State state, State state2, ArrayList arrayList, Prism prism) {
        this(state, state2, prism);
        this.nails = arrayList;
        for (int i = 0; i < this.getNumNails(); ++i) {
            this.getNail(i).associateTransition(this);
        }
        this.workOutMiddle();
    }

    public Rectangle2D getBounds2D() {
        Nail nail;
        double d = this.from.getX() + 15.0;
        if (this.to.getX() + 15.0 < d) {
            d = this.to.getX() + 15.0;
        }
        for (int i = 0; i < this.getNumNails(); ++i) {
            nail = this.getNail(i);
            if (!(nail.getX() < d)) continue;
            d = nail.getX();
        }
        double d2 = this.from.getX() + 15.0;
        if (this.to.getX() + 15.0 > d2) {
            d2 = this.to.getX() + 15.0;
        }
        for (int i = 0; i < this.getNumNails(); ++i) {
            nail = this.getNail(i);
            if (!(nail.getX() > d2)) continue;
            d2 = nail.getX();
        }
        double d3 = this.from.getY() + 15.0;
        if (this.to.getY() + 15.0 < d3) {
            d3 = this.to.getY() + 15.0;
        }
        for (int i = 0; i < this.getNumNails(); ++i) {
            nail = this.getNail(i);
            if (!(nail.getY() < d3)) continue;
            d3 = nail.getY();
        }
        double d4 = this.from.getY() + 15.0;
        if (this.to.getY() + 15.0 > d4) {
            d4 = this.to.getY() + 15.0;
        }
        for (int i = 0; i < this.getNumNails(); ++i) {
            nail = this.getNail(i);
            if (!(nail.getY() > d4)) continue;
            d4 = nail.getY();
        }
        return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
    }

    public ArrayList getNails() {
        return this.nails;
    }

    public State getFrom() {
        return this.from;
    }

    public State getTo() {
        return this.to;
    }

    public int getNumNails() {
        return this.nails.size();
    }

    public Nail getNail(int n) {
        return (Nail)this.nails.get(n);
    }

    public ExpressionLabel getGuardLabel() {
        return this.guard;
    }

    public StringLabel getSyncLabel() {
        return this.sync;
    }

    public ExpressionLabel getProbabilityLabel() {
        return this.probability;
    }

    public StringLabel getAssignmentLabel() {
        return this.assignment;
    }

    public Point2D getMiddle() {
        return this.middle;
    }

    public double getMinX() {
        double d = this.from.getX() - 10.0;
        if (this.to.getX() - 15.0 < d) {
            d = this.to.getX() - 15.0 + 10.0;
        }
        for (int i = 0; i < this.getNumNails(); ++i) {
            Nail nail = this.getNail(i);
            if (!(nail.getX() - 4.0 < d)) continue;
            d = nail.getX() - 4.0;
        }
        this.guard.workOutMinsAndMaxs();
        this.sync.workOutMinsAndMaxs();
        this.probability.workOutMinsAndMaxs();
        this.assignment.workOutMinsAndMaxs();
        if (this.guard.getMinX() < d) {
            d = this.guard.getMinX();
        }
        if (this.sync.getMinX() < d) {
            d = this.sync.getMinX();
        }
        if (this.probability.getMinX() < d) {
            d = this.probability.getMinX();
        }
        if (this.assignment.getMinX() < d) {
            d = this.assignment.getMinX();
        }
        return d;
    }

    public double getMaxX() {
        double d = this.from.getX() + 15.0 + 10.0;
        if (this.to.getX() + 15.0 + 10.0 > d) {
            d = this.to.getX() + 15.0 + 10.0;
        }
        for (int i = 0; i < this.getNumNails(); ++i) {
            Nail nail = this.getNail(i);
            if (!(nail.getX() + 4.0 > d)) continue;
            d = nail.getX() + 4.0;
        }
        this.guard.workOutMinsAndMaxs();
        this.sync.workOutMinsAndMaxs();
        this.probability.workOutMinsAndMaxs();
        this.assignment.workOutMinsAndMaxs();
        if (this.guard.getMaxX() > d) {
            d = this.guard.getMaxX();
        }
        if (this.sync.getMaxX() > d) {
            d = this.sync.getMaxX();
        }
        if (this.probability.getMaxX() > d) {
            d = this.probability.getMaxX();
        }
        if (this.assignment.getMaxX() > d) {
            d = this.assignment.getMaxX();
        }
        return d;
    }

    public double getMinY() {
        double d = this.from.getY() - 10.0;
        if (this.to.getY() - 15.0 < d) {
            d = this.to.getY() - 15.0 + 10.0;
        }
        for (int i = 0; i < this.getNumNails(); ++i) {
            Nail nail = this.getNail(i);
            if (!(nail.getY() - 4.0 < d)) continue;
            d = nail.getY() - 4.0;
        }
        this.guard.workOutMinsAndMaxs();
        this.sync.workOutMinsAndMaxs();
        this.probability.workOutMinsAndMaxs();
        this.assignment.workOutMinsAndMaxs();
        if (this.guard.getMinY() < d) {
            d = this.guard.getMinY();
        }
        if (this.sync.getMinY() < d) {
            d = this.sync.getMinY();
        }
        if (this.probability.getMinY() < d) {
            d = this.probability.getMinY();
        }
        if (this.assignment.getMinY() < d) {
            d = this.assignment.getMinY();
        }
        return d;
    }

    public double getMaxY() {
        double d = this.from.getY() + 15.0 + 10.0;
        if (this.to.getY() + 15.0 + 10.0 > d) {
            d = this.to.getY() + 15.0 + 10.0;
        }
        for (int i = 0; i < this.getNumNails(); ++i) {
            Nail nail = this.getNail(i);
            if (!(nail.getY() + 4.0 > d)) continue;
            d = nail.getY() + 4.0;
        }
        this.guard.workOutMinsAndMaxs();
        this.sync.workOutMinsAndMaxs();
        this.probability.workOutMinsAndMaxs();
        this.assignment.workOutMinsAndMaxs();
        if (this.guard.getMaxY() > d) {
            d = this.guard.getMaxY();
        }
        if (this.sync.getMaxY() > d) {
            d = this.sync.getMaxY();
        }
        if (this.probability.getMaxY() > d) {
            d = this.probability.getMaxY();
        }
        if (this.assignment.getMaxY() > d) {
            d = this.assignment.getMaxY();
        }
        return d;
    }

    public boolean isDocked() {
        return this.docked;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        this.intersects = new ArrayList();
        boolean bl = false;
        double d = this.from.getX() + this.from.getWidth() / 2.0;
        double d2 = this.from.getY() + this.from.getWidth() / 2.0;
        for (int i = 0; i < this.nails.size(); ++i) {
            double d3 = ((Nail)this.nails.get(i)).getX();
            double d4 = ((Nail)this.nails.get(i)).getY();
            this.intersects.add(new Line2D.Double(d, d2, d3, d4));
            if (new Line2D.Double(d, d2, d3, d4).intersects(rectangle2D)) {
                bl = true;
                break;
            }
            d = d3;
            d2 = d4;
        }
        this.intersects.add(new Line2D.Double(d, d2, this.to.getX() + this.to.getWidth() / 2.0, this.to.getY() + this.to.getWidth() / 2.0));
        if (new Line2D.Double(d, d2, this.to.getX() + this.to.getWidth() / 2.0, this.to.getY() + this.to.getWidth() / 2.0).intersects(rectangle2D)) {
            bl = true;
        }
        return bl;
    }

    public void deleteNail(Nail nail) {
        this.nails.remove(nail);
        nail.disassociateTransition(this);
    }

    public void setGuard(String string) {
        this.guard.setString(string);
    }

    public void setSync(String string) {
        this.sync.setString(string);
    }

    public void setAssignment(String string) {
        this.assignment.setString(string);
    }

    public void setProbability(String string) {
        this.probability.setString(string);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setTo(State state) {
        this.to = state;
    }

    public void setDocked(boolean bl) {
        this.docked = bl;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void workOutMiddle() {
        double d;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        double d2 = this.from.getX() + 15.0;
        double d3 = this.from.getY() + 15.0;
        double d4 = this.from.getGridWidth();
        double d5 = this.from.getSubdivisions();
        double d6 = this.from.getMovingOffset();
        if (this.from.isMovingSnap()) {
            if (this.from instanceof Decision) {
                d2 += 3.0;
                d2 /= d4 / d5;
                d2 = Math.round(d2);
                d2 *= d4 / d5;
                d2 -= 3.0;
                d3 += 3.0;
                d3 /= d4 / d5;
                d3 = Math.round(d3);
                d3 *= d4 / d5;
                d3 -= 3.0;
            } else {
                d2 -= d6;
                d2 /= d4 / d5;
                d2 = Math.round(d2);
                d2 *= d4 / d5;
                d2 += d6;
                d3 -= d6;
                d3 /= d4 / d5;
                d3 = Math.round(d3);
                d3 *= d4 / d5;
                d3 += d6;
            }
        }
        arrayList.add(new Point((int)d2, (int)d3));
        for (int i = 0; i < this.nails.size(); ++i) {
            Nail nail = (Nail)this.nails.get(i);
            d = nail.getX();
            double d7 = nail.getY();
            d4 = nail.getGridWidth();
            d5 = nail.getSubdivisions();
            d6 = nail.getMovingOffset();
            if (nail.isMovingSnap()) {
                d -= d6;
                d /= d4 / d5;
                d = Math.round(d);
                d *= d4 / d5;
                d += d6;
                d7 -= d6;
                d7 /= d4 / d5;
                d7 = Math.round(d7);
                d7 *= d4 / d5;
                d7 += d6;
            }
            arrayList.add(new Point((int)d, (int)d7));
        }
        double d8 = this.to.getX() + 15.0;
        d = this.to.getY() + 15.0;
        d4 = this.to.getGridWidth();
        d5 = this.to.getSubdivisions();
        d6 = this.to.getMovingOffset();
        if (this.to.isMovingSnap()) {
            if (this.to instanceof Decision) {
                d8 += 3.0;
                d8 /= d4 / d5;
                d8 = Math.round(d8);
                d8 *= d4 / d5;
                d8 -= 3.0;
                d += 3.0;
                d /= d4 / d5;
                d = Math.round(d);
                d *= d4 / d5;
                d -= 3.0;
            } else {
                d8 -= d6;
                d8 /= d4 / d5;
                d8 = Math.round(d8);
                d8 *= d4 / d5;
                d8 += d6;
                d -= d6;
                d /= d4 / d5;
                d = Math.round(d);
                d *= d4 / d5;
                d += d6;
            }
        }
        arrayList.add(new Point((int)d8, (int)d));
        try {
            double d9;
            Point point = null;
            double d10 = 0.0;
            for (int i = 0; i < arrayList.size(); ++i) {
                Point point2 = (Point)arrayList.get(i);
                if (point != null) {
                    d10 += Math.sqrt(Math.pow(point2.x - point.x, 2.0) + Math.pow(point2.y - point.y, 2.0));
                }
                point = point2;
            }
            double d11 = d10 / 2.0;
            int n = 0;
            double d12 = 0.0;
            point = (Point)arrayList.get(0);
            Point point3 = (Point)arrayList.get(0);
            for (d9 = 0.0; d9 <= d11; d9 += d12) {
                point = point3;
                point3 = (Point)arrayList.get(++n);
                d12 = Math.sqrt(Math.pow(point3.x - point.x, 2.0) + Math.pow(point3.y - point.y, 2.0));
            }
            double d13 = (d11 - (d9 - d12)) / d12;
            double d14 = (double)point.x + (double)(point3.x - point.x) * d13;
            double d15 = (double)point.y + (double)(point3.y - point.y) * d13;
            this.middle = new Point((int)d14, (int)d15);
        }
        catch (Exception exception) {
            Rectangle2D rectangle2D = this.getBounds2D();
            this.middle = new Point((int)(rectangle2D.getX() + rectangle2D.getWidth() / 2.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0));
        }
    }

    public Nail addNail(double d, double d2) {
        State state = this.from;
        State state2 = null;
        boolean bl = false;
        int n = 0;
        for (n = 0; n < this.nails.size(); ++n) {
            state2 = (Nail)this.nails.get(n);
            if (Transition.liesBetween(d, d2, state, state2)) {
                bl = true;
                break;
            }
            state = state2;
        }
        if (!bl) {
            state2 = this.to;
            if (Transition.liesBetween(d, d2, state, this.to)) {
                bl = true;
            }
        }
        Nail nail = null;
        if (bl) {
            nail = new Nail(d, d2, state, state2);
            this.nails.add(n, nail);
        } else {
            nail = new Nail(d, d2, state, state2);
            this.nails.add(nail);
        }
        nail.associateTransition(this);
        return nail;
    }

    public void render(Graphics2D graphics2D) {
        this.render(graphics2D, false);
    }

    public void render(Graphics2D graphics2D, boolean bl) {
        this.intersects(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0));
        if (this.docked) {
            double d;
            double d2;
            double d3;
            double d4;
            int n;
            double d5;
            double d6 = this.from.getWidth() / 2.0;
            double d7 = this.to.getWidth() / 2.0;
            double d8 = this.from.getX() + d6;
            double d9 = this.from.getY() + d6;
            double d10 = this.from.getGridWidth();
            double d11 = this.from.getSubdivisions();
            double d12 = this.from.getMovingOffset();
            double d13 = Double.NEGATIVE_INFINITY;
            double d14 = Double.NEGATIVE_INFINITY;
            double d15 = Double.POSITIVE_INFINITY;
            double d16 = Double.POSITIVE_INFINITY;
            PointList pointList = new PointList();
            if (this.from.isMovingSnap()) {
                if (this.from instanceof Decision) {
                    d8 /= d10 / d11;
                    d8 = Math.round(d8);
                    d8 *= d10 / d11;
                    d9 /= d10 / d11;
                    d9 = Math.round(d9);
                    d9 *= d10 / d11;
                } else {
                    d8 -= d12;
                    d8 /= d10 / d11;
                    d8 = Math.round(d8);
                    d8 *= d10 / d11;
                    d8 += d12;
                    d9 -= d12;
                    d9 /= d10 / d11;
                    d9 = Math.round(d9);
                    d9 *= d10 / d11;
                    d9 += d12;
                }
            }
            pointList.add(new TempPoint(d8, d9));
            for (int i = 0; i < this.nails.size(); ++i) {
                Nail nail = (Nail)this.nails.get(i);
                d5 = nail.getX();
                double d17 = nail.getY();
                d11 = nail.getSubdivisions();
                d12 = nail.getMovingOffset();
                d10 = nail.getGridWidth();
                if (nail.isMovingSnap()) {
                    d5 /= d10 / d11;
                    d5 = Math.round(d5);
                    d5 *= d10 / d11;
                    d17 /= d10 / d11;
                    d17 = Math.round(d17);
                    d17 *= d10 / d11;
                }
                if (this.selected) {
                    graphics2D.setColor(Color.green);
                } else {
                    graphics2D.setColor(Color.black);
                }
                pointList.add(new TempPoint(d5, d17));
                d8 = d5;
                d9 = d17;
            }
            if (this.selected) {
                graphics2D.setColor(Color.green);
            } else {
                graphics2D.setColor(Color.black);
            }
            double d18 = this.to.getX() + d7;
            d5 = this.to.getY() + d7;
            d12 = this.to.getMovingOffset();
            d10 = this.to.getGridWidth();
            d11 = this.to.getSubdivisions();
            if (this.to.isMovingSnap()) {
                if (this.to instanceof Decision) {
                    d18 /= d10 / d11;
                    d18 = Math.round(d18);
                    d18 *= d10 / d11;
                    d5 /= d10 / d11;
                    d5 = Math.round(d5);
                    d5 *= d10 / d11;
                } else {
                    d18 -= d12;
                    d18 /= d10 / d11;
                    d18 = Math.round(d18);
                    d18 *= d10 / d11;
                    d18 += d12;
                    d5 -= d12;
                    d5 /= d10 / d11;
                    d5 = Math.round(d5);
                    d5 *= d10 / d11;
                    d5 += d12;
                }
            }
            pointList.add(new TempPoint(d18, d5));
            TempPoint tempPoint = null;
            TempPoint tempPoint2 = null;
            TempPoint tempPoint3 = null;
            TempPoint tempPoint4 = null;
            double d19 = 8.0;
            GeneralPath generalPath = new GeneralPath();
            for (n = 0; n < pointList.size() + 1; ++n) {
                double d20;
                double d21;
                double d22;
                double d23;
                double d24;
                double d25;
                double d26;
                double d27;
                double d28;
                double d29;
                tempPoint = tempPoint2;
                tempPoint2 = tempPoint3;
                tempPoint3 = tempPoint4;
                try {
                    tempPoint4 = pointList.getPoint(n);
                    while (tempPoint3 != null && tempPoint4.x == tempPoint3.x && tempPoint4.y == tempPoint3.y) {
                        tempPoint4 = pointList.getPoint(++n);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    tempPoint4 = null;
                }
                if (tempPoint2 == null) continue;
                if (tempPoint4 == null && tempPoint == null) {
                    generalPath.moveTo((float)tempPoint2.x, (float)tempPoint2.y);
                    generalPath.lineTo((float)tempPoint3.x, (float)tempPoint3.y);
                    continue;
                }
                if (tempPoint4 == null) {
                    generalPath.lineTo((float)tempPoint3.x, (float)tempPoint3.y);
                    continue;
                }
                if (tempPoint == null) {
                    d29 = tempPoint2.y - tempPoint3.y;
                    d28 = tempPoint2.x - tempPoint3.x;
                    d4 = Math.atan(d29 / d28);
                    d27 = d19 * Math.cos(d4);
                    d26 = d19 * Math.sin(d4);
                    if (d28 >= 0.0) {
                        d27 *= -1.0;
                        d26 *= -1.0;
                    }
                    d29 = tempPoint3.y - tempPoint4.y;
                    d28 = tempPoint3.x - tempPoint4.x;
                    d4 = Math.atan(d29 / d28);
                    d25 = d19 * Math.cos(d4);
                    d24 = d19 * Math.sin(d4);
                    if (d28 >= 0.0) {
                        d25 *= -1.0;
                        d24 *= -1.0;
                    }
                    d23 = tempPoint3.x - d27;
                    d22 = tempPoint3.y - d26;
                    d3 = tempPoint3.x + d25;
                    d2 = tempPoint3.y + d24;
                    d21 = tempPoint3.x;
                    d20 = tempPoint3.y;
                    generalPath.moveTo((float)tempPoint2.x, (float)tempPoint2.y);
                    generalPath.lineTo((float)d23, (float)d22);
                    generalPath.quadTo((float)d21, (float)d20, (float)d3, (float)d2);
                    continue;
                }
                d29 = tempPoint2.y - tempPoint3.y;
                d28 = tempPoint2.x - tempPoint3.x;
                double d30 = Math.sqrt(Math.pow(d29, 2.0) + Math.pow(d28, 2.0));
                if (d30 <= 2.0 * d19) {
                    d19 = d30 / 2.0;
                }
                d29 = tempPoint2.y - tempPoint3.y;
                d28 = tempPoint2.x - tempPoint3.x;
                d4 = Math.atan(d29 / d28);
                d27 = d19 * Math.cos(d4);
                d26 = d19 * Math.sin(d4);
                if (d28 >= 0.0) {
                    d27 *= -1.0;
                    d26 *= -1.0;
                }
                d29 = tempPoint3.y - tempPoint4.y;
                d28 = tempPoint3.x - tempPoint4.x;
                d4 = Math.atan(d29 / d28);
                d25 = d19 * Math.cos(d4);
                d24 = d19 * Math.sin(d4);
                if (d28 >= 0.0) {
                    d25 *= -1.0;
                    d24 *= -1.0;
                }
                d23 = tempPoint3.x - d27;
                d22 = tempPoint3.y - d26;
                d3 = tempPoint3.x + d25;
                d2 = tempPoint3.y + d24;
                d21 = tempPoint3.x;
                d20 = tempPoint3.y;
                generalPath.lineTo((float)d23, (float)d22);
                generalPath.quadTo((float)d21, (float)d20, (float)d3, (float)d2);
                d19 = 8.0;
            }
            graphics2D.draw(generalPath);
            for (n = 0; n < this.nails.size(); ++n) {
                Nail nail = (Nail)this.nails.get(n);
                double d31 = nail.getX();
                d = nail.getY();
                d12 = nail.getMovingOffset();
                d10 = nail.getGridWidth();
                d11 = nail.getSubdivisions();
                if (nail.isMovingSnap()) {
                    d31 /= d10 / d11;
                    d31 = Math.round(d31);
                    d31 *= d10 / d11;
                    d /= d10 / d11;
                    d = Math.round(d);
                    d *= d10 / d11;
                }
                if (!nail.isSelected() && !nail.isHighlighted()) continue;
                graphics2D.setColor(Color.white);
                graphics2D.fill(new Ellipse2D.Double(d31 - 2.0, d - 2.0, 4.0, 4.0));
                if (nail.isHighlighted()) {
                    graphics2D.setColor(Color.black);
                } else {
                    graphics2D.setColor(Color.green);
                }
                graphics2D.draw(new Ellipse2D.Double(d31 - 2.0, d - 2.0, 4.0, 4.0));
                graphics2D.setColor(Color.black);
            }
            if (this.isSelected()) {
                graphics2D.setColor(Color.green);
            } else {
                graphics2D.setColor(Color.black);
            }
            d18 = this.to.getX();
            d5 = this.to.getY();
            if (this.to.isMovingSnap()) {
                d18 /= d10 / d11;
                d18 = Math.round(d18);
                d18 *= d10 / d11;
                d5 /= d10 / d11;
                d5 = Math.round(d5);
                d5 *= d10 / d11;
            }
            if (!(this.to instanceof Decision)) {
                d4 = 20.0;
                double d32 = 10.0;
                int n2 = 1;
                int n3 = 1;
                d = Math.PI;
                double d33 = Math.PI;
                if (d8 < d18 + d7) {
                    n2 = -1;
                    n3 = -1;
                    d = 0.0;
                    d33 = 0.0;
                }
                double d34 = Math.atan((d9 - (d5 + d7)) / (d8 - (d18 + d7)));
                d3 = Math.cos(d34) * d7 * (double)n2 + d18 + d7;
                d2 = Math.sin(d34) * d7 * (double)n3 + d5 + d7;
                double d35 = d3 - d32 * Math.sin(Math.toRadians(90.0 - d4) - (d34 + d));
                double d36 = d2 - d32 * Math.cos(Math.toRadians(90.0 - d4) - (d34 + d33));
                double d37 = d3 + d32 * Math.sin(d34 + Math.toRadians(90.0 - d4) + Math.abs(d - Math.PI));
                double d38 = d2 - d32 * Math.cos(d34 + Math.toRadians(90.0 - d4) + Math.abs(d33 - Math.PI));
                int[] nArray = new int[]{(int)d3, (int)d35, (int)d37};
                int[] nArray2 = new int[]{(int)d2, (int)d36, (int)d38};
                graphics2D.fill(new Polygon(nArray, nArray2, 3));
            }
            this.workOutMiddle();
            this.probability.render(graphics2D, this.middle.getX(), this.middle.getY(), bl);
            this.sync.render(graphics2D, this.middle.getX(), this.middle.getY(), bl);
            this.guard.render(graphics2D, this.middle.getX(), this.middle.getY(), bl);
            this.assignment.render(graphics2D, this.middle.getX(), this.middle.getY(), bl);
        }
    }

    private static boolean liesBetween(double d, double d2, State state, State state2) {
        double d3 = state.getX();
        double d4 = state.getY();
        double d5 = state2.getX();
        double d6 = state2.getY();
        Line2D.Double double_ = new Line2D.Double(d3 += state.width / 2.0, d4 += state.height / 2.0, d5 += state2.width / 2.0, d6 += state2.height / 2.0);
        return double_.intersects(d - 4.0, d2 - 4.0, 8.0, 8.0);
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof PropertyOwner) {
            PropertyOwner propertyOwner = (PropertyOwner)object;
            if (this.getUniquePropertyID() < propertyOwner.getUniquePropertyID()) {
                return -1;
            }
            if (this.getUniquePropertyID() > propertyOwner.getUniquePropertyID()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public String getClassDescriptor() {
        if (this.to instanceof Decision) {
            return "Branched Transition";
        }
        return "Transition";
    }

    @Override
    public String getDescriptor() {
        if (this.to instanceof Decision) {
            return "from " + this.from.getDescriptor() + " to many";
        }
        return "from " + this.from.getDescriptor() + " to " + this.to.getDescriptor();
    }

    @Override
    public int getNumProperties() {
        if (this.to instanceof Decision) {
            return 2;
        }
        return 4;
    }

    @Override
    public SingleProperty getProperty(int n) {
        switch (n) {
            case 0: {
                return this.sync;
            }
            case 1: {
                return this.guard;
            }
            case 2: {
                return this.probability;
            }
        }
        return this.assignment;
    }

    @Override
    public int getUniquePropertyID() {
        if (this.to instanceof Decision) {
            return 5;
        }
        return 1;
    }

    @Override
    public void registerObserver(Observer observer) {
        this.guard.addObserver(observer);
        this.sync.addObserver(observer);
        this.probability.addObserver(observer);
        this.assignment.addObserver(observer);
    }

    class PointList
    extends ArrayList {
        public TempPoint getPoint(int n) {
            return (TempPoint)this.get(n);
        }

        public double getX(int n) {
            return this.getPoint((int)n).x;
        }

        public double getY(int n) {
            return this.getPoint((int)n).y;
        }
    }

    class TempPoint {
        double x;
        double y;

        public TempPoint(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }
}

