/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Observer;
import userinterface.model.graphicModel.StringLabel;
import userinterface.model.graphicModel.Transition;
import userinterface.util.BooleanProperty;
import userinterface.util.DoubleProperty;
import userinterface.util.PropertyOwner;
import userinterface.util.SingleProperty;

public class State
implements PropertyOwner {
    private StringLabel comment;
    private BooleanProperty initial;
    protected DoubleProperty x;
    protected DoubleProperty y;
    protected double width;
    protected double height;
    private String descriptor;
    private Color theColour;
    protected boolean selected;
    protected boolean highlighted;
    protected boolean movingSnap;
    protected double movingOffset;
    protected double movingSubdivisions;
    protected double gridWidth;
    private ArrayList associatedTransitions;

    public State(double d, double d2, double d3, double d4) {
        this.x = new DoubleProperty((PropertyOwner)this, "x", d, "The screen x-coordinate");
        this.y = new DoubleProperty((PropertyOwner)this, "y", d2, "The screen y-coordinate");
        this.width = d3;
        this.height = d4;
        this.associatedTransitions = new ArrayList();
        this.descriptor = "0";
        this.comment = new StringLabel("", this, "Comment", true, "An optional description of this state");
        this.initial = new BooleanProperty((PropertyOwner)this, "Initial", false, "If true, the graphical state variable's initial value is set to the index of this state.");
        this.selected = true;
        this.theColour = new Color(175, 238, 238);
        this.movingSnap = false;
    }

    public State(double d, double d2) {
        this(d, d2, 30.0, 30.0);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.x.getValue(), this.y.getValue(), this.width, this.height);
    }

    public boolean isInitial() {
        return this.initial.getBoolValue();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public BooleanProperty getInitialProperty() {
        return this.initial;
    }

    public String getComment() {
        return this.comment.getProperty().toString();
    }

    public double getX() {
        return this.x.getValue();
    }

    public double getY() {
        return this.y.getValue();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public StringLabel getCommentLabel() {
        return this.comment;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()).intersects(rectangle2D);
    }

    public void associateTransition(Transition transition) {
        this.associatedTransitions.add(transition);
    }

    public void disassociateTransition(Transition transition) {
        this.associatedTransitions.remove(transition);
    }

    public void setPosition(double d, double d2) {
        this.x.setValue(d);
        this.y.setValue(d2);
    }

    public void setComment(String string) {
        this.comment.setString(string);
    }

    public void setInitial(boolean bl) {
        this.initial.setBoolValue(bl);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void movingSnap(double d, double d2, double d3) {
        this.movingSnap = true;
        this.movingOffset = d;
        this.movingSubdivisions = d3;
        this.gridWidth = d2;
    }

    public void stopMoving() {
        this.movingSnap = false;
    }

    public void move(double d, double d2) {
        this.x.setValue(this.getX() + d, false);
        this.y.setValue(this.getY() + d2, false);
    }

    public boolean isMovingSnap() {
        return this.movingSnap;
    }

    public double getGridWidth() {
        return this.gridWidth;
    }

    public double getSubdivisions() {
        return this.movingSubdivisions;
    }

    public double getMovingOffset() {
        return this.movingOffset;
    }

    public double getMinX() {
        double d = this.x.getValue() - 8.0;
        for (int i = 0; i < this.associatedTransitions.size(); ++i) {
            Transition transition = (Transition)this.associatedTransitions.get(i);
            if (!(transition.getMinX() < d)) continue;
            d = transition.getMinX();
        }
        this.comment.workOutMinsAndMaxs();
        if (this.comment.getMinX() < d) {
            d = this.comment.getMinX();
        }
        return d;
    }

    public double getMinY() {
        double d = this.y.getValue() - 8.0;
        for (int i = 0; i < this.associatedTransitions.size(); ++i) {
            Transition transition = (Transition)this.associatedTransitions.get(i);
            if (!(transition.getMinY() < d)) continue;
            d = transition.getMinY();
        }
        this.comment.workOutMinsAndMaxs();
        if (this.comment.getMinY() < d) {
            d = this.comment.getMinY();
        }
        return d;
    }

    public double getMaxX() {
        double d = this.x.getValue() + this.width + 8.0;
        for (int i = 0; i < this.associatedTransitions.size(); ++i) {
            Transition transition = (Transition)this.associatedTransitions.get(i);
            if (!(transition.getMaxX() > d)) continue;
            d = transition.getMaxX();
        }
        this.comment.workOutMinsAndMaxs();
        if (this.comment.getMaxX() > d) {
            d = this.comment.getMaxX();
        }
        return d;
    }

    public double getMaxY() {
        double d = this.y.getValue() + this.height + 8.0;
        for (int i = 0; i < this.associatedTransitions.size(); ++i) {
            Transition transition = (Transition)this.associatedTransitions.get(i);
            if (!(transition.getMaxY() > d)) continue;
            d = transition.getMaxY();
        }
        this.comment.workOutMinsAndMaxs();
        if (this.comment.getMaxY() > d) {
            d = this.comment.getMaxY();
        }
        return d;
    }

    public void render(Graphics2D graphics2D, int n) {
        this.render(graphics2D, n, false);
    }

    public void render(Graphics2D graphics2D, int n, boolean bl) {
        double d = this.getX();
        double d2 = this.getY();
        if (this.movingSnap) {
            d -= this.movingOffset;
            d /= this.gridWidth / this.movingSubdivisions;
            d = Math.round(d);
            d *= this.gridWidth / this.movingSubdivisions;
            d += this.movingOffset;
            d2 -= this.movingOffset;
            d2 /= this.gridWidth / this.movingSubdivisions;
            d2 = Math.round(d2);
            d2 *= this.gridWidth / this.movingSubdivisions;
            d2 += this.movingOffset;
        }
        graphics2D.setColor(this.theColour);
        Ellipse2D.Double double_ = new Ellipse2D.Double(d, d2, this.getWidth(), this.getHeight());
        graphics2D.fill(double_);
        if (this.selected) {
            graphics2D.setColor(Color.green);
        } else {
            graphics2D.setColor(Color.black);
        }
        graphics2D.draw(double_);
        String string = "" + n;
        float f = graphics2D.getFont().getSize2D() * (float)string.length() * 0.64285713f / 2.0f;
        float f2 = graphics2D.getFont().getSize2D() * 0.85714287f / 2.0f;
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, (float)d + 15.0f - f, (float)d2 + 15.0f + f2);
        if (this.isInitial()) {
            if (this.selected) {
                graphics2D.setColor(Color.green);
            } else {
                graphics2D.setColor(Color.black);
            }
            graphics2D.draw(new Ellipse2D.Double(d + 5.0, d2 + 5.0, this.getWidth() - 10.0, this.getHeight() - 10.0));
        }
        this.comment.render(graphics2D, d, d2, bl);
    }

    public void setDescriptor(int n) {
        this.descriptor = "" + n;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof PropertyOwner) {
            PropertyOwner propertyOwner = (PropertyOwner)object;
            if (this.getUniquePropertyID() < propertyOwner.getUniquePropertyID()) {
                return -1;
            }
            if (this.getUniquePropertyID() > propertyOwner.getUniquePropertyID()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public String getClassDescriptor() {
        return "State";
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int getNumProperties() {
        return 4;
    }

    @Override
    public SingleProperty getProperty(int n) {
        switch (n) {
            case 0: {
                return this.initial;
            }
            case 1: {
                return this.comment;
            }
            case 2: {
                return this.x;
            }
        }
        return this.y;
    }

    @Override
    public int getUniquePropertyID() {
        return 0;
    }

    @Override
    public void registerObserver(Observer observer) {
        this.comment.addObserver(observer);
        this.initial.addObserver(observer);
        this.x.addObserver(observer);
        this.y.addObserver(observer);
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }
}

