/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Observer;
import prism.Prism;
import userinterface.model.graphicModel.ExpressionLabel;
import userinterface.model.graphicModel.Nail;
import userinterface.model.graphicModel.State;
import userinterface.model.graphicModel.Transition;
import userinterface.util.SingleProperty;

public class ProbTransition
extends Transition {
    private ExpressionLabel probability;

    public ProbTransition(State state, State state2, Prism prism) {
        super(state, state2, prism);
        this.probability = new ExpressionLabel("", this, "Probability", true, "A Boolean expression describing the probability of this choice.", prism);
        this.probability.setOffsetX(-10.0);
        this.probability.setOffsetY(0.0);
    }

    public ProbTransition(State state, State state2, ArrayList arrayList, Prism prism) {
        super(state, state2, arrayList, prism);
        this.probability = new ExpressionLabel("", this, prism);
        this.probability.setOffsetX(-10.0);
        this.probability.setOffsetY(0.0);
    }

    public String getProbability() {
        return this.probability.getString();
    }

    @Override
    public ExpressionLabel getProbabilityLabel() {
        return this.probability;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        boolean bl = false;
        double d = this.from.getX() + 2.5;
        double d2 = this.from.getY() + 2.5;
        for (int i = 0; i < this.nails.size(); ++i) {
            double d3;
            double d4 = ((Nail)this.nails.get(i)).getX();
            if (new Line2D.Double(d, d2, d4, d3 = ((Nail)this.nails.get(i)).getY()).intersects(rectangle2D)) {
                bl = true;
                break;
            }
            d = d4;
            d2 = d3;
        }
        if (new Line2D.Double(d, d2, this.to.getX() + 15.0, this.to.getY() + 15.0).intersects(rectangle2D)) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void setProbability(String string) {
        this.probability.setString(string);
    }

    @Override
    public void render(Graphics2D graphics2D) {
        this.render(graphics2D, false);
    }

    @Override
    public void render(Graphics2D graphics2D, boolean bl) {
        float[] fArray = new float[]{5.0f, 2.0f};
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, fArray, 0.0f));
        super.render(graphics2D, bl);
        graphics2D.setStroke(new BasicStroke());
        this.probability.render(graphics2D, this.middle.getX(), this.middle.getY(), bl);
    }

    @Override
    public String getClassDescriptor() {
        return "Probabilistic Choice";
    }

    @Override
    public String getDescriptor() {
        return "to " + this.to.getDescriptor();
    }

    @Override
    public int getNumProperties() {
        return 2;
    }

    @Override
    public SingleProperty getProperty(int n) {
        switch (n) {
            case 0: {
                return this.probability;
            }
        }
        return this.getAssignmentLabel();
    }

    @Override
    public void registerObserver(Observer observer) {
        super.registerObserver(observer);
        this.probability.addObserver(observer);
    }

    @Override
    public int getUniquePropertyID() {
        return 4;
    }

    @Override
    public double getMinX() {
        double d = super.getMinX();
        this.probability.workOutMinsAndMaxs();
        if (this.probability.getMinX() < d) {
            d = this.probability.getMinX();
        }
        return d;
    }

    @Override
    public double getMinY() {
        double d = super.getMinY();
        this.probability.workOutMinsAndMaxs();
        if (this.probability.getMinY() < d) {
            d = this.probability.getMinY();
        }
        return d;
    }

    @Override
    public double getMaxX() {
        double d = super.getMaxX();
        this.probability.workOutMinsAndMaxs();
        if (this.probability.getMaxX() > d) {
            d = this.probability.getMaxX();
        }
        return d;
    }

    @Override
    public double getMaxY() {
        double d = super.getMaxY();
        if (this.probability.getMaxY() > d) {
            d = this.probability.getMaxY();
        }
        return d;
    }
}

