/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import userinterface.GUIPrism;
import userinterface.model.graphicModel.GUIGraphicModelEditor;
import userinterface.model.graphicModel.GraphicModuleContainer;
import userinterface.model.graphicModel.ModuleDrawingPane;
import userinterface.model.graphicModel.ModuleModel;

public class ModulesPanel
extends JPanel
implements MouseListener,
ComponentListener {
    private ArrayList containers = new ArrayList();
    private ArrayList showChecks = new ArrayList();
    private ArrayList dockChecks = new ArrayList();
    private GUIPrism gui;
    private GUIGraphicModelEditor gme;
    private JDesktopPane dp;
    private JScrollPane scr;
    private JTabbedPane tp;
    private boolean autolayout;
    private JPopupMenu popup;
    private JMenu show;
    private JMenu dock;
    private JMenu layout;
    private JCheckBoxMenuItem autol;
    private Action tile;
    private Action cascade;
    private Action addModule;

    public ModulesPanel(GUIPrism gUIPrism, GUIGraphicModelEditor gUIGraphicModelEditor) {
        this.gui = gUIPrism;
        this.gme = gUIGraphicModelEditor;
        this.autolayout = true;
        this.addComponentListener(this);
        this.initComponents();
    }

    public void newModel() {
        this.dp.removeAll();
        this.containers = new ArrayList();
        this.showChecks = new ArrayList();
        this.dockChecks = new ArrayList();
        this.autolayout = true;
        this.repaint();
    }

    public void addModule(ModuleModel moduleModel) {
        ModuleDrawingPane moduleDrawingPane = new ModuleDrawingPane(moduleModel);
        moduleModel.addObserver(moduleDrawingPane);
        GraphicModuleContainer graphicModuleContainer = new GraphicModuleContainer(this.gui, moduleModel, moduleDrawingPane, this);
        this.containers.add(graphicModuleContainer);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(graphicModuleContainer.getName());
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (jCheckBoxMenuItem.isSelected()) {
                    ModulesPanel.this.a_show(ModulesPanel.this.getModuleContainer(jCheckBoxMenuItem.getText()));
                } else {
                    ModulesPanel.this.a_hide(ModulesPanel.this.getModuleContainer(jCheckBoxMenuItem.getText()));
                }
            }
        });
        jCheckBoxMenuItem.setSelected(true);
        this.showChecks.add(jCheckBoxMenuItem);
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(graphicModuleContainer.getName());
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (jCheckBoxMenuItem.isSelected()) {
                    ModulesPanel.this.a_dock(ModulesPanel.this.getModuleContainer(jCheckBoxMenuItem.getText()));
                } else {
                    ModulesPanel.this.a_undock(ModulesPanel.this.getModuleContainer(jCheckBoxMenuItem.getText()));
                }
            }
        });
        jCheckBoxMenuItem2.setSelected(true);
        this.dockChecks.add(jCheckBoxMenuItem2);
        this.show.add((Component)jCheckBoxMenuItem, this.containers.size() - 1);
        this.dock.add((Component)jCheckBoxMenuItem2, this.containers.size() - 1);
        this.autoLayout();
    }

    public void removeModule(ModuleModel moduleModel) {
        GraphicModuleContainer graphicModuleContainer = this.getModuleContainer(moduleModel);
        JCheckBoxMenuItem jCheckBoxMenuItem = this.getModuleDockCheck(moduleModel);
        JCheckBoxMenuItem jCheckBoxMenuItem2 = this.getModuleShowCheck(moduleModel);
        graphicModuleContainer.getInternalFrame().setVisible(false);
        this.containers.remove(graphicModuleContainer);
        this.dockChecks.remove(jCheckBoxMenuItem);
        this.showChecks.remove(jCheckBoxMenuItem2);
        this.show.remove(jCheckBoxMenuItem2);
        this.dock.remove(jCheckBoxMenuItem);
    }

    public ModuleModel getModuleModel(int n) {
        return ((GraphicModuleContainer)this.containers.get(n)).getModuleModel();
    }

    public GraphicModuleContainer getModuleContainer(String string) {
        GraphicModuleContainer graphicModuleContainer = null;
        for (int i = 0; i < this.containers.size(); ++i) {
            GraphicModuleContainer graphicModuleContainer2 = (GraphicModuleContainer)this.containers.get(i);
            if (!graphicModuleContainer2.getName().equals(string)) continue;
            graphicModuleContainer = graphicModuleContainer2;
            break;
        }
        return graphicModuleContainer;
    }

    public GraphicModuleContainer getModuleContainer(ModuleModel moduleModel) {
        GraphicModuleContainer graphicModuleContainer = null;
        for (int i = 0; i < this.containers.size(); ++i) {
            GraphicModuleContainer graphicModuleContainer2 = (GraphicModuleContainer)this.containers.get(i);
            if (graphicModuleContainer2.getModuleModel() != moduleModel) continue;
            graphicModuleContainer = graphicModuleContainer2;
            break;
        }
        return graphicModuleContainer;
    }

    public JCheckBoxMenuItem getModuleDockCheck(ModuleModel moduleModel) {
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        for (int i = 0; i < this.dockChecks.size(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem2 = (JCheckBoxMenuItem)this.dockChecks.get(i);
            if (!jCheckBoxMenuItem2.getText().equals(moduleModel.getModuleName())) continue;
            jCheckBoxMenuItem = jCheckBoxMenuItem2;
            break;
        }
        return jCheckBoxMenuItem;
    }

    public JCheckBoxMenuItem getModuleShowCheck(ModuleModel moduleModel) {
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        for (int i = 0; i < this.showChecks.size(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem2 = (JCheckBoxMenuItem)this.showChecks.get(i);
            if (!jCheckBoxMenuItem2.getText().equals(moduleModel.getModuleName())) continue;
            jCheckBoxMenuItem = jCheckBoxMenuItem2;
            break;
        }
        return jCheckBoxMenuItem;
    }

    public GraphicModuleContainer getModuleContainer(int n) {
        return (GraphicModuleContainer)this.containers.get(n);
    }

    public int getNumModules() {
        return this.containers.size();
    }

    public void next() {
        JInternalFrame jInternalFrame = this.dp.getSelectedFrame();
        JInternalFrame jInternalFrame2 = null;
        for (int i = 0; i < this.containers.size(); ++i) {
            GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i);
            if (!graphicModuleContainer.isDocked() || graphicModuleContainer.getInternalFrame() != jInternalFrame) continue;
            if (++i == this.containers.size()) {
                i = 0;
            }
            while (true) {
                if ((graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i)).isDocked()) {
                    jInternalFrame2 = graphicModuleContainer.getInternalFrame();
                    try {
                        jInternalFrame2.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    return;
                }
                if (++i != this.containers.size()) continue;
                i = 0;
            }
        }
    }

    public void previous() {
        JInternalFrame jInternalFrame = this.dp.getSelectedFrame();
        JInternalFrame jInternalFrame2 = null;
        for (int i = 0; i < this.containers.size(); ++i) {
            GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i);
            if (!graphicModuleContainer.isDocked() || graphicModuleContainer.getInternalFrame() != jInternalFrame) continue;
            if (--i == -1) {
                i = this.containers.size() - 1;
            }
            while (true) {
                if ((graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i)).isDocked()) {
                    jInternalFrame2 = graphicModuleContainer.getInternalFrame();
                    try {
                        jInternalFrame2.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    return;
                }
                if (--i != -1) continue;
                i = this.containers.size() - 1;
            }
        }
    }

    public void dock(JInternalFrame jInternalFrame) {
        this.dp.add(jInternalFrame);
        this.dp.repaint();
    }

    public void undock(JInternalFrame jInternalFrame) {
        this.dp.remove(jInternalFrame);
        this.dp.repaint();
        this.revalidate();
    }

    public void initComponents() {
        this.scr = new JScrollPane();
        this.dp = new JDesktopPane();
        this.dp.setDragMode(1);
        this.scr.addMouseListener(this);
        this.dp.setBackground(new Color(200, 200, 255));
        this.setLayout(new BorderLayout());
        this.scr.setHorizontalScrollBarPolicy(31);
        this.scr.setVerticalScrollBarPolicy(20);
        this.scr.setViewportView(this.dp);
        this.add((Component)this.scr, "Center");
        this.popup = new JPopupMenu();
        this.addModule = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModulesPanel.this.a_addModule();
            }
        };
        this.addModule.putValue("LongDescription", "Adds a new module to the model");
        this.addModule.putValue("MnemonicKey", new Integer(65));
        this.addModule.putValue("Name", "Add Module");
        this.addModule.putValue("SmallIcon", GUIPrism.getIconFromImage("smallNewModule.png"));
        this.show = new JMenu("Show");
        this.show.add(new JSeparator());
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModulesPanel.this.a_showAll();
            }
        };
        abstractAction.putValue("LongDescription", "Shows all graphical modules");
        abstractAction.putValue("MnemonicKey", new Integer(65));
        abstractAction.putValue("Name", "All");
        this.show.add(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModulesPanel.this.a_hideAll();
            }
        };
        abstractAction2.putValue("LongDescription", "Hides all graphical modules");
        abstractAction2.putValue("MnemonicKey", new Integer(78));
        abstractAction2.putValue("Name", "None");
        this.show.add(abstractAction2);
        this.show.setIcon(GUIPrism.getIconFromImage("smallView.png"));
        this.dock = new JMenu("Dock");
        this.dock.add(new JSeparator());
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModulesPanel.this.a_dockAll();
            }
        };
        abstractAction.putValue("LongDescription", "Docks all graphical modules");
        abstractAction.putValue("MnemonicKey", new Integer(65));
        abstractAction.putValue("Name", "All");
        this.dock.add(abstractAction);
        abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModulesPanel.this.a_undockAll();
            }
        };
        abstractAction2.putValue("LongDescription", "Undocks all graphical modules");
        abstractAction2.putValue("MnemonicKey", new Integer(78));
        abstractAction2.putValue("Name", "None");
        this.dock.add(abstractAction2);
        this.dock.setIcon(GUIPrism.getIconFromImage("smallDocking.png"));
        this.layout = new JMenu("Layout");
        this.tile = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModulesPanel.this.a_tile();
            }
        };
        this.tile.putValue("LongDescription", "Tiles all docked graphical modules");
        this.tile.putValue("MnemonicKey", new Integer(84));
        this.tile.putValue("Name", "Tile");
        this.tile.putValue("SmallIcon", GUIPrism.getIconFromImage("smallTile.png"));
        this.layout.add(this.tile);
        this.cascade = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModulesPanel.this.a_cascade();
            }
        };
        this.cascade.putValue("LongDescription", "Cascades all docked graphical modules");
        this.cascade.putValue("MnemonicKey", new Integer(67));
        this.cascade.putValue("Name", "Cascade");
        this.cascade.putValue("SmallIcon", GUIPrism.getIconFromImage("smallCascade.png"));
        this.layout.add(this.cascade);
        this.layout.add(new JSeparator());
        this.autol = new JCheckBoxMenuItem("    Auto Layout");
        this.autol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (jCheckBoxMenuItem.isSelected()) {
                    ModulesPanel.this.tile.setEnabled(false);
                    ModulesPanel.this.cascade.setEnabled(false);
                    ModulesPanel.this.autolayout = true;
                    ModulesPanel.this.autoLayout();
                } else {
                    ModulesPanel.this.tile.setEnabled(true);
                    ModulesPanel.this.cascade.setEnabled(true);
                    ModulesPanel.this.autolayout = false;
                }
            }
        });
        this.layout.add(this.autol);
        this.autolayout = true;
        this.tile.setEnabled(false);
        this.cascade.setEnabled(false);
        this.autol.setSelected(true);
        this.layout.setIcon(GUIPrism.getIconFromImage("smallLayout.png"));
        this.popup.add(this.addModule);
        this.popup.addSeparator();
        this.popup.add(this.show);
        this.popup.add(this.dock);
        this.popup.add(this.layout);
    }

    public void autoLayout() {
        if (this.autolayout) {
            this.a_tile();
        }
    }

    public void ensureFocusIsViewable() {
        GraphicModuleContainer graphicModuleContainer;
        int n;
        for (n = 0; n < this.containers.size(); ++n) {
            graphicModuleContainer = (GraphicModuleContainer)this.containers.get(n);
            if (!graphicModuleContainer.isSelectedModule() || !graphicModuleContainer.isVisible()) continue;
            return;
        }
        for (n = 0; n < this.containers.size(); ++n) {
            graphicModuleContainer = (GraphicModuleContainer)this.containers.get(n);
            if (!graphicModuleContainer.isVisible()) continue;
            graphicModuleContainer.setSelected();
            break;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.mousePopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.mousePopup(mouseEvent);
        }
    }

    public void mousePopup(MouseEvent mouseEvent) {
        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (this.autolayout) {
            this.autoLayout();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this.autolayout) {
            if (componentEvent.getSource() != this) {
                Object object;
                int n;
                int n2 = -1;
                for (n = 0; n < this.containers.size(); ++n) {
                    object = (GraphicModuleContainer)this.containers.get(n);
                    if (!((GraphicModuleContainer)object).isDocked() || ((GraphicModuleContainer)object).getInternalFrame() != componentEvent.getSource()) continue;
                    n2 = n;
                    break;
                }
                n = -1;
                object = componentEvent.getComponent().getBounds();
                for (int i = 0; i < this.containers.size(); ++i) {
                    GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i);
                    if (!graphicModuleContainer.isDocked() || i == n2 || !((Rectangle)object).intersects(graphicModuleContainer.getInternalFrame().getBounds())) continue;
                    n = i;
                    break;
                }
                if (n2 != n && n2 != -1 && n != -1) {
                    Object e = this.containers.get(n2);
                    this.containers.set(n2, this.containers.get(n));
                    this.containers.set(n, e);
                }
            }
            this.autoLayout();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.autolayout) {
            this.autoLayout();
            if (componentEvent.getComponent() == this) {
                this.dp.setPreferredSize(new Dimension(this.scr.getViewport().getWidth(), this.scr.getViewport().getHeight()));
                for (int i = 0; i < this.containers.size(); ++i) {
                    GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i);
                    if (!graphicModuleContainer.isDocked() || !graphicModuleContainer.getInternalFrame().isMaximum()) continue;
                    graphicModuleContainer.getInternalFrame().setPreferredSize(new Dimension(this.dp.getWidth(), this.dp.getHeight()));
                }
            } else {
                for (int i = 0; i < this.containers.size(); ++i) {
                    GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i);
                    if (!graphicModuleContainer.isDocked()) continue;
                    if (graphicModuleContainer.getInternalFrame().isMaximum()) {
                        this.dp.setPreferredSize(new Dimension(this.scr.getViewport().getWidth(), this.scr.getViewport().getHeight()));
                        graphicModuleContainer.getInternalFrame().setPreferredSize(new Dimension(this.dp.getWidth(), this.dp.getHeight()));
                        if (graphicModuleContainer.getInternalFrame() != componentEvent.getComponent()) break;
                        this.a_maximiseAll();
                        break;
                    }
                    if (graphicModuleContainer.getInternalFrame() != componentEvent.getComponent()) continue;
                    this.a_normalAll();
                }
            }
            this.autoLayout();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.autolayout) {
            this.autoLayout();
        }
    }

    public void desktopLoseFocus() {
        for (int i = 0; i < this.containers.size(); ++i) {
            GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i);
            if (!graphicModuleContainer.isDocked()) continue;
            try {
                graphicModuleContainer.getInternalFrame().setSelected(false);
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public int getSelectedIndex() {
        int n = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i);
            if (!graphicModuleContainer.isSelectedModule()) continue;
            n = i;
            break;
        }
        return n;
    }

    public void notifyNewName(ModuleModel moduleModel, String string) {
        this.getModuleContainer(moduleModel).setTitle(string);
    }

    public void a_showAll() {
        Object object;
        int n;
        for (n = 0; n < this.containers.size(); ++n) {
            object = (GraphicModuleContainer)this.containers.get(n);
            ((GraphicModuleContainer)object).setVisible(true);
        }
        for (n = 0; n < this.containers.size(); ++n) {
            object = (JCheckBoxMenuItem)this.showChecks.get(n);
            ((AbstractButton)object).setSelected(true);
        }
    }

    public void a_hideAll() {
        Object object;
        int n;
        for (n = 0; n < this.containers.size(); ++n) {
            object = (GraphicModuleContainer)this.containers.get(n);
            ((GraphicModuleContainer)object).setVisible(false);
        }
        for (n = 0; n < this.containers.size(); ++n) {
            object = (JCheckBoxMenuItem)this.showChecks.get(n);
            ((AbstractButton)object).setSelected(false);
        }
    }

    public void a_show(GraphicModuleContainer graphicModuleContainer) {
        graphicModuleContainer.setVisible(true);
    }

    public void a_hide(GraphicModuleContainer graphicModuleContainer) {
        graphicModuleContainer.setVisible(false);
        for (int i = 0; i < this.containers.size(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.showChecks.get(i);
            if (!jCheckBoxMenuItem.getText().equals(graphicModuleContainer.getName())) continue;
            jCheckBoxMenuItem.setSelected(false);
        }
        this.ensureFocusIsViewable();
    }

    public void a_dock(GraphicModuleContainer graphicModuleContainer) {
        graphicModuleContainer.setDocked(true);
        graphicModuleContainer.setVisible(true);
        for (int i = 0; i < this.containers.size(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.showChecks.get(i);
            if (!jCheckBoxMenuItem.getText().equals(graphicModuleContainer.getName())) continue;
            jCheckBoxMenuItem.setSelected(true);
        }
    }

    public void a_undock(GraphicModuleContainer graphicModuleContainer) {
        graphicModuleContainer.setDocked(false);
        graphicModuleContainer.setVisible(true);
    }

    public void a_dockAll() {
        Object object;
        int n;
        for (n = 0; n < this.containers.size(); ++n) {
            object = (GraphicModuleContainer)this.containers.get(n);
            ((GraphicModuleContainer)object).setDocked(true);
        }
        for (n = 0; n < this.containers.size(); ++n) {
            object = (JCheckBoxMenuItem)this.dockChecks.get(n);
            ((AbstractButton)object).setSelected(true);
        }
        this.a_showAll();
    }

    public void a_undockAll() {
        Object object;
        int n;
        for (n = 0; n < this.containers.size(); ++n) {
            object = (GraphicModuleContainer)this.containers.get(n);
            ((GraphicModuleContainer)object).setDocked(false);
        }
        for (n = 0; n < this.dockChecks.size(); ++n) {
            object = (JCheckBoxMenuItem)this.dockChecks.get(n);
            ((AbstractButton)object).setSelected(false);
        }
        this.a_showAll();
    }

    public void a_tile() {
        int n;
        for (n = 0; n < this.containers.size(); ++n) {
            GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(n);
            if (!graphicModuleContainer.isDocked() || !graphicModuleContainer.getInternalFrame().isMaximum()) continue;
            return;
        }
        n = this.dp.getWidth();
        int n2 = 7;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.containers.size(); ++i) {
            GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i);
            if (!graphicModuleContainer.isDocked() || !graphicModuleContainer.getInternalFrame().isVisible()) continue;
            if (n3 + n2 + n2 + graphicModuleContainer.getInternalFrame().getWidth() > this.dp.getWidth()) {
                n3 = 0;
                n4 = n4 + n2 + n5;
                n5 = 0;
            }
            graphicModuleContainer.getInternalFrame().setLocation(n3 + n2, n4 + n2);
            n3 += graphicModuleContainer.getInternalFrame().getWidth() + n2;
            if (graphicModuleContainer.getInternalFrame().getHeight() <= n5) continue;
            n5 = graphicModuleContainer.getInternalFrame().getHeight();
        }
        this.dp.setPreferredSize(new Dimension(this.getWidth(), n4 + n5 + n2 + n2));
        this.revalidate();
    }

    public void a_cascade() {
        int n;
        for (n = 0; n < this.containers.size(); ++n) {
            GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(n);
            if (!graphicModuleContainer.isDocked() || !graphicModuleContainer.getInternalFrame().isMaximum()) continue;
            return;
        }
        n = this.dp.getWidth();
        int n2 = 21;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = this.getSelectedIndex();
        for (int i = 0; i < this.containers.size(); ++i) {
            GraphicModuleContainer graphicModuleContainer = (GraphicModuleContainer)this.containers.get(i);
            if (!graphicModuleContainer.isDocked() || !graphicModuleContainer.getInternalFrame().isVisible()) continue;
            if (n3 + n2 + n2 + graphicModuleContainer.getInternalFrame().getWidth() > this.dp.getWidth()) {
                n3 = 0;
                n4 = n2 + n5;
                n5 = 0;
            }
            graphicModuleContainer.getInternalFrame().setLocation(n3 + n2, n4 + n2);
            n3 += n2;
            if ((n4 += n2) + graphicModuleContainer.getInternalFrame().getHeight() > n5) {
                n5 = n4 + graphicModuleContainer.getInternalFrame().getHeight();
            }
            graphicModuleContainer.setSelected();
        }
        if (n6 > -1) {
            this.getModuleContainer(n6).setSelected();
        }
        this.dp.setPreferredSize(new Dimension(this.getWidth(), n4 + n5 + n2 + n2));
        this.revalidate();
    }

    public void a_maximiseAll() {
        for (int i = 0; i < this.containers.size(); ++i) {
            GraphicModuleContainer graphicModuleContainer = this.getModuleContainer(i);
            if (!graphicModuleContainer.isDocked() || graphicModuleContainer.getInternalFrame().isMaximum()) continue;
            try {
                graphicModuleContainer.getInternalFrame().setMaximum(true);
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void a_normalAll() {
        for (int i = 0; i < this.containers.size(); ++i) {
            GraphicModuleContainer graphicModuleContainer = this.getModuleContainer(i);
            if (!graphicModuleContainer.isDocked() || !graphicModuleContainer.getInternalFrame().isMaximum()) continue;
            try {
                graphicModuleContainer.getInternalFrame().setMaximum(false);
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void a_addModule() {
        this.gme.requestNewModule();
    }

    public boolean isAutolayout() {
        return this.autolayout;
    }

    public void setAutolayout(boolean bl) {
        this.autolayout = bl;
        this.autol.setSelected(bl);
        this.autoLayout();
    }
}

