/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import userinterface.GUIPrism;
import userinterface.model.graphicModel.GUIGraphicModelEditor;
import userinterface.model.graphicModel.GraphicModuleContainer;

public class GraphicToolBar
extends JToolBar {
    private boolean isDocked;
    private GUIGraphicModelEditor gme;
    private GraphicModuleContainer mmo;
    private int mode = 0;
    private boolean snap = true;
    private boolean showGrid = true;
    private boolean longLabels = false;

    public GraphicToolBar(GUIGraphicModelEditor gUIGraphicModelEditor) {
        super("PRISM Graphic Tools");
        this.isDocked = true;
        this.gme = gUIGraphicModelEditor;
        this.initComponents();
    }

    public GraphicToolBar(GraphicModuleContainer graphicModuleContainer) {
        super("PRISM Graphic Tools");
        this.isDocked = false;
        this.mmo = graphicModuleContainer;
        this.initComponents();
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(GUIPrism.getIconFromImage("smallEdit.png"));
        jToggleButton.setToolTipText("Edit Mode");
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JToggleButton)actionEvent.getSource()).isSelected()) {
                    GraphicToolBar.this.setMode(0);
                }
            }
        });
        jToggleButton.setSelected(true);
        JToggleButton jToggleButton2 = new JToggleButton();
        jToggleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JToggleButton)actionEvent.getSource()).isSelected()) {
                    GraphicToolBar.this.setMode(1);
                }
            }
        });
        jToggleButton2.setIcon(GUIPrism.getIconFromImage("smallZoom.png"));
        jToggleButton2.setToolTipText("Zoom Mode");
        this.add(jToggleButton);
        this.add(jToggleButton2);
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jToggleButton2);
        this.addSeparator();
        jToggleButton = new JToggleButton();
        jToggleButton.setIcon(GUIPrism.getIconFromImage("gridSnapOff.png"));
        jToggleButton.setSelected(true);
        jToggleButton.setToolTipText("Snap To Grid");
        jToggleButton.setSelectedIcon(GUIPrism.getIconFromImage("gridSnapOn.png"));
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphicToolBar.this.setSnap(((JToggleButton)actionEvent.getSource()).isSelected());
            }
        });
        jToggleButton.setSelected(true);
        this.add(jToggleButton);
        jToggleButton2 = new JToggleButton();
        jToggleButton2.setIcon(GUIPrism.getIconFromImage("redGrid.png"));
        jToggleButton2.setSelected(true);
        jToggleButton2.setToolTipText("Grid On/Off");
        jToggleButton2.setDisabledSelectedIcon(GUIPrism.getIconFromImage("greenGrid.png"));
        jToggleButton2.setSelectedIcon(GUIPrism.getIconFromImage("greenGrid.png"));
        jToggleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphicToolBar.this.setShowGrid(((JToggleButton)actionEvent.getSource()).isSelected());
            }
        });
        jToggleButton2.setSelected(true);
        this.add(jToggleButton2);
        JToggleButton jToggleButton3 = new JToggleButton();
        jToggleButton3.setIcon(GUIPrism.getIconFromImage("normLabel.png"));
        jToggleButton3.setToolTipText("Long Labels On/Off");
        jToggleButton3.setSelectedIcon(GUIPrism.getIconFromImage("longLabel.png"));
        jToggleButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphicToolBar.this.setLongLabels(((JToggleButton)actionEvent.getSource()).isSelected());
            }
        });
        this.add(jToggleButton3);
        this.addSeparator();
        JButton jButton = new JButton();
        jButton.setIcon(GUIPrism.getIconFromImage("smallBack.png"));
        jButton.setToolTipText("Last Module");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphicToolBar.this.lastModule();
            }
        });
        this.add(jButton);
        JButton jButton2 = new JButton();
        jButton2.setIcon(GUIPrism.getIconFromImage("smallForward.png"));
        jButton2.setToolTipText("Next Module");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphicToolBar.this.nextModule();
            }
        });
        this.add(jButton2);
    }

    public void nextModule() {
        this.gme.nextModule();
    }

    public void lastModule() {
        this.gme.lastModule();
    }

    private void setMode(int n) {
        if (n == 0 || n == 1) {
            if (this.isDocked) {
                this.gme.setMode(n);
            }
            this.mode = n;
        }
    }

    public boolean isSnap() {
        return this.snap;
    }

    private void setSnap(boolean bl) {
        this.snap = bl;
        if (this.isDocked) {
            this.gme.snapToGrid(bl);
        }
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    private void setShowGrid(boolean bl) {
        this.showGrid = bl;
        if (this.isDocked) {
            this.gme.showGrid(bl);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isLongLabels() {
        return this.longLabels;
    }

    public void setLongLabels(boolean bl) {
        if (this.isDocked) {
            this.gme.showLongLabels(bl);
        }
        this.longLabels = bl;
    }
}

