/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import userinterface.model.graphicModel.Decision;
import userinterface.model.graphicModel.ModuleModel;
import userinterface.model.graphicModel.Nail;
import userinterface.model.graphicModel.ProbTransition;
import userinterface.model.graphicModel.State;
import userinterface.model.graphicModel.Transition;
import userinterface.util.PropertyOwner;

public class GraphicSelection
implements ClipboardOwner,
Transferable,
Serializable {
    SelectionPair selection;

    public GraphicSelection(ModuleModel moduleModel) {
        PropertyOwner propertyOwner;
        int n;
        ArrayList<StateSelect> arrayList = new ArrayList<StateSelect>();
        ArrayList<TransitionSelect> arrayList2 = new ArrayList<TransitionSelect>();
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        for (n = 0; n < moduleModel.getNumStates(); ++n) {
            propertyOwner = moduleModel.getState(n);
            if (!((State)propertyOwner).isSelected()) continue;
            if (((State)propertyOwner).getX() < d) {
                d = ((State)propertyOwner).getX();
            }
            if (((State)propertyOwner).getY() < d2) {
                d2 = ((State)propertyOwner).getY();
            }
            arrayList.add(new StateSelect((State)propertyOwner, n));
        }
        for (n = 0; n < moduleModel.getNumTransitions(); ++n) {
            int n2;
            NailSelect[] nailSelectArray;
            propertyOwner = moduleModel.getTransition(n);
            if (!((Transition)propertyOwner).isSelected() || !((Transition)propertyOwner).getFrom().isSelected() || !((Transition)propertyOwner).getTo().isSelected()) continue;
            StateSelect stateSelect = null;
            StateSelect stateSelect2 = null;
            for (int i = 0; i < moduleModel.getNumStates(); ++i) {
                StateSelect stateSelect3;
                nailSelectArray = moduleModel.getState(i);
                if (nailSelectArray == ((Transition)propertyOwner).getFrom()) {
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        stateSelect3 = (StateSelect)arrayList.get(n2);
                        if (stateSelect3.id != i) continue;
                        stateSelect = stateSelect3;
                    }
                }
                if (nailSelectArray != ((Transition)propertyOwner).getTo()) continue;
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    stateSelect3 = (StateSelect)arrayList.get(n2);
                    if (stateSelect3.id != i) continue;
                    stateSelect2 = stateSelect3;
                }
            }
            if (stateSelect == null || stateSelect2 == null) continue;
            TransitionSelect transitionSelect = new TransitionSelect((Transition)propertyOwner, stateSelect, stateSelect2);
            nailSelectArray = new NailSelect[((Transition)propertyOwner).getNumNails()];
            for (n2 = 0; n2 < ((Transition)propertyOwner).getNumNails(); ++n2) {
                nailSelectArray[n2] = new NailSelect(((Transition)propertyOwner).getNail(n2));
            }
            transitionSelect.nails = nailSelectArray;
            arrayList2.add(transitionSelect);
        }
        this.selection = new SelectionPair(arrayList, arrayList2);
        this.selection.topX = d;
        this.selection.topY = d2;
    }

    public GraphicSelection(SelectionPair selectionPair) {
        this.selection = selectionPair;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.selection.toString();
        }
        return this.selection;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[2];
        Class<?> clazz = this.selection.getClass();
        String string = "application/x-java-serialized-object;class=" + clazz.getName();
        try {
            dataFlavorArray[0] = new DataFlavor(string);
            dataFlavorArray[1] = DataFlavor.stringFlavor;
            return dataFlavorArray;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new DataFlavor[0];
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DataFlavor.stringFlavor.equals(dataFlavor) || "application".equals(dataFlavor.getPrimaryType()) && "x-java-serialized-object".equals(dataFlavor.getSubType()) && dataFlavor.getRepresentationClass().isAssignableFrom(this.selection.getClass());
    }

    class SelectionPair
    implements Serializable {
        StateSelect[] states;
        TransitionSelect[] transitions;
        double topX;
        double topY;
        double offsetX = 0.0;
        double offsetY = 0.0;

        public SelectionPair(ArrayList arrayList, ArrayList arrayList2) {
            int n;
            this.states = new StateSelect[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                this.states[n] = (StateSelect)arrayList.get(n);
            }
            this.transitions = new TransitionSelect[arrayList2.size()];
            for (n = 0; n < arrayList2.size(); ++n) {
                this.transitions[n] = (TransitionSelect)arrayList2.get(n);
            }
        }

        public String toString() {
            return "Selection from graphic model editor";
        }
    }

    class NailSelect
    implements Serializable {
        double x;
        double y;

        public NailSelect(Nail nail) {
            this.x = nail.getX();
            this.y = nail.getY();
        }
    }

    class TransitionSelect
    implements Serializable {
        StateSelect from;
        StateSelect to;
        NailSelect[] nails;
        boolean prob;
        String assignment;
        double assignmentX;
        double assignmentY;
        String guard;
        double guardX;
        double guardY;
        String probability;
        double probabilityX;
        double probabilityY;
        String sync;
        double syncX;
        double syncY;

        public TransitionSelect(Transition transition, StateSelect stateSelect, StateSelect stateSelect2) {
            this.from = stateSelect;
            this.to = stateSelect2;
            this.prob = transition instanceof ProbTransition;
            this.assignment = transition.getAssignmentLabel().getString() + "";
            this.assignmentX = transition.getAssignmentLabel().getOffsetX();
            this.assignmentY = transition.getAssignmentLabel().getOffsetY();
            this.guard = transition.getGuardLabel().getString() + "";
            this.guardX = transition.getGuardLabel().getOffsetX();
            this.guardY = transition.getGuardLabel().getOffsetY();
            this.probability = transition.getProbabilityLabel().getString() + "";
            this.probabilityX = transition.getProbabilityLabel().getOffsetX();
            this.probabilityY = transition.getProbabilityLabel().getOffsetY();
            this.sync = transition.getSyncLabel().getString() + "";
            this.syncX = transition.getSyncLabel().getOffsetX();
            this.syncY = transition.getSyncLabel().getOffsetY();
            this.nails = new NailSelect[transition.getNumNails()];
            for (int i = 0; i < transition.getNumNails(); ++i) {
                this.nails[i] = new NailSelect(transition.getNail(i));
            }
        }
    }

    class StateSelect
    implements Serializable {
        double x;
        double y;
        String comment;
        double commentX;
        double commentY;
        boolean initial;
        boolean decision;
        int id;

        public StateSelect(State state, int n) {
            this.id = n;
            this.x = state.getX();
            this.y = state.getY();
            this.comment = state.getComment() + "";
            this.commentX = state.getCommentLabel().getOffsetX();
            this.commentY = state.getCommentLabel().getOffsetY();
            this.initial = state.isInitial();
            this.decision = state instanceof Decision;
        }
    }
}

