/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.graphicModel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import parser.type.Type;
import prism.ModelType;
import prism.PrismException;
import userinterface.model.GUIModelEditor;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.GUIMultiModelTree;
import userinterface.model.GUITextModelEditor;
import userinterface.model.computation.LoadGraphicModelThread;
import userinterface.model.graphicModel.GraphicToolBar;
import userinterface.model.graphicModel.ModuleModel;
import userinterface.model.graphicModel.ModulesPanel;
import userinterface.util.PropertyOwner;
import userinterface.util.PropertyTableModel;
import userinterface.util.SelectionEvent;
import userinterface.util.SelectionListener;

public class GUIGraphicModelEditor
extends GUIModelEditor
implements SelectionListener {
    public static final JLabel NO_MODULES = new JLabel("Empty Graphic Model", 0);
    private GUIMultiModelHandler handler;
    private GUITextModelEditor textEditor;
    private GUIMultiModelTree tree;
    private PropertyTableModel properties;
    private boolean busy = false;
    private ModulesPanel modPanel;
    private JSplitPane splitter;

    public GUIGraphicModelEditor(GUIMultiModelHandler gUIMultiModelHandler, GUIMultiModelTree gUIMultiModelTree, PropertyTableModel propertyTableModel) {
        this.handler = gUIMultiModelHandler;
        this.properties = propertyTableModel;
        this.initComponents();
        this.tree = gUIMultiModelTree;
        gUIMultiModelTree.setGraphicModelEditor(this);
    }

    @Override
    public String getParseText() {
        String string = this.tree.getParseText() + "\n" + this.textEditor.getParseText();
        return string;
    }

    @Override
    public void newModel() {
        this.tree.setGraphicModelEditor(this);
        this.tree.newTree(true);
        this.textEditor.newModel();
        this.properties.setOwners(new ArrayList<PropertyOwner>());
        this.modPanel.newModel();
    }

    @Override
    public String toString() {
        return "GUIGRAPHICMODELEDITOR IS ME";
    }

    @Override
    public void undo() {
    }

    @Override
    public void redo() {
    }

    @Override
    public void copy() {
        this.modPanel.getModuleModel(this.modPanel.getSelectedIndex()).copy();
    }

    @Override
    public void cut() {
        this.modPanel.getModuleModel(this.modPanel.getSelectedIndex()).cut();
    }

    @Override
    public void paste() {
        this.modPanel.getModuleModel(this.modPanel.getSelectedIndex()).paste();
    }

    @Override
    public void delete() {
        this.modPanel.getModuleModel(this.modPanel.getSelectedIndex()).deleteSelected();
    }

    @Override
    public void selectAll() {
    }

    public void load(File file) throws PrismException, IOException, FileNotFoundException {
    }

    public void save(File file) throws PrismException, IOException, FileNotFoundException {
    }

    public void setAutolayout(boolean bl) {
        this.modPanel.setAutolayout(bl);
    }

    public boolean isAutolayout() {
        return this.modPanel.isAutolayout();
    }

    public void initComponents() {
        this.splitter = new JSplitPane();
        this.textEditor = new GUITextModelEditor("", this.handler);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.modPanel = new ModulesPanel(this.handler.getGUIPlugin().getGUI(), this);
        jPanel.add((Component)this.modPanel, "Center");
        jPanel.add((Component)new GraphicToolBar(this), "North");
        this.splitter.setTopComponent(jPanel);
        this.splitter.setBottomComponent(this.textEditor);
        this.splitter.setOrientation(0);
        this.splitter.setOneTouchExpandable(true);
        this.splitter.setResizeWeight(1.0);
        this.splitter.setDividerSize(8);
        this.setLayout(new BorderLayout());
        this.add(this.splitter);
    }

    public void initialSplitterPosition(int n) {
        int n2 = (int)((double)n * 0.85);
        this.splitter.setDividerLocation(n2);
    }

    public void requestNewModule() {
        this.tree.a_addModule();
    }

    public void addNewModule(GUIMultiModelTree.ModuleNode moduleNode) {
        ModuleModel moduleModel = new ModuleModel(this.handler, moduleNode);
        moduleModel.addSelectionListener(this);
        this.modPanel.addModule(moduleModel);
        moduleNode.setModel(moduleModel);
    }

    public void switchModuleView(GUIMultiModelTree.ModuleNode moduleNode) {
        ModuleModel moduleModel = this.getModuleModel(moduleNode);
    }

    public void notifyChangeTo(GUIMultiModelTree.ModuleNode moduleNode) {
        this.modPanel.notifyNewName(this.getModuleModel(moduleNode), moduleNode.getName());
    }

    public void removeModule(GUIMultiModelTree.ModuleNode moduleNode) {
        this.modPanel.removeModule(this.getModuleModel(moduleNode));
    }

    public ModuleModel getModuleModel(GUIMultiModelTree.ModuleNode moduleNode) {
        for (int i = 0; i < this.getNumModules(); ++i) {
            ModuleModel moduleModel = this.getModuleModel(i);
            if (moduleModel.getCorrespondingModuleNode() != moduleNode) continue;
            return moduleModel;
        }
        return null;
    }

    public ModuleModel getModuleModel(int n) {
        return this.modPanel.getModuleModel(n);
    }

    public int getNumModules() {
        return this.modPanel.getNumModules();
    }

    public void nextModule() {
        this.modPanel.next();
    }

    public void lastModule() {
        this.modPanel.previous();
    }

    public void loadAllExceptModules(String string, String string2, ArrayList arrayList, ArrayList arrayList2, String string3) throws PrismException {
        Object object;
        int n;
        this.textEditor.setText(string3);
        if (string2.equals("mdp")) {
            this.tree.a_setModelType(ModelType.MDP);
        } else if (string2.equals("dtmc")) {
            this.tree.a_setModelType(ModelType.DTMC);
        } else if (string2.equals("ctmc")) {
            this.tree.a_setModelType(ModelType.CTMC);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            object = (LoadGraphicModelThread.Constant)arrayList2.get(n);
            if (object instanceof LoadGraphicModelThread.BooleanConstant) {
                this.tree.a_addBooleanConstant(((LoadGraphicModelThread.Constant)object).name, ((LoadGraphicModelThread.Constant)object).value);
                continue;
            }
            if (object instanceof LoadGraphicModelThread.IntegerConstant) {
                this.tree.a_addIntegerConstant(((LoadGraphicModelThread.Constant)object).name, ((LoadGraphicModelThread.Constant)object).value);
                continue;
            }
            if (!(object instanceof LoadGraphicModelThread.DoubleConstant)) continue;
            this.tree.a_addDoubleConstant(((LoadGraphicModelThread.Constant)object).name, ((LoadGraphicModelThread.Constant)object).value);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (LoadGraphicModelThread.Variable)arrayList.get(n);
            if (object instanceof LoadGraphicModelThread.IntegerVariable) {
                this.tree.a_addIntegerGlobal(((LoadGraphicModelThread.Variable)object).name, ((LoadGraphicModelThread.IntegerVariable)object).min, ((LoadGraphicModelThread.IntegerVariable)object).max, ((LoadGraphicModelThread.IntegerVariable)object).init);
                continue;
            }
            if (!(object instanceof LoadGraphicModelThread.BooleanVariable)) continue;
            this.tree.a_addBooleanGlobal(((LoadGraphicModelThread.Variable)object).name, ((LoadGraphicModelThread.BooleanVariable)object).init);
        }
    }

    public GUIMultiModelTree.ModuleNode requestNewModule(String string) {
        return this.tree.a_requestNewModule(string);
    }

    public void addBooleanVariable(GUIMultiModelTree.ModuleNode moduleNode, LoadGraphicModelThread.BooleanVariable booleanVariable) throws PrismException {
        this.tree.a_addLocalBoolean(moduleNode, booleanVariable);
    }

    public void addIntegerVariable(GUIMultiModelTree.ModuleNode moduleNode, LoadGraphicModelThread.IntegerVariable integerVariable) throws PrismException {
        this.tree.a_addLocalInteger(moduleNode, integerVariable);
    }

    public void setModified() {
        if (!this.isBusy()) {
            this.handler.hasModified(true);
        }
    }

    public void zoomIn() {
        for (int i = 0; i < this.getNumModules(); ++i) {
            this.getModuleModel(i).setZoom(this.getModuleModel(i).getZoom() * 1.1);
        }
    }

    public void zoomOut() {
        for (int i = 0; i < this.getNumModules(); ++i) {
            this.getModuleModel(i).setZoom(this.getModuleModel(i).getZoom() / 1.1);
        }
    }

    public void showGrid(boolean bl) {
        for (int i = 0; i < this.getNumModules(); ++i) {
            this.getModuleModel(i).setShowGrid(bl);
        }
    }

    public void snapToGrid(boolean bl) {
        for (int i = 0; i < this.getNumModules(); ++i) {
            this.getModuleModel(i).setSnap(bl);
        }
    }

    public void showLongLabels(boolean bl) {
        for (int i = 0; i < this.getNumModules(); ++i) {
            this.getModuleModel(i).setShowLongLabels(bl);
        }
    }

    public void setMode(int n) {
        for (int i = 0; i < this.getNumModules(); ++i) {
            this.getModuleModel(i).setMode(n);
        }
    }

    public ModelType getModelType() {
        return this.tree.getModelType();
    }

    public ArrayList getEditableConstantNames() {
        return this.tree.getEditableConstantNames();
    }

    public ArrayList getEditableConstantValues() {
        return this.tree.getEditableConstantValues();
    }

    public ArrayList<Type> getEditableConstantTypes() {
        return this.tree.getEditableConstantTypes();
    }

    public ArrayList getEditableGlobalNames() {
        return this.tree.getEditableGlobalNames();
    }

    public ArrayList getEditableGlobalMins() {
        return this.tree.getEditableGlobalMins();
    }

    public ArrayList getEditableGlobalMaxs() {
        return this.tree.getEditableGlobalMaxs();
    }

    public ArrayList getEditableGlobalInits() {
        return this.tree.getEditableGlobalInits();
    }

    public ArrayList<Type> getEditableGlobalTypes() {
        return this.tree.getEditableGlobalTypes();
    }

    public String getTextEditorString() {
        return this.textEditor.getTextString();
    }

    public ModuleModel[] getModuleArray() {
        ModuleModel[] moduleModelArray = new ModuleModel[this.getNumModules()];
        for (int i = 0; i < moduleModelArray.length; ++i) {
            moduleModelArray[i] = this.getModuleModel(i);
        }
        return moduleModelArray;
    }

    public ArrayList getVariableNames(ModuleModel moduleModel) {
        return this.tree.getVariableNames(moduleModel.getCorrespondingModuleNode());
    }

    public ArrayList<Type> getVariableTypes(ModuleModel moduleModel) {
        return this.tree.getVariableTypes(moduleModel.getCorrespondingModuleNode());
    }

    public ArrayList getVariableMins(ModuleModel moduleModel) {
        return this.tree.getVariableMins(moduleModel.getCorrespondingModuleNode());
    }

    public ArrayList getVariableMaxs(ModuleModel moduleModel) {
        return this.tree.getVariableMaxs(moduleModel.getCorrespondingModuleNode());
    }

    public ArrayList getVariableInits(ModuleModel moduleModel) {
        return this.tree.getVariableInits(moduleModel.getCorrespondingModuleNode());
    }

    @Override
    public void selectionPerformed(SelectionEvent selectionEvent) {
        this.properties.setOwners(selectionEvent.getSelectedItems());
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean bl) {
        this.busy = bl;
        this.handler.setBusy(bl);
    }
}

