/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import userinterface.GUIPlugin;
import userinterface.model.GUIModelEditor;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.GUITextModelEditor;
import userinterface.util.GUIComputationEvent;

public class SavePRISMModelThread
extends Thread {
    private GUIModelEditor editor;
    private GUIMultiModelHandler handler;
    private File f;
    private GUIPlugin plug;
    private Exception ex;

    public SavePRISMModelThread(File file, GUIMultiModelHandler gUIMultiModelHandler, GUIModelEditor gUIModelEditor) {
        this.editor = gUIModelEditor;
        this.handler = gUIMultiModelHandler;
        this.f = file;
        this.plug = gUIMultiModelHandler.getGUIPlugin();
        this.ex = null;
    }

    @Override
    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        SavePRISMModelThread.this.plug.startProgress();
                        SavePRISMModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, SavePRISMModelThread.this.plug));
                        SavePRISMModelThread.this.plug.setTaskBarText("Saving model...");
                        ((GUITextModelEditor)SavePRISMModelThread.this.editor).write(new FileWriter(SavePRISMModelThread.this.f));
                    }
                    catch (IOException iOException) {
                        SavePRISMModelThread.this.ex = iOException;
                    }
                    catch (ClassCastException classCastException) {
                        SavePRISMModelThread.this.ex = classCastException;
                    }
                }
            });
            if (this.ex != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SavePRISMModelThread.this.plug.stopProgress();
                        SavePRISMModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, SavePRISMModelThread.this.plug));
                        SavePRISMModelThread.this.plug.setTaskBarText("Saving model... error.");
                        SavePRISMModelThread.this.plug.error("Could not save to file \"" + SavePRISMModelThread.this.f + "\"");
                    }
                });
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SavePRISMModelThread.this.plug.stopProgress();
                    SavePRISMModelThread.this.plug.setTaskBarText("Saving model... done.");
                    SavePRISMModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, SavePRISMModelThread.this.plug));
                    SavePRISMModelThread.this.handler.prismFileWasSaved(SavePRISMModelThread.this.f);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

