/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import java.awt.Color;
import java.awt.Paint;
import java.util.Observable;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import settings.BooleanSetting;
import settings.ColorSetting;
import settings.Setting;
import settings.SettingDisplay;
import settings.SettingException;
import settings.SettingOwner;
import userinterface.graph.Graph;

public class DisplaySettings
extends Observable
implements SettingOwner {
    private SettingDisplay display;
    private Graph graph;
    private JFreeChart chart;
    private XYPlot plot;
    private BooleanSetting antiAlias;
    private ColorSetting backgroundColor;

    public DisplaySettings(Graph graph) {
        this.graph = graph;
        this.chart = graph.getChart();
        this.plot = this.chart.getXYPlot();
        this.antiAlias = new BooleanSetting("anti-aliasing", new Boolean(true), "Should the graph be rendered using anti-aliasing?", (SettingOwner)this, false);
        Color color = Color.white;
        this.backgroundColor = new ColorSetting("background colour", color, "The background colour of the graph panel", (SettingOwner)this, false);
        this.updateDisplay();
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public SettingDisplay getDisplay() {
        return this.display;
    }

    @Override
    public int getNumSettings() {
        return 2;
    }

    @Override
    public Setting getSetting(int n) {
        switch (n) {
            case 0: {
                return this.antiAlias;
            }
            case 1: {
                return this.backgroundColor;
            }
        }
        return null;
    }

    @Override
    public String getSettingOwnerClassName() {
        return "Display";
    }

    @Override
    public int getSettingOwnerID() {
        return 19;
    }

    @Override
    public String getSettingOwnerName() {
        if (this.graph != null && this.graph.getName() != null) {
            return this.graph.getName();
        }
        return "";
    }

    @Override
    public void notifySettingChanged(Setting setting) {
        this.updateDisplay();
        this.setChanged();
        this.notifyObservers(this);
    }

    @Override
    public void setDisplay(SettingDisplay settingDisplay) {
        this.display = settingDisplay;
    }

    public int compareTo(Object object) {
        if (object instanceof SettingOwner) {
            SettingOwner settingOwner = (SettingOwner)object;
            if (this.getSettingOwnerID() < settingOwner.getSettingOwnerID()) {
                return -1;
            }
            if (this.getSettingOwnerID() > settingOwner.getSettingOwnerID()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public boolean isAntiAliased() {
        return this.antiAlias.getBooleanValue();
    }

    public void setAntiAliased(boolean bl) {
        try {
            this.antiAlias.setValue(new Boolean(bl));
            this.updateDisplay();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor.getColorValue();
    }

    public void setBackgroundColor(Color color) {
        try {
            this.backgroundColor.setValue(color);
            this.updateDisplay();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    private void updateDisplay() {
        if (this.isAntiAliased() != this.chart.getAntiAlias()) {
            this.chart.setAntiAlias(this.isAntiAliased());
        }
        if (!(this.chart.getBackgroundPaint() instanceof Color) || !this.backgroundColor.getColorValue().equals(this.chart.getBackgroundPaint())) {
            this.chart.setBackgroundPaint((Paint)this.backgroundColor.getColorValue());
        }
    }
}

