/*
 * Decompiled with CFR 0.152.
 */
package userinterface;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismSettingsListener;
import userinterface.GUIClipboard;
import userinterface.GUIFileMenu;
import userinterface.GUINetwork;
import userinterface.GUIOptionsDialog;
import userinterface.GUIPlugin;
import userinterface.GUIPrismSplash;
import userinterface.GUITaskBar;
import userinterface.log.GUILog;
import userinterface.log.GUIWindowLog;
import userinterface.model.GUIMultiModel;
import userinterface.properties.GUIMultiProperties;
import userinterface.simulator.GUISimulator;
import userinterface.util.GUIComputationEvent;
import userinterface.util.GUIEvent;
import userinterface.util.GUIEventHandler;
import userinterface.util.GUIException;
import userinterface.util.GUIExitEvent;
import userinterface.util.PresentationMetalTheme;

public class GUIPrism
extends JFrame {
    public static final int DEFAULT_WINDOW_WIDTH = 1024;
    public static final int DEFAULT_WINDOW_HEIGHT = 640;
    public static final int MINIMUM_WINDOW_WIDTH = 10;
    public static final int MINIMUM_WINDOW_HEIGHT = 10;
    private static GUIPrismSplash splash;
    private static GUIPrism gui;
    private boolean doExit;
    private static GUIClipboard clipboardPlugin;
    private Prism prism;
    private PrismLog theLog;
    private ArrayList plugs;
    private JTabbedPane theTabs;
    private GUIPlugin logPlug;
    private GUIEventHandler eventHandle;
    private GUIOptionsDialog options;
    private JFileChooser choose;
    private JProgressBar progress;
    private GUITaskBar taskbar;
    private String taskbarText = "";
    private Action prismOptions;
    private Action fontIncrease;
    private Action fontDecrease;

    public static void main(String[] stringArray) {
        try {
            splash = new GUIPrismSplash("images/splash.png");
            splash.display();
            gui = new GUIPrism();
            gui.setVisible(true);
            EventQueue.invokeLater(new SplashScreenCloser());
            gui.passCLArgs(stringArray);
        }
        catch (GUIException gUIException) {
            System.err.println("Error: Could not load the PRISM GUI: " + gUIException.getMessage());
            System.exit(1);
        }
        catch (PrismException prismException) {
            System.err.println("Error: " + prismException.getMessage());
            System.exit(1);
        }
    }

    public static ArrayList<GUIPlugin> getPluginArray(GUIPrism gUIPrism) {
        GUIFileMenu gUIFileMenu = new GUIFileMenu(gUIPrism);
        clipboardPlugin = new GUIClipboard(gUIPrism);
        GUIMultiModel gUIMultiModel = new GUIMultiModel(gUIPrism);
        GUISimulator gUISimulator = new GUISimulator(gUIPrism);
        GUIMultiProperties gUIMultiProperties = new GUIMultiProperties(gUIPrism, gUISimulator);
        GUILog gUILog = new GUILog(gUIPrism);
        GUINetwork gUINetwork = new GUINetwork(gUIPrism);
        ArrayList<GUIPlugin> arrayList = new ArrayList<GUIPlugin>();
        arrayList.add(gUIFileMenu);
        arrayList.add(clipboardPlugin);
        arrayList.add(gUIMultiModel);
        arrayList.add(gUIMultiProperties);
        arrayList.add(gUISimulator);
        arrayList.add(gUILog);
        arrayList.add(gUINetwork);
        gUISimulator.setGUIMultiModel(gUIMultiModel);
        return arrayList;
    }

    public static GUIPrism getGUI() {
        return gui;
    }

    public GUIPrism() throws GUIException, PrismException {
        this.setupResources();
        this.setupPrism();
        this.initComponents();
        this.prism.getSettings().notifySettingsListeners();
    }

    private void setupResources() throws GUIException {
        Object object;
        try {
            object = new PresentationMetalTheme(0);
            MetalLookAndFeel.setCurrentTheme((MetalTheme)object);
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            throw new GUIException("Failed to Initialise:\nLook and Feel Invalid");
        }
        this.choose = new JFileChooser();
        object = new File(".");
        try {
            object = ((File)object).getCanonicalFile();
            if (((File)object).getName().equals("bin")) {
                object = ((File)object).getParentFile();
            }
        }
        catch (IOException iOException) {
            object = new File(".");
        }
        this.choose.setCurrentDirectory((File)object);
        this.logPlug = null;
        this.eventHandle = new GUIEventHandler(this);
    }

    private void setupPrism() throws PrismException {
        this.theLog = new GUIWindowLog();
        this.prism = new Prism(this.theLog, new PrismFileLog("stdout"));
        this.prism.loadUserSettingsFile();
        this.prism.initialise();
    }

    private void initComponents() throws GUIException {
        Serializable serializable;
        JMenuBar jMenuBar = new JMenuBar();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.options = new GUIOptionsDialog(this);
        JPanel jPanel2 = new JPanel();
        this.theTabs = new JTabbedPane();
        this.theTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                clipboardPlugin.pluginChanged(GUIPrism.this.getFocussedPlugin());
            }
        });
        this.plugs = GUIPrism.getPluginArray(this);
        for (int i = 0; i < this.plugs.size(); ++i) {
            serializable = (GUIPlugin)this.plugs.get(i);
            if (((GUIPlugin)serializable).displaysTab()) {
                this.theTabs.addTab(((GUIPlugin)serializable).getTabText(), (Component)serializable);
                this.theTabs.setEnabledAt(this.theTabs.getComponentCount() - 1, ((Component)serializable).isEnabled());
            }
            if (((GUIPlugin)serializable).getMenu() != null) {
                jMenuBar.add(((GUIPlugin)serializable).getMenu());
            }
            if (((GUIPlugin)serializable).getToolBar() != null) {
                jPanel.add(((GUIPlugin)serializable).getToolBar());
            }
            if (((GUIPlugin)serializable).getOptions() != null) {
                this.options.addPanel(((GUIPlugin)serializable).getOptions());
            }
            if (serializable instanceof GUILog) {
                this.logPlug = (GUILog)serializable;
            }
            this.prism.getSettings().addSettingsListener((PrismSettingsListener)((Object)serializable));
        }
        this.theTabs.setTabPlacement(3);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(1024, 640));
        jPanel2.setMinimumSize(new Dimension(10, 10));
        jPanel2.add((Component)this.theTabs, "Center");
        JMenu jMenu = new JMenu("Options");
        jMenuBar.add(jMenu);
        serializable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPrism.this.nextTab();
            }
        };
        serializable.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.prismOptions = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPrism.this.options.show();
            }
        };
        this.prismOptions.putValue("LongDescription", "Brings up an option dialog for setting PRISM and user interface parameters.");
        this.prismOptions.putValue("MnemonicKey", new Integer(79));
        this.prismOptions.putValue("Name", "Options");
        this.prismOptions.putValue("SmallIcon", GUIPrism.getIconFromImage("smallOptions.png"));
        jMenu.add(this.prismOptions);
        jMenu.setMnemonic('O');
        this.fontIncrease = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPrism.this.adjustFont(1);
            }
        };
        this.fontIncrease.putValue("LongDescription", "Increase the application font size.");
        this.fontIncrease.putValue("MnemonicKey", new Integer(73));
        this.fontIncrease.putValue("Name", "Increase font size");
        this.fontIncrease.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFontIncrease.png"));
        this.fontIncrease.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        jMenu.add(this.fontIncrease);
        jMenu.setMnemonic('I');
        this.fontDecrease = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPrism.this.adjustFont(-1);
            }
        };
        this.fontDecrease.putValue("LongDescription", "Decrease the application font size.");
        this.fontDecrease.putValue("MnemonicKey", new Integer(68));
        this.fontDecrease.putValue("Name", "Decrease font size");
        this.fontDecrease.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFontDecrease.png"));
        this.fontDecrease.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.add(this.fontDecrease);
        jMenu.setMnemonic('D');
        JPanel jPanel3 = new JPanel();
        this.progress = new JProgressBar(0, 100);
        this.progress.setBorder(null);
        this.taskbar = new GUITaskBar();
        this.taskbar.setText("Welcome to PRISM...");
        jPanel3.setBorder(new EtchedBorder());
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.progress, "East");
        jPanel3.add((Component)this.taskbar, "Center");
        this.setJMenuBar(jMenuBar);
        GUIPrism gUIPrism = this;
        this.setTitle("PRISM " + gUIPrism.prism.getVersion());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIPrism.this.exit();
            }
        });
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        this.setIconImage(GUIPrism.getIconFromImage("smallPrism.png").getImage());
        this.getContentPane().setSize(new Dimension(800, 600));
        this.pack();
    }

    public void passCLArgs(String[] stringArray) {
        for (int i = 0; i < this.plugs.size(); ++i) {
            GUIPlugin gUIPlugin = (GUIPlugin)this.plugs.get(i);
            gUIPlugin.takeCLArgs(stringArray);
        }
    }

    public void adjustFont(int n) {
        Object[] objectArray = UIManager.getLookAndFeel().getDefaults().keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].toString().toUpperCase().indexOf(".FONT") == -1) continue;
            Font font = UIManager.getFont(objectArray[i]);
            font = font.deriveFont((float)(font.getSize() + n));
            UIManager.put(objectArray[i], new FontUIResource(font));
        }
        SwingUtilities.updateComponentTreeUI(this);
        SwingUtilities.updateComponentTreeUI(this.choose);
        SwingUtilities.updateComponentTreeUI(this.options);
        this.repaint();
    }

    public void exit() {
        this.doExit = true;
        this.notifyEventListeners(new GUIExitEvent(0));
        if (this.doExit) {
            System.exit(0);
        }
    }

    public Prism getPrism() {
        return this.prism;
    }

    public GUIOptionsDialog getOptions() {
        return this.options;
    }

    public GUIEventHandler getEventHandler() {
        return this.eventHandle;
    }

    public static ImageIcon getIconFromImage(String string) {
        URL uRL = GUIPrism.class.getClassLoader().getResource("images/" + string);
        if (uRL == null) {
            System.out.println("Warning: Failed to load icon file \"" + string + "\"");
            return null;
        }
        return new ImageIcon(uRL);
    }

    public JFileChooser getChooser() {
        return this.choose;
    }

    public GUIPlugin getFocussedPlugin() {
        return (GUIPlugin)this.theTabs.getComponentAt(this.theTabs.getSelectedIndex());
    }

    public PrismLog getLog() {
        return this.theLog;
    }

    public void notifyEventListeners(GUIEvent gUIEvent) {
        this.getEventHandler().notifyListeners(gUIEvent);
    }

    public boolean processGUIEvent(GUIEvent gUIEvent) {
        if (gUIEvent instanceof GUIComputationEvent) {
            if (gUIEvent.getID() == 0) {
                this.prismOptions.setEnabled(false);
            } else if (gUIEvent.getID() == 1) {
                this.prismOptions.setEnabled(true);
                this.appendWarningsNoteToTaskBarText(this.prism.getMainLog());
            } else if (gUIEvent.getID() == 2) {
                this.prismOptions.setEnabled(true);
            }
        } else if (gUIEvent instanceof GUIExitEvent && gUIEvent.getID() == 1) {
            this.doExit = false;
        }
        return false;
    }

    public void enableTab(GUIPlugin gUIPlugin, boolean bl) {
        for (int i = 0; i < this.theTabs.getComponentCount(); ++i) {
            GUIPlugin gUIPlugin2;
            Component component = this.theTabs.getComponentAt(i);
            if (!(component instanceof GUIPlugin) || (gUIPlugin2 = (GUIPlugin)component) != gUIPlugin) continue;
            this.theTabs.setEnabledAt(i, bl);
            break;
        }
    }

    public void nextTab() {
        this.theTabs.setSelectedIndex((this.theTabs.getSelectedIndex() + 1) % this.theTabs.getComponentCount());
    }

    public void showTab(GUIPlugin gUIPlugin) {
        for (int i = 0; i < this.theTabs.getComponentCount(); ++i) {
            Component component = this.theTabs.getComponentAt(i);
            if (component != gUIPlugin) continue;
            this.theTabs.setSelectedIndex(i);
            break;
        }
    }

    public void showLogTab() {
        if (this.logPlug != null) {
            this.showTab(this.logPlug);
        }
    }

    public void setTaskBarText(String string) {
        this.taskbar.setText(string);
        this.taskbarText = string;
    }

    public void appendWarningsNoteToTaskBarText(PrismLog prismLog) {
        int n = prismLog.getNumberOfWarnings();
        String string = null;
        if (n == 1) {
            string = "[ There was 1 warning - see log for details ]";
        } else if (n > 1) {
            string = "[ There were " + n + " warnings - see log for details ]";
        }
        if (string != null) {
            String string2 = this.taskbarText;
            if (string2 == null) {
                string2 = "";
            }
            if (string2.length() > 0) {
                string2 = string2 + "  ";
            }
            string2 = string2 + string;
            this.taskbar.setText(string2);
        }
    }

    public void startProgress() {
        this.progress.setIndeterminate(true);
    }

    public void stopProgress() {
        this.progress.setIndeterminate(false);
    }

    public void errorDialog(String string) {
        this.errorDialog("Error", string);
    }

    public void errorDialog(String string, String string2) {
        JOptionPane.showMessageDialog(this, string2, string, 0);
    }

    public static GUIClipboard getClipboardPlugin() {
        return clipboardPlugin;
    }

    private static final class SplashScreenCloser
    implements Runnable {
        private SplashScreenCloser() {
        }

        @Override
        public void run() {
            splash.dispose();
        }
    }
}

