/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import parser.State;
import parser.ast.Expression;
import parser.ast.ExpressionTemporal;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Path;
import simulator.TransitionList;
import simulator.sampler.SamplerBoolean;

public class SamplerUntil
extends SamplerBoolean {
    private Expression left;
    private Expression right;

    public SamplerUntil(ExpressionTemporal expressionTemporal) throws PrismException {
        if (expressionTemporal.getOperator() != 2) {
            throw new PrismException("Error creating Sampler");
        }
        this.left = expressionTemporal.getOperand1();
        this.right = expressionTemporal.getOperand2();
        this.reset();
        this.resetStats();
    }

    @Override
    public boolean update(Path path, TransitionList transitionList) throws PrismLangException {
        if (this.valueKnown) {
            return true;
        }
        State state = path.getCurrentState();
        if (this.right.evaluateBoolean(state)) {
            this.valueKnown = true;
            this.value = true;
        } else if (!this.left.evaluateBoolean(state)) {
            this.valueKnown = true;
            this.value = false;
        } else if (transitionList != null && (transitionList.isDeadlock() || path.isLooping())) {
            this.valueKnown = true;
            this.value = false;
        }
        return this.valueKnown;
    }
}

