/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import parser.ast.ExpressionTemporal;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Path;
import simulator.TransitionList;
import simulator.sampler.SamplerDouble;

public class SamplerRewardInstCont
extends SamplerDouble {
    private double time;
    private int rewardStructIndex;

    public SamplerRewardInstCont(ExpressionTemporal expressionTemporal, int n) throws PrismException {
        if (expressionTemporal.getOperator() != 12) {
            throw new PrismException("Error creating Sampler");
        }
        this.time = expressionTemporal.getUpperBound().evaluateDouble();
        this.rewardStructIndex = n;
        this.reset();
        this.resetStats();
    }

    @Override
    public boolean update(Path path, TransitionList transitionList) throws PrismLangException {
        if (this.valueKnown) {
            return true;
        }
        if (path.getTotalTime() >= this.time) {
            this.valueKnown = true;
            this.value = path.getTotalTime() > this.time ? path.getPreviousStateReward(this.rewardStructIndex) : path.getCurrentStateReward(this.rewardStructIndex);
        } else if (transitionList != null && transitionList.isDeadlock()) {
            this.valueKnown = true;
            this.value = path.getCurrentStateReward(this.rewardStructIndex);
        }
        return this.valueKnown;
    }

    @Override
    public boolean needsBoundedNumSteps() {
        return true;
    }
}

