/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import prism.PrismException;
import prism.PrismLangException;
import simulator.Path;
import simulator.TransitionList;
import simulator.sampler.Sampler;

public abstract class SamplerDouble
extends Sampler {
    protected double value;
    protected double valueSum;
    protected double valueSumSq;
    protected int numSamples;

    @Override
    public void reset() {
        this.valueKnown = false;
        this.value = 0.0;
    }

    @Override
    public void resetStats() {
        this.valueSum = 0.0;
        this.valueSumSq = 0.0;
        this.numSamples = 0;
    }

    @Override
    public abstract boolean update(Path var1, TransitionList var2) throws PrismLangException;

    @Override
    public void updateStats() {
        this.valueSum += this.value;
        this.valueSumSq += this.value * this.value;
        ++this.numSamples;
    }

    @Override
    public Object getCurrentValue() {
        return new Double(this.value);
    }

    @Override
    public double getMeanValue() {
        return this.valueSum / (double)this.numSamples;
    }

    @Override
    public double getVariance() {
        if (this.numSamples <= 1) {
            return 0.0;
        }
        double d = this.valueSum / (double)this.numSamples;
        return (this.valueSumSq - (double)this.numSamples * d * d) / ((double)this.numSamples - 1.0);
    }

    @Override
    public double getLikelihoodRatio(double d, double d2) throws PrismException {
        if (this.numSamples <= 1) {
            return 0.0;
        }
        if (this.valueSumSq == 0.0) {
            throw new PrismException("Cannot compute likelihood ratio with null variance");
        }
        double d3 = this.valueSumSq / (double)this.numSamples - this.valueSum * this.valueSum / (double)this.numSamples / (double)this.numSamples;
        double d4 = -1.0 / (2.0 * d3) * ((double)this.numSamples * (d * d - d2 * d2) - 2.0 * this.valueSum * (d - d2));
        if (Double.isNaN(d4)) {
            throw new PrismException("Error computing likelihood ratio");
        }
        return Math.exp(d4);
    }
}

