/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import parser.State;
import parser.ast.Expression;
import parser.ast.ExpressionTemporal;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Path;
import simulator.TransitionList;
import simulator.sampler.SamplerBoolean;

public class SamplerBoundedUntilDisc
extends SamplerBoolean {
    private Expression left;
    private Expression right;
    private int lb;
    private int ub;

    public SamplerBoundedUntilDisc(ExpressionTemporal expressionTemporal) throws PrismException {
        if (expressionTemporal.getOperator() != 2) {
            throw new PrismException("Error creating Sampler");
        }
        this.left = expressionTemporal.getOperand1();
        this.right = expressionTemporal.getOperand2();
        if (expressionTemporal.getLowerBound() != null) {
            this.lb = expressionTemporal.getLowerBound().evaluateInt();
            if (expressionTemporal.lowerBoundIsStrict()) {
                ++this.lb;
            }
        } else {
            this.lb = 0;
        }
        if (this.lb < 0) {
            throw new PrismException("Invalid lower bound in " + expressionTemporal);
        }
        if (expressionTemporal.getUpperBound() != null) {
            this.ub = expressionTemporal.getUpperBound().evaluateInt();
            if (expressionTemporal.upperBoundIsStrict()) {
                --this.ub;
            }
        } else {
            this.ub = Integer.MAX_VALUE;
        }
        if (this.ub < 0) {
            throw new PrismException("Invalid upper bound in " + expressionTemporal);
        }
        this.reset();
        this.resetStats();
    }

    @Override
    public boolean update(Path path, TransitionList transitionList) throws PrismLangException {
        if (this.valueKnown) {
            return true;
        }
        long l = path.size();
        if (l > (long)this.ub) {
            this.valueKnown = true;
            this.value = false;
        } else if (l < (long)this.lb) {
            if (!this.left.evaluateBoolean(path.getCurrentState())) {
                this.valueKnown = true;
                this.value = false;
            }
        } else {
            State state = path.getCurrentState();
            if (this.right.evaluateBoolean(state)) {
                this.valueKnown = true;
                this.value = true;
            } else if (!this.left.evaluateBoolean(state)) {
                this.valueKnown = true;
                this.value = false;
            } else if (transitionList != null && transitionList.isDeadlock()) {
                this.valueKnown = true;
                this.value = false;
            }
        }
        return this.valueKnown;
    }

    @Override
    public boolean needsBoundedNumSteps() {
        return true;
    }
}

