/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import parser.ast.Expression;
import parser.ast.ExpressionTemporal;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Path;
import simulator.TransitionList;
import simulator.sampler.SamplerBoolean;

public class SamplerBoundedUntilCont
extends SamplerBoolean {
    private Expression left;
    private Expression right;
    private double lb;
    private double ub;

    public SamplerBoundedUntilCont(ExpressionTemporal expressionTemporal) throws PrismException {
        if (expressionTemporal.getOperator() != 2) {
            throw new PrismException("Error creating Sampler");
        }
        this.left = expressionTemporal.getOperand1();
        this.right = expressionTemporal.getOperand2();
        this.lb = expressionTemporal.getLowerBound() == null ? 0.0 : expressionTemporal.getLowerBound().evaluateDouble();
        this.ub = expressionTemporal.getUpperBound() == null ? Double.POSITIVE_INFINITY : expressionTemporal.getUpperBound().evaluateDouble();
        this.reset();
        this.resetStats();
    }

    @Override
    public boolean update(Path path, TransitionList transitionList) throws PrismLangException {
        if (this.valueKnown) {
            return true;
        }
        if (path.size() == 0L) {
            if (this.lb == 0.0) {
                if (this.right.evaluateBoolean(path.getCurrentState())) {
                    this.valueKnown = true;
                    this.value = true;
                }
            } else if (!this.left.evaluateBoolean(path.getCurrentState())) {
                this.valueKnown = true;
                this.value = false;
            }
        } else {
            double d = path.getTotalTime();
            if (d > this.ub) {
                if (this.right.evaluateBoolean(path.getPreviousState())) {
                    this.valueKnown = true;
                    this.value = true;
                } else {
                    this.valueKnown = true;
                    this.value = false;
                }
            } else if (d <= this.lb) {
                if (!this.left.evaluateBoolean(path.getCurrentState())) {
                    this.valueKnown = true;
                    this.value = false;
                }
            } else if (this.right.evaluateBoolean(path.getCurrentState())) {
                this.valueKnown = true;
                this.value = true;
            } else if (!this.left.evaluateBoolean(path.getCurrentState())) {
                this.valueKnown = true;
                this.value = false;
            } else if (d - path.getTimeInPreviousState() <= this.lb) {
                if (this.right.evaluateBoolean(path.getPreviousState())) {
                    this.valueKnown = true;
                    this.value = true;
                }
            } else if (transitionList != null && transitionList.isDeadlock()) {
                this.valueKnown = true;
                this.value = false;
            }
        }
        return this.valueKnown;
    }

    @Override
    public boolean needsBoundedNumSteps() {
        return true;
    }
}

