/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import parser.ast.Expression;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.ModulesFile;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Path;
import simulator.TransitionList;
import simulator.method.SimulationMethod;
import simulator.sampler.SamplerBoolean;
import simulator.sampler.SamplerBoundedUntilCont;
import simulator.sampler.SamplerBoundedUntilDisc;
import simulator.sampler.SamplerDouble;
import simulator.sampler.SamplerNext;
import simulator.sampler.SamplerRewardCumulCont;
import simulator.sampler.SamplerRewardCumulDisc;
import simulator.sampler.SamplerRewardInstCont;
import simulator.sampler.SamplerRewardInstDisc;
import simulator.sampler.SamplerRewardReach;
import simulator.sampler.SamplerUntil;

public abstract class Sampler {
    protected boolean valueKnown;
    protected SimulationMethod simulationMethod;

    public boolean isCurrentValueKnown() {
        return this.valueKnown;
    }

    public boolean needsBoundedNumSteps() {
        return false;
    }

    public abstract void reset();

    public abstract void resetStats();

    public abstract boolean update(Path var1, TransitionList var2) throws PrismLangException;

    public abstract void updateStats();

    public abstract Object getCurrentValue();

    public abstract double getMeanValue();

    public abstract double getVariance();

    public abstract double getLikelihoodRatio(double var1, double var3) throws PrismException;

    public void setSimulationMethod(SimulationMethod simulationMethod) {
        this.simulationMethod = simulationMethod;
    }

    public SimulationMethod getSimulationMethod() {
        return this.simulationMethod;
    }

    public String getSimulationMethodResultExplanation() throws PrismException {
        return this.simulationMethod.getResultExplanation(this);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Sampler createSampler(Expression expression, ModulesFile modulesFile) throws PrismException {
        void var2_5;
        Object var2_2 = null;
        if (expression instanceof ExpressionProb) {
            ExpressionProb expressionProb = (ExpressionProb)expression;
            if (!expressionProb.getExpression().isSimplePathFormula()) throw new PrismException("LTL-style path formulas are not supported by the simulator");
            SamplerBoolean samplerBoolean = Sampler.createSamplerForProbPathPropertySimple(expressionProb.getExpression(), modulesFile);
            return var2_5;
        } else {
            if (!(expression instanceof ExpressionReward)) throw new PrismException("Can't create sampler for property \"" + expression + "\"");
            SamplerDouble samplerDouble = Sampler.createSamplerForRewardProperty((ExpressionReward)expression, modulesFile);
        }
        return var2_5;
    }

    private static SamplerBoolean createSamplerForProbPathPropertySimple(Expression expression, ModulesFile modulesFile) throws PrismException {
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            if (expressionUnaryOp.getOperator() == 3) {
                return Sampler.createSamplerForProbPathPropertySimple(expressionUnaryOp.getOperand(), modulesFile);
            }
            if (expressionUnaryOp.getOperator() == 1) {
                SamplerBoolean samplerBoolean = Sampler.createSamplerForProbPathPropertySimple(expressionUnaryOp.getOperand(), modulesFile);
                samplerBoolean.negate();
                return samplerBoolean;
            }
        } else if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperator() == 1) {
                return new SamplerNext(expressionTemporal);
            }
            if (expressionTemporal.getOperator() == 2) {
                if (expressionTemporal.hasBounds()) {
                    if (modulesFile.getModelType().continuousTime()) {
                        return new SamplerBoundedUntilCont(expressionTemporal);
                    }
                    return new SamplerBoundedUntilDisc(expressionTemporal);
                }
                return new SamplerUntil(expressionTemporal);
            }
            return Sampler.createSamplerForProbPathPropertySimple(expressionTemporal.convertToUntilForm(), modulesFile);
        }
        throw new PrismException("Can't create sampler for property \"" + expression + "\"");
    }

    private static SamplerDouble createSamplerForRewardProperty(ExpressionReward expressionReward, ModulesFile modulesFile) throws PrismException {
        Object object = expressionReward.getRewardStructIndex();
        int n = -1;
        if (modulesFile.getNumRewardStructs() == 0) {
            throw new PrismException("Model has no rewards specified");
        }
        if (object == null) {
            n = 0;
        } else if (object instanceof Expression) {
            n = ((Expression)object).evaluateInt();
            object = new Integer(n);
            n = n < 1 || n > modulesFile.getNumRewardStructs() ? -1 : n - 1;
        } else if (object instanceof String) {
            n = modulesFile.getRewardStructIndex((String)object);
        }
        if (n == -1) {
            throw new PrismException("Invalid reward structure index \"" + object + "\"");
        }
        ExpressionTemporal expressionTemporal = (ExpressionTemporal)expressionReward.getExpression();
        switch (expressionTemporal.getOperator()) {
            case 11: {
                if (modulesFile.getModelType().continuousTime()) {
                    return new SamplerRewardCumulCont(expressionTemporal, n);
                }
                return new SamplerRewardCumulDisc(expressionTemporal, n);
            }
            case 12: {
                if (modulesFile.getModelType().continuousTime()) {
                    return new SamplerRewardInstCont(expressionTemporal, n);
                }
                return new SamplerRewardInstDisc(expressionTemporal, n);
            }
            case 13: {
                return new SamplerRewardReach(expressionTemporal, n);
            }
        }
        throw new PrismException("Can't create sampler for property \"" + expressionReward + "\"");
    }
}

