/*
 * Decompiled with CFR 0.152.
 */
package simulator.networking;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import prism.PrismException;

public class SSHHandler {
    static String sshCommand = "ssh2";
    static String scpCommand = "scp2";
    static Runtime runtime = Runtime.getRuntime();

    public static void configure(String string, String string2) {
        sshCommand = string;
        scpCommand = string2;
    }

    public static void ssh(String string, String string2, String string3, String[] stringArray) throws PrismException {
        Process process;
        String[] stringArray2 = new String[stringArray.length + 4];
        stringArray2[0] = sshCommand;
        stringArray2[1] = "-x";
        stringArray2[2] = string + "@" + string2;
        stringArray2[3] = string3;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 4] = stringArray[i];
        }
        try {
            process = runtime.exec(stringArray2);
        }
        catch (IOException iOException) {
            throw new PrismException("Could not initiate ssh process on local machine.");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        ErrorGobbler errorGobbler = new ErrorGobbler(process.getErrorStream(), process, Thread.currentThread(), stringBuffer);
        PingController pingController = new PingController(string, string2, Thread.currentThread());
        errorGobbler.start();
        pingController.start();
        try {
            int n = process.waitFor();
            System.out.println("result = " + n);
            if (n != 0) {
                errorGobbler.interrupt();
                pingController.interrupt();
                throw new PrismException("Unknown error executing " + string3 + " on " + string2);
            }
        }
        catch (InterruptedException interruptedException) {
            errorGobbler.interrupt();
            pingController.interrupt();
            process.destroy();
            if (stringBuffer.toString().equals("")) {
                throw new PrismException("SSH process " + string3 + " on " + string2 + " has been stopped.");
            }
            throw new PrismException("SSH process " + string3 + " on " + string2 + " has performed an error:\n" + stringBuffer.toString());
        }
        errorGobbler.interrupt();
        pingController.interrupt();
    }

    public static void scp(String string, String string2, String[] stringArray) throws PrismException {
        Process process;
        int n;
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = scpCommand;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n + 1] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            System.out.print(stringArray2[n] + " ");
        }
        try {
            process = runtime.exec(stringArray2);
        }
        catch (IOException iOException) {
            throw new PrismException("Could not initiate scp process on local machine.");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        ErrorGobbler errorGobbler = new ErrorGobbler(process.getErrorStream(), process, Thread.currentThread(), stringBuffer);
        PingController pingController = new PingController(string, string2, Thread.currentThread());
        errorGobbler.start();
        pingController.start();
        try {
            int n2 = process.waitFor();
            System.out.println("result = " + n2);
            if (n2 != 0) {
                errorGobbler.interrupt();
                pingController.interrupt();
                throw new PrismException("Unknown error executing scp command ");
            }
        }
        catch (InterruptedException interruptedException) {
            errorGobbler.interrupt();
            pingController.interrupt();
            process.destroy();
            if (stringBuffer.toString().equals("")) {
                throw new PrismException("SCP process has been stopped.");
            }
            throw new PrismException("SCP process has performed an error:\n" + stringBuffer.toString());
        }
        errorGobbler.interrupt();
        pingController.interrupt();
    }

    public static void main(String[] stringArray) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String[] stringArray = new String[]{"~/prismnet/binary.bin", "~/prismnet/resandrew.txt", "1000000", "1000", "~/prismnet/control.txt", "~/prismnet/progress.txt", "~/prismnet/resultsProgress.txt"};
                    SSHHandler.ssh("ug60axh", "acws-3414", "~/prism/bin/prismsimulator", stringArray);
                }
                catch (PrismException prismException) {
                    System.out.println("MAIN THREAD CAUSED PRISM EXCEPTION: " + prismException.getMessage());
                    return;
                }
                System.out.println("SUCCESSFUL OUTPUT");
            }
        };
        thread.start();
    }

    static class PingThread
    extends Thread {
        String userName;
        String hostName;
        Thread owner;
        Vector threads;

        PingThread(String string, String string2, Thread thread, Vector vector) {
            this.userName = string;
            this.hostName = string2;
            this.owner = thread;
            this.threads = vector;
            vector.add(this);
        }

        @Override
        public void run() {
            Process process;
            try {
                process = runtime.exec("ssh -x " + this.userName + "@" + this.hostName + " echo test");
            }
            catch (IOException iOException) {
                this.owner.interrupt();
                this.threads.remove(this);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            ErrorGobbler errorGobbler = new ErrorGobbler(process.getErrorStream(), process, Thread.currentThread(), stringBuffer, false);
            errorGobbler.start();
            if (PingThread.interrupted()) {
                errorGobbler.interrupt();
                this.owner.interrupt();
                this.threads.remove(this);
                return;
            }
            try {
                int n = process.waitFor();
                if (n != 0) {
                    errorGobbler.interrupt();
                    this.owner.interrupt();
                }
            }
            catch (InterruptedException interruptedException) {
                errorGobbler.interrupt();
                this.owner.interrupt();
            }
            errorGobbler.interrupt();
            this.threads.remove(this);
        }
    }

    static class PingController
    extends Thread {
        String userName;
        String hostName;
        Thread owner;
        Vector threads;

        PingController(String string, String string2, Thread thread) {
            this.userName = string;
            this.hostName = string2;
            this.owner = thread;
            this.threads = new Vector();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!PingController.interrupted()) {
                    PingThread pingThread = new PingThread(this.userName, this.hostName, Thread.currentThread(), this.threads);
                    pingThread.start();
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                this.owner.interrupt();
                while (true) {
                    Vector vector = this.threads;
                    synchronized (vector) {
                        if (this.threads.size() <= 0) {
                            break;
                        }
                        ((Thread)this.threads.get(0)).interrupt();
                    }
                }
                return;
            }
        }
    }

    static class ErrorGobbler
    extends Thread {
        InputStream is;
        Process proc;
        Thread owner;
        StringBuffer errorOut;
        boolean isPing;

        ErrorGobbler(InputStream inputStream, Process process, Thread thread, StringBuffer stringBuffer) {
            this(inputStream, process, thread, stringBuffer, false);
        }

        ErrorGobbler(InputStream inputStream, Process process, Thread thread, StringBuffer stringBuffer, boolean bl) {
            this.is = inputStream;
            this.proc = process;
            this.owner = thread;
            this.errorOut = stringBuffer;
            this.isPing = bl;
        }

        @Override
        public void run() {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.is);
            try {
                char c = (char)bufferedInputStream.read();
                while (!ErrorGobbler.interrupted() && c != '\uffffffff') {
                    this.errorOut.append(c);
                    c = (char)bufferedInputStream.read();
                    this.proc.destroy();
                }
                this.errorOut.append(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.isPing) {
                this.owner.interrupt();
            }
        }
    }
}

