/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import parser.ast.Expression;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.RelOp;
import prism.PrismException;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;

public abstract class APMCMethod
extends SimulationMethod {
    protected boolean missingParameterComputed = false;
    protected double approximation = 0.0;
    protected double confidence = 0.0;
    protected int numSamples = 0;
    protected int prOp;
    protected double theta;

    @Override
    public String getName() {
        return "APMC";
    }

    @Override
    public String getFullName() {
        return "Approximate Probabilistic Model Checking";
    }

    @Override
    public void reset() {
        this.missingParameterComputed = false;
    }

    @Override
    public abstract void computeMissingParameterBeforeSim() throws PrismException;

    @Override
    public void setExpression(Expression expression) throws PrismException {
        RelOp relOp;
        Expression expression2;
        if (expression instanceof ExpressionProb) {
            expression2 = ((ExpressionProb)expression).getProb();
            relOp = ((ExpressionProb)expression).getRelOp();
        } else if (expression instanceof ExpressionReward) {
            expression2 = ((ExpressionReward)expression).getReward();
            relOp = ((ExpressionReward)expression).getRelOp();
        } else {
            throw new PrismException("Cannot approximate " + expression + " using simulation");
        }
        if (expression2 == null) {
            this.prOp = 0;
            this.theta = -1.0;
        } else {
            this.prOp = relOp.isLowerBound() ? -1 : 1;
            this.theta = expression2.evaluateDouble();
        }
    }

    @Override
    public void computeMissingParameterAfterSim() {
    }

    @Override
    public abstract Object getMissingParameter() throws PrismException;

    @Override
    public abstract String getParametersString();

    @Override
    public boolean shouldStopNow(int n, Sampler sampler) {
        return n >= this.numSamples;
    }

    @Override
    public int getProgress(int n, Sampler sampler) {
        return 10 * n / this.numSamples * 10;
    }

    @Override
    public Object getResult(Sampler sampler) throws PrismException {
        double d = sampler.getMeanValue();
        switch (this.prOp) {
            case 0: {
                return new Double(d);
            }
            case -1: {
                if (d >= this.theta + this.approximation) {
                    return new Boolean(true);
                }
                if (d <= this.theta - this.approximation) {
                    return new Boolean(false);
                }
                throw new PrismException("Approximation is not precise enough to get a result");
            }
            case 1: {
                if (d >= this.theta + this.approximation) {
                    return new Boolean(false);
                }
                if (d <= this.theta - this.approximation) {
                    return new Boolean(true);
                }
                throw new PrismException("Approximation is not precise enough to get a result");
            }
        }
        throw new PrismException("Unknown property type");
    }

    @Override
    public String getResultExplanation(Sampler sampler) {
        return "Pr(|ans - " + sampler.getMeanValue() + "| < " + this.approximation + ") > " + (1.0 - this.confidence);
    }
}

