/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import cern.jet.stat.Probability;
import prism.PrismException;
import simulator.method.CIMethod;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;

public final class ACIwidth
extends CIMethod {
    private double varEstimator;

    public ACIwidth(double d, int n) {
        this.confidence = d;
        this.numSamples = n;
        this.varEstimator = 0.0;
    }

    @Override
    public String getName() {
        return "ACI";
    }

    @Override
    public String getFullName() {
        return "Asymptotic Confidence Interval";
    }

    @Override
    public void computeMissingParameterAfterSim() {
        this.width = Probability.normalInverse((double)(1.0 - this.confidence / 2.0)) * Math.sqrt(this.varEstimator / (double)this.numSamples);
        this.missingParameterComputed = true;
    }

    @Override
    public Object getMissingParameter() throws PrismException {
        if (!this.missingParameterComputed) {
            throw new PrismException("Missing parameter not computed yet");
        }
        return this.width;
    }

    @Override
    public String getParametersString() {
        if (!this.missingParameterComputed) {
            return "width=unknown, confidence=" + this.confidence + ", number of samples=" + this.numSamples;
        }
        return "width=" + this.width + ", confidence=" + this.confidence + ", number of samples=" + this.numSamples;
    }

    @Override
    public boolean shouldStopNow(int n, Sampler sampler) {
        if (n >= this.numSamples) {
            this.varEstimator = sampler.getVariance();
            return true;
        }
        return false;
    }

    @Override
    public int getProgress(int n, Sampler sampler) {
        return 10 * n / this.numSamples * 10;
    }

    @Override
    public Object getResult(Sampler sampler) throws PrismException {
        if (!this.missingParameterComputed) {
            this.computeMissingParameterAfterSim();
        }
        return super.getResult(sampler);
    }

    @Override
    public String getResultExplanation(Sampler sampler) throws PrismException {
        if (!this.missingParameterComputed) {
            this.computeMissingParameterAfterSim();
        }
        return super.getResultExplanation(sampler);
    }

    @Override
    public SimulationMethod clone() {
        ACIwidth aCIwidth = new ACIwidth(this.confidence, this.numSamples);
        aCIwidth.width = this.width;
        aCIwidth.missingParameterComputed = this.missingParameterComputed;
        aCIwidth.prOp = this.prOp;
        aCIwidth.theta = this.theta;
        aCIwidth.varEstimator = this.varEstimator;
        return aCIwidth;
    }
}

