/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import parser.State;
import parser.ast.ModulesFile;
import prism.PrismException;
import prism.PrismLog;
import simulator.LoopDetector;
import simulator.Path;
import simulator.PathDisplayer;
import simulator.PathFullInfo;
import simulator.PathToGraph;
import simulator.PathToText;
import simulator.TransitionList;
import userinterface.graph.Graph;

public class PathFull
extends Path
implements PathFullInfo {
    private ModulesFile modulesFile;
    private boolean continuousTime;
    private int numRewardStructs;
    private ArrayList<Step> steps;
    private int size;
    protected LoopDetector loopDet;

    public PathFull(ModulesFile modulesFile) {
        this.modulesFile = modulesFile;
        this.continuousTime = modulesFile.getModelType().continuousTime();
        this.numRewardStructs = modulesFile.getNumRewardStructs();
        this.steps = new ArrayList(100);
        this.clear();
        this.loopDet = new LoopDetector();
    }

    protected void clear() {
        this.steps.clear();
        this.size = 0;
    }

    @Override
    public void initialise(State state, double[] dArray) {
        this.clear();
        Step step = new Step();
        this.steps.add(step);
        step.state = new State(state);
        step.stateRewards = (double[])dArray.clone();
        step.timeCumul = 0.0;
        for (int i = 0; i < this.numRewardStructs; ++i) {
            step.rewardsCumul[i] = 0.0;
        }
        this.loopDet.initialise();
    }

    @Override
    public void addStep(int n, int n2, double d, double[] dArray, State state, double[] dArray2, TransitionList transitionList) {
        this.addStep(1.0, n, n2, d, dArray, state, dArray2, transitionList);
    }

    @Override
    public void addStep(double d, int n, int n2, double d2, double[] dArray, State state, double[] dArray2, TransitionList transitionList) {
        Step step = this.steps.get(this.steps.size() - 1);
        step.time = d;
        step.choice = n;
        step.moduleOrActionIndex = n2;
        step.probability = d2;
        step.transitionRewards = (double[])dArray.clone();
        Step step2 = new Step();
        this.steps.add(step2);
        step2.state = new State(state);
        step2.stateRewards = (double[])dArray2.clone();
        step2.timeCumul = step.timeCumul + d;
        for (int i = 0; i < this.numRewardStructs; ++i) {
            step2.rewardsCumul[i] = step.rewardsCumul[i];
            if (this.continuousTime) {
                int n3 = i;
                step2.rewardsCumul[n3] = step2.rewardsCumul[n3] + step.stateRewards[i] * d;
            } else {
                int n4 = i;
                step2.rewardsCumul[n4] = step2.rewardsCumul[n4] + step.stateRewards[i];
            }
            int n5 = i;
            step2.rewardsCumul[n5] = step2.rewardsCumul[n5] + dArray[i];
        }
        ++this.size;
        this.loopDet.addStep(this, transitionList);
    }

    public void backtrack(int n) {
        int n2;
        int n3;
        for (n3 = n2 = this.steps.size() - 1; n3 > n; --n3) {
            this.steps.remove(n3);
        }
        Step step = this.steps.get(this.steps.size() - 1);
        step.time = 0.0;
        step.choice = -1;
        step.moduleOrActionIndex = 0;
        step.probability = 0.0;
        for (n3 = 0; n3 < this.numRewardStructs; ++n3) {
            step.transitionRewards[n3] = 0.0;
        }
        this.size = n;
        this.loopDet.backtrack(this);
    }

    public void removePrecedingStates(int n) {
        int n2;
        int n3;
        if (n == 0) {
            return;
        }
        double d = this.getCumulativeTime(n);
        double[] dArray = new double[this.numRewardStructs];
        for (n3 = 0; n3 < this.numRewardStructs; ++n3) {
            dArray[n3] = this.getCumulativeReward(n, n3);
        }
        int n4 = this.steps.size() - n;
        for (n2 = 0; n2 < n4; ++n2) {
            Step step = this.steps.get(n2 + n);
            step.timeCumul -= d;
            for (n3 = 0; n3 < this.numRewardStructs; ++n3) {
                int n5 = n3;
                step.rewardsCumul[n5] = step.rewardsCumul[n5] - dArray[n3];
            }
            this.steps.set(n2, step);
        }
        int n6 = this.steps.size();
        for (n2 = n6 - 1; n2 >= n4; --n2) {
            this.steps.remove(n2);
        }
        this.size = this.steps.size() - 1;
        this.loopDet.removePrecedingStates(this, n);
    }

    @Override
    public boolean continuousTime() {
        return this.continuousTime;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public State getPreviousState() {
        return this.steps.get((int)(this.steps.size() - 2)).state;
    }

    @Override
    public State getCurrentState() {
        return this.steps.get((int)(this.steps.size() - 1)).state;
    }

    @Override
    public int getPreviousModuleOrActionIndex() {
        return this.steps.get((int)(this.steps.size() - 2)).moduleOrActionIndex;
    }

    @Override
    public String getPreviousModuleOrAction() {
        int n = this.getPreviousModuleOrActionIndex();
        if (n < 0) {
            return this.modulesFile.getModuleName(-n - 1);
        }
        if (n > 0) {
            return "[" + this.modulesFile.getSynchs().get(n - 1) + "]";
        }
        return "?";
    }

    @Override
    public double getPreviousProbability() {
        return this.steps.get((int)(this.steps.size() - 2)).probability;
    }

    @Override
    public double getTotalTime() {
        return this.size < 1 ? 0.0 : this.steps.get((int)(this.steps.size() - 1)).timeCumul;
    }

    @Override
    public double getTimeInPreviousState() {
        return this.steps.get((int)(this.steps.size() - 2)).time;
    }

    @Override
    public double getTotalCumulativeReward(int n) {
        return this.steps.get((int)(this.steps.size() - 1)).rewardsCumul[n];
    }

    @Override
    public double getPreviousStateReward(int n) {
        return this.steps.get((int)(this.steps.size() - 2)).stateRewards[n];
    }

    @Override
    public double[] getPreviousStateRewards() {
        return this.steps.get((int)(this.steps.size() - 2)).stateRewards;
    }

    @Override
    public double getPreviousTransitionReward(int n) {
        return this.steps.get((int)(this.steps.size() - 2)).transitionRewards[n];
    }

    @Override
    public double[] getPreviousTransitionRewards() {
        return this.steps.get((int)(this.steps.size() - 2)).transitionRewards;
    }

    @Override
    public double getCurrentStateReward(int n) {
        return this.steps.get((int)(this.steps.size() - 1)).stateRewards[n];
    }

    @Override
    public double[] getCurrentStateRewards() {
        return this.steps.get((int)(this.steps.size() - 1)).stateRewards;
    }

    @Override
    public boolean isLooping() {
        return this.loopDet.isLooping();
    }

    @Override
    public long loopStart() {
        return this.loopDet.loopStart();
    }

    @Override
    public long loopEnd() {
        return this.loopDet.loopEnd();
    }

    @Override
    public State getState(int n) {
        return this.steps.get((int)n).state;
    }

    @Override
    public double getStateReward(int n, int n2) {
        return this.steps.get((int)n).stateRewards[n2];
    }

    protected double[] getStateRewards(int n) {
        return this.steps.get((int)n).stateRewards;
    }

    @Override
    public double getCumulativeTime(int n) {
        return this.steps.get((int)n).timeCumul;
    }

    @Override
    public double getCumulativeReward(int n, int n2) {
        return this.steps.get((int)n).rewardsCumul[n2];
    }

    @Override
    public double getTime(int n) {
        return this.steps.get((int)n).time;
    }

    @Override
    public int getChoice(int n) {
        return this.steps.get((int)n).choice;
    }

    @Override
    public int getModuleOrActionIndex(int n) {
        return this.steps.get((int)n).moduleOrActionIndex;
    }

    @Override
    public String getModuleOrAction(int n) {
        int n2 = this.steps.get((int)n).moduleOrActionIndex;
        if (n2 < 0) {
            return this.modulesFile.getModuleName(-n2 - 1);
        }
        if (n2 > 0) {
            return "[" + this.modulesFile.getSynchs().get(n2 - 1) + "]";
        }
        return "?";
    }

    public double getProbability(int n) {
        return this.steps.get((int)(this.steps.size() - 2)).probability;
    }

    @Override
    public double getTransitionReward(int n, int n2) {
        return this.steps.get((int)n).transitionRewards[n2];
    }

    protected double[] getTransitionRewards(int n) {
        return this.steps.get((int)n).transitionRewards;
    }

    @Override
    public boolean hasRewardInfo() {
        return true;
    }

    @Override
    public boolean hasChoiceInfo() {
        return true;
    }

    @Override
    public boolean hasActionInfo() {
        return true;
    }

    @Override
    public boolean hasTimeInfo() {
        return true;
    }

    @Override
    public boolean hasLoopInfo() {
        return true;
    }

    public void display(PathDisplayer pathDisplayer) throws PrismException {
        if (this.modulesFile == null) {
            return;
        }
        pathDisplayer.start(this.getState(0), this.getStateRewards(0));
        long l = this.size();
        if (l > Integer.MAX_VALUE) {
            throw new PrismException("PathFull cannot deal with paths over length 2147483647");
        }
        int n = (int)l;
        for (int i = 1; i <= n; ++i) {
            pathDisplayer.step(this.getTime(i - 1), this.getCumulativeTime(i), this.getModuleOrAction(i - 1), this.getProbability(i - 1), this.getTransitionRewards(i), i, this.getState(i), this.getStateRewards(i));
        }
        pathDisplayer.end();
    }

    public void displayThreaded(PathDisplayer pathDisplayer) throws PrismException {
        if (this.modulesFile == null) {
            return;
        }
        new DisplayThread(pathDisplayer).start();
    }

    public void exportToLog(PrismLog prismLog, boolean bl, String string, ArrayList<Integer> arrayList) throws PrismException {
        PathToText pathToText = new PathToText(prismLog, this.modulesFile);
        pathToText.setShowTimeCumul(bl);
        pathToText.setColSep(string);
        pathToText.setVarsToShow(arrayList);
        this.display(pathToText);
    }

    public void plotOnGraph(Graph graph) throws PrismException {
        PathToGraph pathToGraph = new PathToGraph(graph, this.modulesFile);
        this.displayThreaded(pathToGraph);
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.size; ++i) {
            string = string + this.getState(i) + "\n";
        }
        return string;
    }

    class DisplayThread
    extends Thread {
        private PathDisplayer displayer = null;

        public DisplayThread(PathDisplayer pathDisplayer) {
            this.displayer = pathDisplayer;
        }

        @Override
        public void run() {
            try {
                PathFull.this.display(this.displayer);
            }
            catch (PrismException prismException) {
                // empty catch block
            }
        }
    }

    class Step {
        public State state = null;
        public double[] stateRewards;
        public double timeCumul;
        public double[] rewardsCumul;
        public double time;
        public int choice;
        public int moduleOrActionIndex;
        public double probability;
        public double[] transitionRewards;

        public Step() {
            this.stateRewards = new double[PathFull.this.numRewardStructs];
            this.timeCumul = 0.0;
            this.rewardsCumul = new double[PathFull.this.numRewardStructs];
            this.time = 0.0;
            this.choice = -1;
            this.moduleOrActionIndex = 0;
            this.probability = 0.0;
            this.transitionRewards = new double[PathFull.this.numRewardStructs];
        }
    }
}

