/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import simulator.Path;
import simulator.TransitionList;

public class LoopDetector {
    private boolean isLooping;
    private long loopStart;
    private long loopEnd;

    public void initialise() {
        this.isLooping = false;
        this.loopEnd = -1L;
        this.loopStart = -1L;
    }

    public void addStep(Path path, TransitionList transitionList) {
        if (this.isLooping) {
            return;
        }
        if (path.continuousTime()) {
            return;
        }
        if (!transitionList.isDeterministic()) {
            return;
        }
        if (path.getPreviousState().equals(path.getCurrentState())) {
            this.isLooping = true;
            this.loopStart = path.size() - 1L;
            this.loopEnd = path.size();
        }
    }

    public void backtrack(Path path) {
        if (this.isLooping && path.size() < this.loopEnd) {
            this.isLooping = false;
            this.loopEnd = -1L;
            this.loopStart = -1L;
        }
    }

    public void removePrecedingStates(Path path, int n) {
        if (this.isLooping) {
            if ((long)n > this.loopStart) {
                this.isLooping = false;
                this.loopEnd = -1L;
                this.loopStart = -1L;
            } else {
                this.loopStart -= (long)n;
                this.loopEnd -= (long)n;
            }
        }
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public long loopStart() {
        return this.loopStart;
    }

    public long loopEnd() {
        return this.loopEnd;
    }
}

