/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import java.util.List;
import parser.State;
import parser.VarList;
import parser.ast.Command;
import parser.ast.Update;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Choice;

public class ChoiceSingleton
implements Choice {
    protected String action;
    protected List<Update> updates = new ArrayList<Update>(1);
    protected double probability;
    protected Command command;

    public void setAction(String string) {
        this.action = string;
    }

    public void addUpdate(Update update) {
        this.updates.add(update);
    }

    public void setProbability(double d) {
        this.probability = d;
    }

    @Override
    public void scaleProbabilitiesBy(double d) {
        this.probability *= d;
    }

    @Override
    public int getModuleOrActionIndex() {
        return 0;
    }

    @Override
    public String getModuleOrAction() {
        return null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int getIndexByProbabilitySum(double d) {
        return 0;
    }

    public String getAction() {
        return this.action;
    }

    @Override
    public String getUpdateString(int n, State state) {
        String string = "(";
        for (Update update : this.updates) {
            string = string + update;
        }
        string = string + ")";
        return string;
    }

    @Override
    public String getUpdateStringFull(int n) {
        return null;
    }

    public State computeTarget(State state) throws PrismLangException {
        State state2 = new State(state);
        for (Update update : this.updates) {
            update.update(state, state2);
        }
        return state2;
    }

    public void computeTarget(State state, State state2) throws PrismLangException {
        for (Update update : this.updates) {
            update.update(state, state2);
        }
    }

    @Override
    public State computeTarget(int n, State state) throws PrismLangException {
        if (n == 0) {
            return this.computeTarget(state);
        }
        throw new PrismLangException("Choice does not have an element " + n);
    }

    @Override
    public void computeTarget(int n, State state, State state2) throws PrismLangException {
        if (n != 0) {
            throw new PrismLangException("Choice does not have an element " + n);
        }
        this.computeTarget(state, state2);
    }

    public double getProbability() {
        return this.probability;
    }

    @Override
    public double getProbability(int n) {
        return n == 0 ? this.probability : -1.0;
    }

    @Override
    public double getProbabilitySum() {
        return this.probability;
    }

    public Command getCommand() {
        return this.command;
    }

    public Command getCommand(int n) {
        return n == 0 ? this.command : null;
    }

    @Override
    public void checkValid(ModelType modelType) throws PrismException {
    }

    @Override
    public void checkForErrors(State state, VarList varList) throws PrismException {
    }

    public String toString() {
        return "-{" + ("".equals(this.action) ? "" : this.action + ",") + this.probability + "}->" + this.updates;
    }
}

