/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import java.util.List;
import parser.State;
import parser.VarList;
import parser.ast.Command;
import parser.ast.Update;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Choice;

public class ChoiceList
implements Choice {
    protected String action;
    protected List<List<Update>> updates;
    protected List<Double> probability;
    protected List<Command> command;

    public ChoiceList(int n) {
        this.updates = new ArrayList<List<Update>>(n);
        this.probability = new ArrayList<Double>(n);
        this.command = new ArrayList<Command>(n);
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setProbability(double d) {
        this.setProbability(0, d);
    }

    public void addProbability(double d) {
        this.probability.add(d);
    }

    public void setProbability(int n, double d) {
        if (n < 0 || n >= this.size()) {
            return;
        }
        this.probability.set(n, d);
    }

    public void setCommand(Command command) {
        this.setCommand(0, command);
    }

    public void addCommand(Command command) {
        this.command.add(command);
    }

    public void setCommand(int n, Command command) {
        if (n < 0 || n >= this.size()) {
            return;
        }
        this.command.set(n, command);
    }

    @Override
    public void scaleProbabilitiesBy(double d) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.probability.set(i, this.probability.get(i) * d);
        }
    }

    @Override
    public int getModuleOrActionIndex() {
        return 0;
    }

    @Override
    public String getModuleOrAction() {
        return null;
    }

    public String getAction() {
        return this.action;
    }

    @Override
    public int size() {
        return this.probability.size();
    }

    @Override
    public String getUpdateString(int n, State state) throws PrismLangException {
        String string = "(";
        for (Update update : this.updates.get(n)) {
            string = string + update;
        }
        string = string + ")";
        return string;
    }

    @Override
    public String getUpdateStringFull(int n) {
        return null;
    }

    public State computeTarget(State state) throws PrismLangException {
        return this.computeTarget(0, state);
    }

    public void computeTarget(State state, State state2) throws PrismLangException {
        this.computeTarget(0, state, state2);
    }

    @Override
    public State computeTarget(int n, State state) throws PrismLangException {
        if (n < 0 || n >= this.size()) {
            throw new PrismLangException("Choice does not have an element " + n);
        }
        State state2 = new State(state);
        for (Update update : this.updates.get(n)) {
            update.update(state, state2);
        }
        return state2;
    }

    @Override
    public void computeTarget(int n, State state, State state2) throws PrismLangException {
        if (n < 0 || n >= this.size()) {
            throw new PrismLangException("Choice does not have an element " + n);
        }
        for (Update update : this.updates.get(n)) {
            update.update(state, state2);
        }
    }

    public double getProbability() {
        return this.getProbability(0);
    }

    @Override
    public double getProbability(int n) {
        if (n < 0 || n >= this.size()) {
            return -1.0;
        }
        return this.probability.get(n);
    }

    @Override
    public double getProbabilitySum() {
        double d = 0.0;
        for (double d2 : this.probability) {
            d += d2;
        }
        return d;
    }

    public Command getCommand() {
        return this.getCommand(0);
    }

    public Command getCommand(int n) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        return this.command.get(n);
    }

    @Override
    public int getIndexByProbabilitySum(double d) {
        int n = this.size();
        int n2 = 0;
        double d2 = 0.0;
        for (n2 = 0; d >= d2 && n2 < n; d2 += this.probability.get(n2).doubleValue(), ++n2) {
        }
        return n2 - 1;
    }

    @Override
    public void checkValid(ModelType modelType) throws PrismException {
    }

    @Override
    public void checkForErrors(State state, VarList varList) throws PrismException {
    }

    public String toString() {
        boolean bl = true;
        String string = "";
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
            } else {
                string = string + " + ";
            }
            string = string + this.getProbability(i) + ":" + this.updates.get(i);
        }
        return string;
    }
}

