/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import settings.Setting;
import settings.SettingEditor;

public class SingleLineStringEditor
implements SettingEditor,
CaretListener,
FocusListener {
    private JTextField field;
    private Font font = new Font("monospaced", 0, 12);
    private JTable lastTable = null;
    private int tableCol = -1;
    private int tableRow = -1;
    private boolean valueGot = true;
    private boolean multiDifferent = false;

    public SingleLineStringEditor() {
        this.field = new JTextField();
        this.field.addCaretListener(this);
        this.field.addFocusListener(this);
    }

    @Override
    public Object getEditorValue() {
        if (this.multiDifferent && this.field.getText().equals("")) {
            this.valueGot = true;
            this.multiDifferent = false;
            return "$%^&*NOTCHANGED*&^%$";
        }
        this.valueGot = true;
        return this.field.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Setting setting, Object object, boolean bl, int n, int n2) {
        ArrayList arrayList;
        this.field.setMargin(new Insets(0, 2, 4, 2));
        if (bl) {
            this.field.setForeground(jTable.getSelectionForeground());
            this.field.setBackground(jTable.getSelectionBackground());
        } else {
            this.field.setForeground(jTable.getForeground());
            this.field.setBackground(jTable.getBackground());
        }
        this.field.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.multiDifferent = false;
        if (object instanceof String) {
            String string = (String)object;
            this.field.setText(string);
            this.field.setCaretColor(Color.black);
            this.field.setFont(this.font);
        } else if (object instanceof ArrayList && (arrayList = (ArrayList)object).size() > 0) {
            String string = null;
            boolean bl2 = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof String)) continue;
                String string2 = (String)arrayList.get(i);
                if (string != null) {
                    if (!string2.equals(string)) {
                        bl2 = false;
                        break;
                    }
                    string = string2;
                    continue;
                }
                string = string2;
            }
            if (bl2) {
                this.field.setText(string);
                this.field.setFont(this.font);
            } else {
                this.field.setText("");
                this.field.setFont(this.font);
                this.multiDifferent = true;
            }
        }
        this.lastTable = jTable;
        this.tableRow = n;
        this.tableCol = n2;
        this.valueGot = false;
        return this.field;
    }

    @Override
    public void stopEditing() {
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.field.getCaret().setVisible(true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!this.valueGot && this.lastTable != null) {
            if (this.multiDifferent && this.field.getText().equals("")) {
                this.valueGot = true;
                this.multiDifferent = false;
            } else {
                this.valueGot = true;
                this.lastTable.setValueAt(this.field.getText(), this.tableRow, this.tableCol);
            }
            if (this.lastTable.getCellEditor() != null) {
                this.lastTable.removeEditor();
            }
        } else {
            this.multiDifferent = false;
        }
    }
}

