/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.util.ArrayList;
import settings.SettingConstraint;
import settings.SettingDisplay;
import settings.SettingEditor;
import settings.SettingException;
import settings.SettingOwner;
import settings.SettingRenderer;

public abstract class Setting {
    private String key;
    private String name;
    private String comment;
    private Object value;
    private boolean editableWhenMultiple;
    private boolean enabled;
    private ArrayList constraints;
    private String version;
    private SettingOwner owner;

    public Setting(String string, Object object, String string2, SettingOwner settingOwner, boolean bl, SettingConstraint settingConstraint) {
        this.name = string;
        this.key = string;
        this.value = object;
        this.comment = string2;
        this.owner = settingOwner;
        this.editableWhenMultiple = bl;
        this.enabled = true;
        this.version = null;
        this.constraints = new ArrayList();
        if (settingConstraint != null) {
            this.addConstraint(settingConstraint);
        }
    }

    public Setting(String string, Object object, String string2, SettingOwner settingOwner, SettingConstraint settingConstraint) {
        this(string, object, string2, settingOwner, false, settingConstraint);
    }

    public Setting(String string, Object object, String string2, SettingOwner settingOwner, boolean bl) {
        this(string, object, string2, settingOwner, bl, null);
    }

    public Setting(String string, Object object, String string2, SettingOwner settingOwner) {
        this(string, object, string2, settingOwner, false, null);
    }

    public void addConstraint(SettingConstraint settingConstraint) {
        if (settingConstraint != null) {
            this.constraints.add(settingConstraint);
        }
    }

    public void removeConstraint(SettingConstraint settingConstraint) {
        this.constraints.remove(settingConstraint);
    }

    public int getNumConstraints() {
        return this.constraints.size();
    }

    public SettingConstraint getConstraint(int n) {
        return (SettingConstraint)this.constraints.get(n);
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public SettingOwner getOwner() {
        return this.owner;
    }

    public boolean isEditableWhenMultiple() {
        return this.editableWhenMultiple;
    }

    public abstract SettingRenderer getSettingRenderer();

    public abstract SettingEditor getSettingEditor();

    public void checkObjectWithConstraints(Object object) throws SettingException {
        for (int i = 0; i < this.getNumConstraints(); ++i) {
            this.getConstraint(i).checkValue(object);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public abstract Class getValueClass();

    public void setValue(Object object) throws SettingException {
        SettingEditor settingEditor = this.getSettingEditor();
        if (settingEditor != null) {
            settingEditor.stopEditing();
        }
        if (object.getClass().isAssignableFrom(this.getValueClass())) {
            this.checkObjectWithConstraints(object);
            this.value = object;
            SettingDisplay settingDisplay = this.getOwner().getDisplay();
            if (settingDisplay != null) {
                settingDisplay.redisplaySetting(this);
            }
        } else {
            throw new SettingException("Invalid type for property: " + this.name);
        }
    }

    public void editValue(Object object) throws SettingException {
        SettingEditor settingEditor = this.getSettingEditor();
        if (settingEditor != null) {
            settingEditor.stopEditing();
        }
        if (object.getClass().isAssignableFrom(this.getValueClass())) {
            this.checkObjectWithConstraints(object);
            this.value = object;
            SettingDisplay settingDisplay = this.getOwner().getDisplay();
            if (settingDisplay != null) {
                settingDisplay.redisplaySetting(this);
            }
        } else {
            throw new SettingException("Invalid type for property: " + this.name);
        }
        this.getOwner().notifySettingChanged(this);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.getSettingEditor().stopEditing();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public String getVersion() {
        return this.version;
    }

    public abstract String toString();

    public abstract Object parseStringValue(String var1) throws SettingException;
}

