/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Color;
import java.awt.Font;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import settings.FontColorConstraint;
import settings.FontColorEditor;
import settings.FontColorPair;
import settings.FontColorRenderer;
import settings.Setting;
import settings.SettingEditor;
import settings.SettingException;
import settings.SettingOwner;
import settings.SettingRenderer;

public class FontColorSetting
extends Setting {
    private static FontColorRenderer renderer = new FontColorRenderer();
    private static FontColorEditor editor = new FontColorEditor();

    public FontColorSetting(String string, FontColorPair fontColorPair, String string2, SettingOwner settingOwner, boolean bl) {
        super(string, (Object)fontColorPair, string2, settingOwner, bl);
    }

    public FontColorSetting(String string, FontColorPair fontColorPair, String string2, SettingOwner settingOwner, boolean bl, FontColorConstraint fontColorConstraint) {
        super(string, fontColorPair, string2, settingOwner, bl, fontColorConstraint);
    }

    @Override
    public SettingEditor getSettingEditor() {
        return editor;
    }

    @Override
    public SettingRenderer getSettingRenderer() {
        return renderer;
    }

    @Override
    public Class getValueClass() {
        return FontColorPair.class;
    }

    public FontColorPair getFontColorValue() {
        return (FontColorPair)this.getValue();
    }

    @Override
    public Object parseStringValue(String string) throws SettingException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            int n5 = Integer.parseInt(stringTokenizer.nextToken());
            return new FontColorPair(new Font(string2, n2, n), new Color(n3, n4, n5));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingException("Error when parsing: " + string + " as a FontColorPair value.");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SettingException("Error when parsing: " + string + " as a FontColorPair value.");
        }
    }

    @Override
    public String toString() {
        Color color = this.getFontColorValue().c;
        Font font = this.getFontColorValue().f;
        return font.getName() + "," + font.getSize() + "," + font.getStyle() + "," + color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }
}

