/*
 * Decompiled with CFR 0.152.
 */
package pta.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class SimpleCharStream {
    public static final boolean staticFlag = true;
    static int bufsize;
    static int available;
    static int tokenBegin;
    public static int bufpos;
    protected static int[] bufline;
    protected static int[] bufcolumn;
    protected static int column;
    protected static int line;
    protected static boolean prevCharIsCR;
    protected static boolean prevCharIsLF;
    protected static Reader inputStream;
    protected static char[] buffer;
    protected static int maxNextCharInd;
    protected static int inBuf;
    protected static int tabSize;

    protected static void setTabSize(int n) {
        tabSize = n;
    }

    protected static int getTabSize(int n) {
        return tabSize;
    }

    protected static void ExpandBuff(boolean bl) {
        char[] cArray = new char[bufsize + 2048];
        int[] nArray = new int[bufsize + 2048];
        int[] nArray2 = new int[bufsize + 2048];
        try {
            if (bl) {
                System.arraycopy(buffer, tokenBegin, cArray, 0, bufsize - tokenBegin);
                System.arraycopy(buffer, 0, cArray, bufsize - tokenBegin, bufpos);
                buffer = cArray;
                System.arraycopy(bufline, tokenBegin, nArray, 0, bufsize - tokenBegin);
                System.arraycopy(bufline, 0, nArray, bufsize - tokenBegin, bufpos);
                bufline = nArray;
                System.arraycopy(bufcolumn, tokenBegin, nArray2, 0, bufsize - tokenBegin);
                System.arraycopy(bufcolumn, 0, nArray2, bufsize - tokenBegin, bufpos);
                bufcolumn = nArray2;
                maxNextCharInd = bufpos += bufsize - tokenBegin;
            } else {
                System.arraycopy(buffer, tokenBegin, cArray, 0, bufsize - tokenBegin);
                buffer = cArray;
                System.arraycopy(bufline, tokenBegin, nArray, 0, bufsize - tokenBegin);
                bufline = nArray;
                System.arraycopy(bufcolumn, tokenBegin, nArray2, 0, bufsize - tokenBegin);
                bufcolumn = nArray2;
                maxNextCharInd = bufpos -= tokenBegin;
            }
        }
        catch (Throwable throwable) {
            throw new Error(throwable.getMessage());
        }
        available = bufsize += 2048;
        tokenBegin = 0;
    }

    protected static void FillBuff() throws IOException {
        if (maxNextCharInd == available) {
            if (available == bufsize) {
                if (tokenBegin > 2048) {
                    maxNextCharInd = 0;
                    bufpos = 0;
                    available = tokenBegin;
                } else if (tokenBegin < 0) {
                    maxNextCharInd = 0;
                    bufpos = 0;
                } else {
                    SimpleCharStream.ExpandBuff(false);
                }
            } else if (available > tokenBegin) {
                available = bufsize;
            } else if (tokenBegin - available < 2048) {
                SimpleCharStream.ExpandBuff(true);
            } else {
                available = tokenBegin;
            }
        }
        try {
            int n = inputStream.read(buffer, maxNextCharInd, available - maxNextCharInd);
            if (n == -1) {
                inputStream.close();
                throw new IOException();
            }
            maxNextCharInd += n;
            return;
        }
        catch (IOException iOException) {
            --bufpos;
            SimpleCharStream.backup(0);
            if (tokenBegin == -1) {
                tokenBegin = bufpos;
            }
            throw iOException;
        }
    }

    public static char BeginToken() throws IOException {
        tokenBegin = -1;
        char c = SimpleCharStream.readChar();
        tokenBegin = bufpos;
        return c;
    }

    protected static void UpdateLineColumn(char c) {
        ++column;
        if (prevCharIsLF) {
            prevCharIsLF = false;
            column = 1;
            ++line;
        } else if (prevCharIsCR) {
            prevCharIsCR = false;
            if (c == '\n') {
                prevCharIsLF = true;
            } else {
                column = 1;
                ++line;
            }
        }
        switch (c) {
            case '\r': {
                prevCharIsCR = true;
                break;
            }
            case '\n': {
                prevCharIsLF = true;
                break;
            }
            case '\t': {
                --column;
                column += tabSize - column % tabSize;
                break;
            }
        }
        SimpleCharStream.bufline[SimpleCharStream.bufpos] = line;
        SimpleCharStream.bufcolumn[SimpleCharStream.bufpos] = column;
    }

    public static char readChar() throws IOException {
        if (inBuf > 0) {
            --inBuf;
            if (++bufpos == bufsize) {
                bufpos = 0;
            }
            return buffer[bufpos];
        }
        if (++bufpos >= maxNextCharInd) {
            SimpleCharStream.FillBuff();
        }
        char c = buffer[bufpos];
        SimpleCharStream.UpdateLineColumn(c);
        return c;
    }

    @Deprecated
    public static int getColumn() {
        return bufcolumn[bufpos];
    }

    @Deprecated
    public static int getLine() {
        return bufline[bufpos];
    }

    public static int getEndColumn() {
        return bufcolumn[bufpos];
    }

    public static int getEndLine() {
        return bufline[bufpos];
    }

    public static int getBeginColumn() {
        return bufcolumn[tokenBegin];
    }

    public static int getBeginLine() {
        return bufline[tokenBegin];
    }

    public static void backup(int n) {
        inBuf += n;
        if ((bufpos -= n) < 0) {
            bufpos += bufsize;
        }
    }

    public SimpleCharStream(Reader reader, int n, int n2, int n3) {
        if (inputStream != null) {
            throw new Error("\n   ERROR: Second call to the constructor of a static SimpleCharStream.\n       You must either use ReInit() or set the JavaCC option STATIC to false\n       during the generation of this class.");
        }
        inputStream = reader;
        line = n;
        column = n2 - 1;
        available = bufsize = n3;
        buffer = new char[n3];
        bufline = new int[n3];
        bufcolumn = new int[n3];
    }

    public SimpleCharStream(Reader reader, int n, int n2) {
        this(reader, n, n2, 4096);
    }

    public SimpleCharStream(Reader reader) {
        this(reader, 1, 1, 4096);
    }

    public void ReInit(Reader reader, int n, int n2, int n3) {
        inputStream = reader;
        line = n;
        column = n2 - 1;
        if (buffer == null || n3 != buffer.length) {
            available = bufsize = n3;
            buffer = new char[n3];
            bufline = new int[n3];
            bufcolumn = new int[n3];
        }
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        inBuf = 0;
        tokenBegin = 0;
        bufpos = -1;
    }

    public void ReInit(Reader reader, int n, int n2) {
        this.ReInit(reader, n, n2, 4096);
    }

    public void ReInit(Reader reader) {
        this.ReInit(reader, 1, 1, 4096);
    }

    public SimpleCharStream(InputStream inputStream, String string, int n, int n2, int n3) throws UnsupportedEncodingException {
        this(string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string), n, n2, n3);
    }

    public SimpleCharStream(InputStream inputStream, int n, int n2, int n3) {
        this(new InputStreamReader(inputStream), n, n2, n3);
    }

    public SimpleCharStream(InputStream inputStream, String string, int n, int n2) throws UnsupportedEncodingException {
        this(inputStream, string, n, n2, 4096);
    }

    public SimpleCharStream(InputStream inputStream, int n, int n2) {
        this(inputStream, n, n2, 4096);
    }

    public SimpleCharStream(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(inputStream, string, 1, 1, 4096);
    }

    public SimpleCharStream(InputStream inputStream) {
        this(inputStream, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream, String string, int n, int n2, int n3) throws UnsupportedEncodingException {
        this.ReInit(string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string), n, n2, n3);
    }

    public void ReInit(InputStream inputStream, int n, int n2, int n3) {
        this.ReInit(new InputStreamReader(inputStream), n, n2, n3);
    }

    public void ReInit(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this.ReInit(inputStream, string, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream, String string, int n, int n2) throws UnsupportedEncodingException {
        this.ReInit(inputStream, string, n, n2, 4096);
    }

    public void ReInit(InputStream inputStream, int n, int n2) {
        this.ReInit(inputStream, n, n2, 4096);
    }

    public static String GetImage() {
        if (bufpos >= tokenBegin) {
            return new String(buffer, tokenBegin, bufpos - tokenBegin + 1);
        }
        return new String(buffer, tokenBegin, bufsize - tokenBegin) + new String(buffer, 0, bufpos + 1);
    }

    public static char[] GetSuffix(int n) {
        char[] cArray = new char[n];
        if (bufpos + 1 >= n) {
            System.arraycopy(buffer, bufpos - n + 1, cArray, 0, n);
        } else {
            System.arraycopy(buffer, bufsize - (n - bufpos - 1), cArray, 0, n - bufpos - 1);
            System.arraycopy(buffer, 0, cArray, n - bufpos - 1, bufpos + 1);
        }
        return cArray;
    }

    public static void Done() {
        buffer = null;
        bufline = null;
        bufcolumn = null;
    }

    public static void adjustBeginLineColumn(int n, int n2) {
        int n3;
        int n4 = tokenBegin;
        int n5 = bufpos >= tokenBegin ? bufpos - tokenBegin + inBuf + 1 : bufsize - tokenBegin + bufpos + 1 + inBuf;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n5 && bufline[n6 = n4 % bufsize] == bufline[n7 = ++n4 % bufsize]; ++n3) {
            SimpleCharStream.bufline[n6] = n;
            n8 = n9 + bufcolumn[n7] - bufcolumn[n6];
            SimpleCharStream.bufcolumn[n6] = n2 + n9;
            n9 = n8;
        }
        if (n3 < n5) {
            SimpleCharStream.bufline[n6] = n++;
            SimpleCharStream.bufcolumn[n6] = n2 + n9;
            while (n3++ < n5) {
                n6 = n4 % bufsize;
                if (bufline[n6] != bufline[++n4 % bufsize]) {
                    SimpleCharStream.bufline[n6] = n++;
                    continue;
                }
                SimpleCharStream.bufline[n6] = n;
            }
        }
        line = bufline[n6];
        column = bufcolumn[n6];
    }

    static {
        bufpos = -1;
        column = 0;
        line = 1;
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        inBuf = 0;
        tabSize = 8;
    }
}

