/*
 * Decompiled with CFR 0.152.
 */
package pta;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import parser.State;
import parser.Values;
import prism.PrismException;
import prism.PrismLangException;
import pta.Constraint;
import pta.DB;
import pta.Edge;
import pta.Transition;
import pta.parser.PTAParser;

public class PTA {
    protected int numClocks = 0;
    protected ArrayList<String> clockNames = new ArrayList();
    protected int numLocations = 0;
    protected ArrayList<Object> locationNames = new ArrayList();
    protected ArrayList<LinkedHashSet<Constraint>> invariants = new ArrayList();
    protected List<String> locationNameVars = null;
    protected int numTransitions = 0;
    protected ArrayList<ArrayList<Transition>> transitions = new ArrayList();
    protected Set<String> alphabet = new LinkedHashSet<String>();
    protected int cMax = 0;
    private static PTAParser parser = null;

    public int addClock(String string) {
        ++this.numClocks;
        this.clockNames.add(string);
        return this.numClocks;
    }

    public int getOrAddClock(String string) {
        int n = this.clockNames.indexOf(string);
        if (n == -1) {
            return this.addClock(string);
        }
        return n + 1;
    }

    public int addLocation() {
        return this.addLocation(null);
    }

    public int addLocation(Object object) {
        ++this.numLocations;
        this.locationNames.add(object == null ? "L" + (this.numLocations - 1) : object);
        this.invariants.add(new LinkedHashSet());
        this.transitions.add(new ArrayList());
        return this.numLocations - 1;
    }

    public int getOrAddLocation(Object object) {
        int n = this.locationNames.indexOf(object);
        if (n == -1) {
            return this.addLocation(object);
        }
        return n;
    }

    public void addInvariantCondition(int n, Constraint constraint) {
        this.invariants.get(n).add(constraint);
        this.recomputeMaxClockConstraint(constraint);
    }

    public void setInvariantConditions(int n, LinkedHashSet<Constraint> linkedHashSet) {
        this.invariants.set(n, linkedHashSet);
        this.recomputeMaxClockConstraint(linkedHashSet);
    }

    public Transition addTransition(int n) {
        return this.addTransition(n, null);
    }

    public Transition addTransition(int n, String string) {
        if (string == null) {
            string = "";
        } else {
            this.alphabet.add(string);
        }
        Transition transition = new Transition(this, n, string);
        ArrayList<Transition> arrayList = this.transitions.get(n);
        arrayList.add(transition);
        ++this.numTransitions;
        return transition;
    }

    public void addTransition(Transition transition) {
        transition.setParent(this);
        this.alphabet.add(transition.getAction());
        ArrayList<Transition> arrayList = this.transitions.get(transition.getSource());
        arrayList.add(transition);
        ++this.numTransitions;
    }

    public void removeTransition(int n, Transition transition) {
        ArrayList<Transition> arrayList = this.transitions.get(n);
        if (arrayList.remove(transition)) {
            --this.numTransitions;
        }
    }

    public int recomputeMaxClockConstraint(Constraint constraint) {
        this.cMax = Math.max(this.cMax, Math.abs(DB.getSignedDiff(constraint.db)));
        return this.cMax;
    }

    public int recomputeMaxClockConstraint(Iterable<Constraint> iterable) {
        for (Constraint constraint : iterable) {
            this.recomputeMaxClockConstraint(constraint);
        }
        return this.cMax;
    }

    public void setLocationNameVars(List<String> list) {
        this.locationNameVars = list;
    }

    public int getNumClocks() {
        return this.numClocks;
    }

    public String getClockName(int n) {
        if (n == 0) {
            return "0";
        }
        return this.clockNames.get(n - 1);
    }

    public int getClockIndex(String string) {
        int n = this.clockNames.indexOf(string);
        return n == -1 ? -1 : n + 1;
    }

    public Object getLocationName(int n) {
        return this.locationNames.get(n);
    }

    public Object getLocationNameString(int n) {
        Object object = this.locationNames.get(n);
        if (object instanceof State && this.locationNameVars != null) {
            return ((State)object).toString(this.locationNameVars);
        }
        return object.toString();
    }

    public List<Object> getLocationNameList() {
        return this.locationNames;
    }

    public int getLocationIndex(Object object) {
        return this.locationNames.indexOf(object);
    }

    public int getNumLocations() {
        return this.numLocations;
    }

    public Iterable<Constraint> getInvariantConstraints(int n) {
        return this.invariants.get(n);
    }

    public List<Transition> getTransitions(int n) {
        return this.transitions.get(n);
    }

    public Iterable<Transition> getTransitionsByAction(final int n, final String string) {
        return new Iterable<Transition>(){

            @Override
            public Iterator<Transition> iterator() {
                return new TransitionsByActionIterator(n, string);
            }
        };
    }

    public int getMaxClockConstraint() {
        return this.cMax;
    }

    public Set<String> getAlphabet() {
        return this.alphabet;
    }

    public boolean isActionInAlphabet(String string) {
        return this.alphabet.contains(string);
    }

    public void check() throws PrismException {
        for (int i = 0; i < this.numLocations; ++i) {
            for (Transition transition : this.getTransitions(i)) {
                transition.check();
            }
        }
    }

    public String infoString() {
        return this.numClocks + " clocks, " + this.numLocations + " locations, " + this.numTransitions + " transitions";
    }

    public String toString() {
        String string = "";
        string = string + "PTA: " + this.numLocations + " locations, " + this.numTransitions + " transitions\n";
        string = string + "  cMax = " + this.cMax + ", clocks = " + this.clockNames + "\n";
        string = string + "   alphabet = " + this.alphabet + "\n";
        for (int i = 0; i < this.numLocations; ++i) {
            string = string + "Location " + i + " (" + this.locationNames.get(i) + "):\n";
            string = string + "  Invariant: " + Constraint.toStringList(this, (Iterable<Constraint>)this.invariants.get(i)) + "\n";
            for (Transition transition : this.getTransitions(i)) {
                string = string + "  " + transition + "\n";
            }
        }
        return string;
    }

    public void writeToDesFile(String string) throws PrismException {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write("#no update for variables\n");
            for (int i = 0; i < this.numLocations; ++i) {
                fileWriter.write("#" + i + "\n{\n");
                if (i == 0) {
                    fileWriter.write("init\n");
                }
                fileWriter.write("\tnode " + this.getLocationName(i).toString().replace(':', '_') + "; ");
                fileWriter.write(Constraint.toStringList(this, (Iterable<Constraint>)this.invariants.get(i)) + "\n");
                for (Transition transition : this.getTransitions(i)) {
                    transition.writeToDesFile(fileWriter);
                }
                if (this.transitions.get(i).isEmpty()) {
                    fileWriter.write("\t[\n\t]\n");
                }
                fileWriter.write(i == this.numLocations - 1 ? "*" : "}");
                fileWriter.write("\n");
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new PrismException("Could not write PTA to file \"" + string + "\"");
        }
    }

    public static Object combineLocationNames(Object object, Object object2) {
        if (object instanceof String && object2 instanceof String) {
            return object + ":" + object2;
        }
        if (object instanceof Object[] && object2 instanceof Object[]) {
            int n;
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
            for (n = 0; n < objectArray.length; ++n) {
                objectArray3[n] = objectArray[n];
            }
            for (n = 0; n < objectArray2.length; ++n) {
                objectArray3[objectArray.length + n] = objectArray2[n];
            }
            return objectArray3;
        }
        if (object instanceof State && object2 instanceof State) {
            return new State((State)object, (State)object2);
        }
        if (object instanceof Values && object2 instanceof Values) {
            Values values = new Values((Values)object);
            values.addValues((Values)object2);
            return values;
        }
        return object + ":" + object2;
    }

    public static int renameClock(PTA pTA, PTA pTA2, int n) {
        int n2 = 0;
        if (n > 0 && (n2 = pTA2.getClockIndex(pTA.getClockName(n))) == -1) {
            System.out.println("Warning: Error renaming clock index " + n);
        }
        return n2;
    }

    public static PTA buildPTAFromDesFile(String string) {
        PTA pTA = null;
        try {
            if (parser == null) {
                parser = new PTAParser();
            }
            pTA = parser.parsePTA(new FileInputStream(string));
        }
        catch (PrismLangException prismLangException) {
            System.out.println("Error in " + string + ": " + prismLangException.getMessage() + ".");
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            System.exit(1);
        }
        return pTA;
    }

    public static PTA buildTestPTA() {
        PTA pTA = new PTA();
        int n = pTA.addClock("x");
        int n2 = pTA.addClock("y");
        pTA.addLocation();
        pTA.addLocation();
        pTA.addLocation();
        pTA.addLocation();
        Transition transition = pTA.addTransition(0);
        Edge edge = transition.addEdge(0.5, 1);
        edge.addReset(n);
        edge = transition.addEdge(0.5, 2);
        transition = pTA.addTransition(1);
        transition.addGuardConstraint(Constraint.buildLeq(n, 0));
        transition.addGuardConstraint(Constraint.buildLeq(n2, 1));
        transition.addGuardConstraint(Constraint.buildGeq(n2, 0));
        edge = transition.addEdge(1.0, 3);
        edge.addReset(n2);
        transition = pTA.addTransition(2);
        transition.addGuardConstraint(Constraint.buildLeq(n, 0));
        transition.addGuardConstraint(Constraint.buildLeq(n2, 0));
        edge = transition.addEdge(1.0, 3);
        return pTA;
    }

    private class TransitionsByActionIterator
    implements Iterator<Transition> {
        private Iterator<Transition> it;
        private String action;
        private Transition next;

        private TransitionsByActionIterator(int n, String string) {
            this.it = PTA.this.transitions.get(n).iterator();
            this.action = string;
            this.computeNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Transition next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Transition transition = this.next;
            this.computeNext();
            return transition;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void computeNext() {
            this.next = null;
            while (this.it.hasNext()) {
                Transition transition = this.it.next();
                if (transition == null || !transition.getAction().equals(this.action)) continue;
                this.next = transition;
                break;
            }
        }
    }
}

