/*
 * Decompiled with CFR 0.152.
 */
package pta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.ParserUtils;
import parser.Values;
import parser.VarList;
import parser.ast.ASTElement;
import parser.ast.Command;
import parser.ast.Declaration;
import parser.ast.DeclarationClock;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionVar;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.RewardStruct;
import parser.ast.RewardStructItem;
import parser.ast.Update;
import parser.ast.Updates;
import parser.type.TypeClock;
import parser.type.TypeInt;
import parser.visitor.ASTTraverse;
import parser.visitor.ASTTraverseModify;
import prism.ModelType;
import prism.Prism;
import prism.PrismLangException;
import prism.PrismLog;

public class DigitalClocks {
    private Prism prism;
    private PrismLog mainLog;
    private ModulesFile modulesFile;
    private PropertiesFile propertiesFile;
    private Values constantValues;
    private VarList varList;
    private boolean doScaling = true;
    private ComputeClockInformation cci;
    private String timeAction;
    private Expression allInVariants = null;
    private ModulesFile mf;
    private PropertiesFile pf;

    public DigitalClocks(Prism prism) {
        this.prism = prism;
        this.mainLog = prism.getMainLog();
        this.mf = null;
        this.pf = null;
    }

    public ModulesFile getNewModulesFile() {
        return this.mf;
    }

    public PropertiesFile getNewPropertiesFile() {
        return this.pf;
    }

    public void translate(ModulesFile modulesFile, PropertiesFile propertiesFile, Expression expression) throws PrismLangException {
        this.mainLog.println("\nPerforming digital clocks translation...");
        this.modulesFile = modulesFile;
        this.propertiesFile = propertiesFile;
        this.constantValues = modulesFile.getConstantValues();
        this.varList = modulesFile.createVarList();
        ASTElement aSTElement = this.findAStrictClockConstraint(modulesFile);
        if (aSTElement != null) {
            throw new PrismLangException("Strict clock constraints are not allowed when using the digital clocks method", aSTElement);
        }
        aSTElement = this.findADiagonalClockConstraint(modulesFile);
        if (aSTElement != null) {
            throw new PrismLangException("Diagonal clock constraints are not allowed when using the digital clocks method", aSTElement);
        }
        for (RewardStruct rewardStruct : modulesFile.getRewardStructs()) {
            rewardStruct.accept(new ASTTraverseModify(){

                @Override
                public Object visit(ExpressionVar expressionVar) throws PrismLangException {
                    if (expressionVar.getType() instanceof TypeClock) {
                        throw new PrismLangException("Reward structures cannot contain references to clocks", expressionVar);
                    }
                    return expressionVar;
                }
            });
        }
        if (expression != null) {
            this.checkProperty(expression);
        }
        this.timeAction = "time";
        while (modulesFile.getSynchs().contains(this.timeAction)) {
            this.timeAction = this.timeAction + "_";
        }
        this.cci = new ComputeClockInformation();
        modulesFile.accept(this.cci);
        this.mainLog.println("Computed clock maximums: " + this.cci.clockMaxs);
        if (this.doScaling) {
            this.mainLog.println("Computed GCD: " + this.cci.getScaleFactor());
        }
        this.mf = (ModulesFile)modulesFile.deepCopy();
        this.pf = propertiesFile == null ? null : (PropertiesFile)propertiesFile.deepCopy();
        this.mf.setModelType(ModelType.MDP);
        this.mf = (ModulesFile)this.mf.accept(new ASTTraverseModify(){

            @Override
            public Object visit(Declaration declaration) throws PrismLangException {
                if (declaration.getDeclType() instanceof DeclarationClock) {
                    int n = DigitalClocks.this.cci.getScaledClockMax(declaration.getName());
                    if (n < 0) {
                        throw new PrismLangException("Clock " + declaration.getName() + " is unbounded since there are no references to it in the model");
                    }
                    DeclarationInt declarationInt = new DeclarationInt(Expression.Int(0), Expression.Int(n + 1));
                    Declaration declaration2 = new Declaration(declaration.getName(), declarationInt);
                    return declaration2;
                }
                return declaration;
            }
        });
        this.allInVariants = null;
        this.mf = (ModulesFile)this.mf.accept(new ASTTraverseModify(){

            @Override
            public Object visit(Module module) throws PrismLangException {
                Expression expression = module.getInvariant();
                Expression expression2 = expression = expression == null ? Expression.True() : expression.deepCopy();
                if (!Expression.isTrue(expression)) {
                    DigitalClocks.this.allInVariants = DigitalClocks.this.allInVariants == null ? expression.deepCopy() : Expression.And(DigitalClocks.this.allInVariants, expression.deepCopy());
                }
                expression = (Expression)expression.accept(new ASTTraverseModify(){

                    @Override
                    public Object visit(ExpressionVar expressionVar) throws PrismLangException {
                        if (expressionVar.getType() instanceof TypeClock) {
                            return Expression.Plus(expressionVar, Expression.Int(1));
                        }
                        return expressionVar;
                    }
                });
                Command command = new Command();
                command.setSynch(DigitalClocks.this.timeAction);
                command.setGuard(expression);
                Update update = new Update();
                for (String string : DigitalClocks.this.cci.getClocksForModule(module.getName())) {
                    int n = DigitalClocks.this.cci.getScaledClockMax(string);
                    ExpressionFunc expressionFunc = new ExpressionFunc("min");
                    expressionFunc.addOperand(Expression.Plus(new ExpressionVar(string, TypeInt.getInstance()), Expression.Int(1)));
                    expressionFunc.addOperand(Expression.Int(n + 1));
                    update.addElement(new ExpressionIdent(string), expressionFunc);
                }
                Updates updates = new Updates();
                updates.addUpdate(Expression.Double(1.0), update);
                command.setUpdates(updates);
                module.addCommand(command);
                module.setInvariant(null);
                return module;
            }
        });
        this.mf.getLabelList().addLabel(new ExpressionIdent("invariants"), this.allInVariants == null ? Expression.True() : this.allInVariants);
        ASTTraverseModify aSTTraverseModify = new ASTTraverseModify(){

            @Override
            public Object visit(Update update) throws PrismLangException {
                int n = update.getNumElements();
                for (int i = 0; i < n; ++i) {
                    if (!(update.getType(i) instanceof TypeClock)) continue;
                    update.setType(i, TypeInt.getInstance());
                    if (DigitalClocks.this.cci.getScaleFactor() <= 1) continue;
                    ExpressionFunc expressionFunc = new ExpressionFunc("floor");
                    expressionFunc.addOperand(Expression.Divide(update.getExpression(i), Expression.Int(DigitalClocks.this.cci.getScaleFactor())));
                    update.setExpression(i, (Expression)expressionFunc.simplify());
                }
                return update;
            }

            @Override
            public Object visit(ExpressionVar expressionVar) throws PrismLangException {
                if (expressionVar.getType() instanceof TypeClock) {
                    expressionVar.setType(TypeInt.getInstance());
                    if (!DigitalClocks.this.doScaling || DigitalClocks.this.cci.getScaleFactor() == 1) {
                        return expressionVar;
                    }
                    return Expression.Times(expressionVar, Expression.Int(DigitalClocks.this.cci.getScaleFactor()));
                }
                return expressionVar;
            }
        };
        this.mf = (ModulesFile)this.mf.accept(aSTTraverseModify);
        if (this.pf != null) {
            this.pf = (PropertiesFile)this.pf.accept(aSTTraverseModify);
        }
        for (RewardStruct rewardStruct : this.mf.getRewardStructs()) {
            int n = rewardStruct.getNumItems();
            for (int i = 0; i < n; ++i) {
                RewardStructItem rewardStructItem = rewardStruct.getRewardStructItem(i);
                if (rewardStructItem.isTransitionReward()) continue;
                Expression expression2 = rewardStructItem.getReward().deepCopy();
                if (this.cci.getScaleFactor() > 1) {
                    expression2 = Expression.Times(expression2, Expression.Int(this.cci.getScaleFactor()));
                }
                rewardStructItem = new RewardStructItem(this.timeAction, rewardStructItem.getStates().deepCopy(), expression2);
                rewardStruct.setRewardStructItem(i, rewardStructItem);
            }
        }
        this.mf.tidyUp();
        if (this.pf != null) {
            this.pf.tidyUp();
        }
    }

    public void checkProperty(Expression expression) throws PrismLangException {
        try {
            expression.accept(new ASTTraverse(){

                @Override
                public void visitPost(ExpressionProb expressionProb) throws PrismLangException {
                    if (!expressionProb.getExpression().isSimplePathFormula()) {
                        throw new PrismLangException("The digital clocks method does not support LTL properties");
                    }
                }
            });
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(expression);
            throw prismLangException;
        }
        try {
            expression.accept(new ASTTraverse(){

                @Override
                public void visitPost(ExpressionTemporal expressionTemporal) throws PrismLangException {
                    if (expressionTemporal.getLowerBound() != null || expressionTemporal.getUpperBound() != null) {
                        throw new PrismLangException("The digital clocks method does not yet support bounded properties");
                    }
                }
            });
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(expression);
            throw prismLangException;
        }
        if (expression.computeProbNesting() > 1) {
            throw new PrismLangException("Nested P operators are not allowed when using the digital clocks method", expression);
        }
        ASTElement aSTElement = this.findAStrictClockConstraint(expression);
        if (aSTElement != null) {
            throw new PrismLangException("Strict clock constraints are not allowed when using the digital clocks method", aSTElement);
        }
        aSTElement = this.findADiagonalClockConstraint(this.modulesFile);
        if (aSTElement != null) {
            throw new PrismLangException("Diagonal clock constraints are not allowed when using the digital clocks method", aSTElement);
        }
    }

    public ASTElement findAStrictClockConstraint(ASTElement aSTElement) throws PrismLangException {
        try {
            ASTTraverse aSTTraverse = new ASTTraverse(){

                @Override
                public void visitPost(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
                    if (expressionBinaryOp.getOperand1().getType() instanceof TypeClock ? expressionBinaryOp.getOperator() == 7 || expressionBinaryOp.getOperator() == 9 : expressionBinaryOp.getOperand2().getType() instanceof TypeClock && (expressionBinaryOp.getOperator() == 7 || expressionBinaryOp.getOperator() == 9)) {
                        throw new PrismLangException("Found one", expressionBinaryOp);
                    }
                }
            };
            aSTElement.accept(aSTTraverse);
        }
        catch (PrismLangException prismLangException) {
            return prismLangException.getASTElement();
        }
        return null;
    }

    public ASTElement findADiagonalClockConstraint(ASTElement aSTElement) throws PrismLangException {
        try {
            ASTTraverse aSTTraverse = new ASTTraverse(){

                @Override
                public void visitPost(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
                    if (expressionBinaryOp.getOperand1().getType() instanceof TypeClock && expressionBinaryOp.getOperand2().getType() instanceof TypeClock) {
                        throw new PrismLangException("Found one", expressionBinaryOp);
                    }
                }
            };
            this.modulesFile.accept(aSTTraverse);
        }
        catch (PrismLangException prismLangException) {
            return prismLangException.getASTElement();
        }
        return null;
    }

    class ComputeClockInformation
    extends ASTTraverse {
        private Map<String, List<String>> clockLists = new HashMap<String, List<String>>();
        private List<String> currentClockList;
        private Map<String, Integer> clockMaxs = new HashMap<String, Integer>();
        private Set<Integer> allClockVals = new HashSet<Integer>();
        private int scaleFactor;

        private void updateMax(String string, int n) {
            Integer n2 = this.clockMaxs.get(string);
            if (n2 == null || n > n2) {
                this.clockMaxs.put(string, n);
            }
        }

        public List<String> getClocksForModule(String string) {
            ArrayList arrayList = this.clockLists.get(string);
            return arrayList == null ? new ArrayList() : arrayList;
        }

        public int getClockMax(String string) {
            Integer n = this.clockMaxs.get(string);
            return n == null ? -1 : n;
        }

        public int getScaledClockMax(String string) {
            Integer n = this.clockMaxs.get(string);
            return n == null ? -1 : (DigitalClocks.this.doScaling ? n / this.scaleFactor : n);
        }

        public int getScaleFactor() {
            return this.scaleFactor;
        }

        private int computeGCD(Iterable<Integer> iterable) {
            int n = 0;
            for (int n2 : iterable) {
                n = this.computeGCD(n, n2);
            }
            if (n == 0) {
                n = 1;
            }
            return n;
        }

        private int computeGCD(int n, int n2) {
            return n2 == 0 ? n : this.computeGCD(n2, n % n2);
        }

        @Override
        public void visitPost(ModulesFile modulesFile) throws PrismLangException {
            this.scaleFactor = this.computeGCD(this.allClockVals);
        }

        @Override
        public void visitPre(Module module) throws PrismLangException {
            this.currentClockList = new ArrayList<String>();
            this.clockLists.put(module.getName(), this.currentClockList);
        }

        @Override
        public void visitPost(Declaration declaration) throws PrismLangException {
            if (declaration.getDeclType() instanceof DeclarationClock) {
                this.currentClockList.add(declaration.getName());
            }
        }

        @Override
        public Object visit(Update update) throws PrismLangException {
            int n = update.getNumElements();
            for (int i = 0; i < n; ++i) {
                if (!(update.getType(i) instanceof TypeClock)) continue;
                String string = update.getVar(i);
                int n2 = ParserUtils.findMaxForIntExpression(update.getExpression(i), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                this.updateMax(string, n2);
                Collection<Integer> collection = ParserUtils.findAllValsForIntExpression(update.getExpression(i), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                this.allClockVals.addAll(collection);
            }
            return update;
        }

        @Override
        public void visitPost(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
            if (expressionBinaryOp.getOperand1().getType() instanceof TypeClock) {
                if (!(expressionBinaryOp.getOperand2().getType() instanceof TypeClock)) {
                    String string = ((ExpressionVar)expressionBinaryOp.getOperand1()).getName();
                    int n = ParserUtils.findMaxForIntExpression(expressionBinaryOp.getOperand2(), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                    this.updateMax(string, n);
                    Collection<Integer> collection = ParserUtils.findAllValsForIntExpression(expressionBinaryOp.getOperand2(), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                    this.allClockVals.addAll(collection);
                }
            } else if (expressionBinaryOp.getOperand2().getType() instanceof TypeClock) {
                String string = ((ExpressionVar)expressionBinaryOp.getOperand2()).getName();
                int n = ParserUtils.findMaxForIntExpression(expressionBinaryOp.getOperand1(), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                this.updateMax(string, n);
                Collection<Integer> collection = ParserUtils.findAllValsForIntExpression(expressionBinaryOp.getOperand1(), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                this.allClockVals.addAll(collection);
            }
        }
    }
}

