/*
 * Decompiled with CFR 0.152.
 */
package pta;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import pta.Constraint;
import pta.DB;
import pta.DBM;
import pta.NCZone;
import pta.PTA;
import pta.Zone;

public class DBMList
extends NCZone {
    protected PTA pta;
    protected ArrayList<DBM> list;
    public static boolean checkInclusion = true;

    public DBMList(PTA pTA) {
        this.pta = pTA;
        this.list = new ArrayList();
    }

    public DBMList(Zone zone) {
        if (zone instanceof DBM) {
            DBM dBM = (DBM)zone;
            this.pta = dBM.pta;
            this.list = new ArrayList();
            this.addDBM(dBM);
        } else {
            DBMList dBMList = (DBMList)zone;
            this.pta = dBMList.pta;
            this.list = new ArrayList();
            for (DBM dBM : dBMList.list) {
                this.list.add(dBM.deepCopy());
            }
        }
    }

    public void addDBM(DBM dBM) {
        if (!checkInclusion) {
            this.list.add(dBM);
        } else {
            int n = this.list.size();
            BitSet bitSet = new BitSet(n);
            int n2 = 0;
            for (DBM dBM2 : this.list) {
                if (dBM2.includes(dBM)) {
                    return;
                }
                if (dBM.includes(dBM2)) {
                    bitSet.set(n2);
                }
                ++n2;
            }
            for (n2 = n - 1; n2 >= 0; --n2) {
                if (!bitSet.get(n2)) continue;
                this.list.remove(n2);
            }
            this.list.add(dBM);
        }
    }

    public void addDBMs(DBMList dBMList) {
        for (DBM dBM : dBMList.list) {
            this.addDBM(dBM);
        }
    }

    public DBM getDBM(int n) {
        return this.list.get(n);
    }

    @Override
    public PTA getPTA() {
        return this.pta;
    }

    @Override
    public void addConstraint(int n, int n2, int n3) {
        for (DBM dBM : this.list) {
            dBM.addConstraint(n, n2, n3);
        }
        if (checkInclusion) {
            this.removeInclusions();
        }
    }

    @Override
    public void addConstraint(Constraint constraint) {
        this.addConstraint(constraint.x, constraint.y, constraint.db);
    }

    @Override
    public void addConstraints(Iterable<Constraint> iterable) {
        for (Constraint constraint : iterable) {
            this.addConstraint(constraint);
        }
    }

    @Override
    public void intersect(Zone zone) {
        if (zone instanceof DBM) {
            zone = new DBMList((DBM)zone);
        }
        DBMList dBMList = (DBMList)zone;
        DBMList dBMList2 = new DBMList(this.pta);
        int n = this.list.size();
        int n2 = dBMList.list.size();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                DBM dBM = this.list.get(i).deepCopy();
                dBM.intersect(dBMList.list.get(j));
                if (dBM.isEmpty()) continue;
                dBMList2.addDBM(dBM);
            }
        }
        this.list = dBMList2.list;
    }

    @Override
    public void up(Iterable<Constraint> iterable) {
        for (DBM dBM : this.list) {
            dBM.up(iterable);
        }
        if (checkInclusion) {
            this.removeInclusions();
        }
    }

    @Override
    public void down(Iterable<Constraint> iterable) {
        for (DBM dBM : this.list) {
            dBM.down(iterable);
        }
        if (checkInclusion) {
            this.removeInclusions();
        }
    }

    @Override
    public void free(int n) {
        for (DBM dBM : this.list) {
            dBM.free(n);
        }
        if (checkInclusion) {
            this.removeInclusions();
        }
    }

    @Override
    public void reset(int n, int n2) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void backReset(int n, int n2) {
        for (DBM dBM : this.list) {
            dBM.addConstraint(n, 0, DB.createLeq(n2));
            dBM.addConstraint(0, n, DB.createLeq(-n2));
        }
        for (DBM dBM : this.list) {
            dBM.free(n);
        }
        if (checkInclusion) {
            this.removeInclusions();
        }
    }

    @Override
    public void cClosure(int n) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public DBMList createComplement() {
        DBMList dBMList = this.deepCopy();
        dBMList.complement();
        return dBMList;
    }

    @Override
    public boolean isEmpty() {
        for (DBM dBM : this.list) {
            if (dBM.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSatisfied(Constraint constraint) {
        for (DBM dBM : this.list) {
            if (dBM.isSatisfied(constraint)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean includes(DBM dBM) {
        for (DBM dBM2 : this.list) {
            if (!dBM2.includes(dBM)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getClockMin(int n) {
        int n2 = Integer.MAX_VALUE;
        for (DBM dBM : this.list) {
            n2 = Math.min(n2, dBM.getClockMin(n));
        }
        return n2;
    }

    @Override
    public int getClockMax(int n) {
        int n2 = Integer.MIN_VALUE;
        for (DBM dBM : this.list) {
            n2 = Math.max(n2, dBM.getClockMax(n));
        }
        return n2;
    }

    @Override
    public boolean clockIsUnbounded(int n) {
        for (DBM dBM : this.list) {
            if (!dBM.clockIsUnbounded(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allClocksAreUnbounded() {
        int n = this.pta.numClocks;
        for (int i = 1; i < n + 1; ++i) {
            if (this.clockIsUnbounded(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void intersectComplement(Zone zone) {
        if (zone instanceof DBM) {
            zone = new DBMList((DBM)zone);
        }
        DBMList dBMList = (DBMList)zone;
        for (DBM dBM : dBMList.list) {
            DBMList dBMList2 = dBM.createComplement();
            this.intersect(dBMList2);
        }
    }

    @Override
    public void complement() {
        DBMList dBMList = null;
        if (this.list.size() == 0) {
            this.addDBM(DBM.createTrue(this.pta));
        }
        for (DBM dBM : this.list) {
            DBMList dBMList2 = dBM.createComplement();
            if (dBMList == null) {
                dBMList = dBMList2;
            } else {
                dBMList.intersect(dBMList2);
            }
            if (dBMList.list.size() != 0) continue;
            break;
        }
        this.list = dBMList.list;
    }

    @Override
    public void union(Zone zone) {
        if (zone instanceof DBM) {
            this.addDBM((DBM)zone);
        } else {
            this.addDBMs((DBMList)zone);
        }
    }

    @Override
    public Zone getAZone() {
        if (this.list.size() > 0) {
            return this.list.get(0);
        }
        return null;
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public DBMList deepCopy() {
        DBMList dBMList = new DBMList(this.pta);
        for (DBM dBM : this.list) {
            dBMList.list.add(dBM.deepCopy());
        }
        return dBMList;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (DBM dBM : this.list) {
            n = n * 7 + dBM.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        DBMList dBMList;
        if (object == null) {
            return false;
        }
        try {
            dBMList = (DBMList)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        int n = this.list.size();
        if (n != dBMList.list.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.list.get(i).equals(dBMList.list.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "" + this.list;
    }

    @Override
    public String storageInfo() {
        return "List of " + this.list.size() + " DBMs with " + this.pta.numClocks + " clocks";
    }

    public static DBMList createFalse(PTA pTA) {
        DBMList dBMList = new DBMList(pTA);
        return dBMList;
    }

    private void removeInclusions() {
        int n;
        int n2 = this.list.size();
        BitSet bitSet = new BitSet(n2);
        for (n = 0; n < n2; ++n) {
            if (bitSet.get(n)) continue;
            DBM dBM = this.list.get(n);
            for (int i = n + 1; i < n2; ++i) {
                if (bitSet.get(n) || bitSet.get(i)) continue;
                DBM dBM2 = this.list.get(i);
                if (dBM2.includes(dBM)) {
                    bitSet.set(n);
                    continue;
                }
                if (!dBM.includes(dBM2)) continue;
                bitSet.set(i);
            }
        }
        for (n = n2 - 1; n >= 0; --n) {
            if (!bitSet.get(n)) continue;
            this.list.remove(n);
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 7;
        Random random = new Random();
        PTA pTA = new PTA();
        for (n = 0; n < n2; ++n) {
            pTA.addClock("" + n);
        }
        DBMList dBMList = new DBMList(pTA);
        for (n = 0; n < 5; ++n) {
            DBM dBM = DBM.createTrue(pTA);
            for (int i = 0; i < 10; ++i) {
                int n3 = random.nextInt(n2);
                int n4 = random.nextInt(n2);
                int n5 = random.nextInt();
                dBM.addConstraint(n3, n4, n5);
            }
            dBMList.addDBM(dBM);
        }
        System.out.println(dBMList.storageInfo());
        dBMList.complement();
        System.out.println(dBMList.storageInfo());
    }
}

