/*
 * Decompiled with CFR 0.152.
 */
package pta;

import pta.PTA;

public class DB {
    protected static final int NON_STRICT = 1;
    protected static final int DIFF_MASK = -2;
    protected static final int INFTY = Integer.MAX_VALUE;
    protected static final int LEQ_ZERO = 1;
    protected static final int LT_ZERO = 0;
    protected static final int LEQ_MINUS_ONE = -1;

    protected static int createLeq(int n) {
        return n << 1 | 1;
    }

    protected static int createLt(int n) {
        return n << 1;
    }

    protected static int getSignedDiff(int n) {
        return (0xFFFFFFFE & n) >> 1;
    }

    protected static boolean isStrict(int n) {
        return (1 & n) == 0;
    }

    protected static boolean isInfty(int n) {
        return n == Integer.MAX_VALUE;
    }

    protected static int add(int n, int n2) {
        if (n == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return n + n2 - (n & 1 | n2 & 1);
    }

    protected static int dual(int n) {
        if (n == Integer.MAX_VALUE) {
            return n;
        }
        return DB.isStrict(n) ? DB.createLeq(-DB.getSignedDiff(n)) : DB.createLt(-DB.getSignedDiff(n));
    }

    protected static String toString(int n) {
        if (n == Integer.MAX_VALUE) {
            return "<inf";
        }
        return (DB.isStrict(n) ? "<" : "<=") + DB.getSignedDiff(n);
    }

    protected static String toStringFlipped(int n) {
        if (n == Integer.MAX_VALUE) {
            return "-inf<";
        }
        return -DB.getSignedDiff(n) + (DB.isStrict(n) ? "<" : "<=");
    }

    protected static String constraintToString(int n, int n2, int n3, PTA pTA) {
        String string;
        if (n > 0) {
            if (n2 > 0) {
                string = pTA.getClockName(n);
                string = DB.isInfty(n3) ? string + "-" + pTA.getClockName(n2) + "<inf" : (DB.getSignedDiff(n3) == 0 ? string + (DB.isStrict(n3) ? "<" : "<=") + pTA.getClockName(n2) : string + "-" + pTA.getClockName(n2) + (DB.isStrict(n3) ? "<" : "<=") + DB.getSignedDiff(n3));
            } else {
                string = pTA.getClockName(n);
                string = DB.isInfty(n3) ? string + "<inf" : string + (DB.isStrict(n3) ? "<" : "<=") + DB.getSignedDiff(n3);
            }
        } else {
            string = pTA.getClockName(n2);
            string = DB.isInfty(n3) ? string + ">-inf" : string + (DB.isStrict(n3) ? ">" : ">=") + -DB.getSignedDiff(n3);
        }
        return string;
    }

    protected static String constraintPairToString(int n, int n2, int n3, int n4, PTA pTA) {
        String string = n > 0 ? (n2 > 0 ? (!DB.isInfty(n3) && -DB.getSignedDiff(n4) == DB.getSignedDiff(n3) ? (DB.getSignedDiff(n4) == 0 ? pTA.getClockName(n) + "=" + pTA.getClockName(n2) : pTA.getClockName(n) + "-" + pTA.getClockName(n2) + "=" + DB.getSignedDiff(n3)) : DB.toStringFlipped(n4) + pTA.getClockName(n) + "-" + pTA.getClockName(n2) + DB.toString(n3)) : (!DB.isInfty(n3) && -DB.getSignedDiff(n4) == DB.getSignedDiff(n3) ? pTA.getClockName(n) + "=" + DB.getSignedDiff(n3) : DB.toStringFlipped(n4) + pTA.getClockName(n) + DB.toString(n3))) : (!DB.isInfty(n3) && -DB.getSignedDiff(n4) == DB.getSignedDiff(n3) ? pTA.getClockName(n2) + "=" + DB.getSignedDiff(n4) : DB.toStringFlipped(n3) + pTA.getClockName(n2) + DB.toString(n4));
        return string;
    }
}

