/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.List;
import parser.ast.Expression;
import prism.OpsAndBoundsList;
import prism.Point;
import prism.PrismException;
import prism.Tile;

public class TileList {
    private double tolerance;
    private OpsAndBoundsList opsAndBoundsList;
    protected static List<TileList> storedTileLists;
    protected static List<Expression> storedFormulasX;
    protected static List<Expression> storedFormulasY;
    protected static List<Expression> storedFormulas;
    protected int currentProjectionIndex = 0;
    protected ArrayList<Tile> list;
    protected Tile initialTile;
    protected int dim;

    public OpsAndBoundsList getOpsAndBoundsList() {
        return this.opsAndBoundsList;
    }

    public static List<TileList> getStoredTileLists() {
        return storedTileLists;
    }

    public static List<Expression> getStoredFormulasX() {
        return storedFormulasX;
    }

    public static List<Expression> getStoredFormulasY() {
        return storedFormulasY;
    }

    public static List<Expression> getStoredFormulas() {
        return storedFormulas;
    }

    public static void clearStoredTileLists() {
        storedFormulasX.clear();
        storedFormulasY.clear();
        storedFormulas.clear();
        storedTileLists.clear();
    }

    public TileList(Tile tile, OpsAndBoundsList opsAndBoundsList, double d) {
        this.dim = tile.cornerPoints.get(0).getDimension();
        this.initialTile = tile;
        this.list = new ArrayList();
        this.list.add(tile);
        this.opsAndBoundsList = opsAndBoundsList;
        this.tolerance = d;
        if (this.dim == 2) {
            this.currentProjectionIndex = 2;
        }
    }

    public String toString() {
        String string = "[";
        boolean bl = true;
        for (int i = 0; i < this.list.size(); ++i) {
            Tile tile = this.list.get(i);
            for (Point point : tile.cornerPoints) {
                if (this.opsAndBoundsList != null) {
                    point = point.toRealProperties(this.opsAndBoundsList);
                }
                if (bl) {
                    bl = false;
                } else {
                    string = string + ",\n";
                }
                string = string + "(";
                for (int j = 0; j < point.getDimension(); ++j) {
                    if (j > 0) {
                        string = string + ",";
                    }
                    string = string + point.getCoord(j);
                }
                string = string + ")";
            }
        }
        string = string + "]";
        return string;
    }

    public Point getCandidateHyperplane() {
        return this.getFreshRealCandidateHyperplane();
    }

    private Point getFreshRealCandidateHyperplane() {
        while (this.currentProjectionIndex < this.dim) {
            for (Tile tile : this.list) {
                if (tile.isUpperBound(this.currentProjectionIndex) || !tile.liesOnBoundary(this.currentProjectionIndex)) continue;
                tile.hyperplaneSuggested = true;
                Point point = Tile.getWeightsForTile(tile);
                Point point2 = point.clone();
                point2.setCoord(this.currentProjectionIndex, 0.0);
                return point2.isZero() ? point : point2.normalize();
            }
            ++this.currentProjectionIndex;
        }
        for (Tile tile : this.list) {
            if (tile.isUpperBound(this.dim)) continue;
            tile.hyperplaneSuggested = true;
            return Tile.getWeightsForTile(tile);
        }
        return null;
    }

    public int getNumberOfDifferentPoints() {
        return this.getPoints().size();
    }

    public List<Point> getPoints() {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (Tile tile : this.list) {
            for (Point point : tile.cornerPoints) {
                if (arrayList.contains(point)) continue;
                arrayList.add(point);
            }
        }
        return arrayList;
    }

    public void addNewPoint(Point point) throws PrismException {
        if (this.currentProjectionIndex < this.dim && point.getCoord(this.currentProjectionIndex) > 0.0) {
            Point point2 = point.clone();
            point2.setCoord(this.currentProjectionIndex, 0.0);
            this.splitTilesByPoint(point2, false);
        } else {
            this.splitTilesByPoint(point, this.currentProjectionIndex == this.dim);
        }
    }

    protected void splitTilesByPoint(Point point, boolean bl) throws PrismException {
        ArrayList<Tile> arrayList = new ArrayList<Tile>();
        for (Tile object : this.list) {
            boolean tile = object.processNewPoint(point, true, this.currentProjectionIndex);
            if (!tile) continue;
            arrayList.add(object);
        }
        ArrayList arrayList2 = new ArrayList();
        for (Tile tile : arrayList) {
            arrayList2.addAll(tile.cornerPoints);
        }
        for (Tile tile : arrayList) {
            this.list.remove(tile);
            List<Tile> list = tile.splitByPoint(point, arrayList2, this.tolerance);
            this.list.addAll(list);
        }
    }

    public int getDimension() {
        return this.dim;
    }

    static {
        storedFormulasX = new ArrayList<Expression>();
        storedFormulasY = new ArrayList<Expression>();
        storedFormulas = new ArrayList<Expression>();
        storedTileLists = new ArrayList<TileList>();
    }
}

