/*
 * Decompiled with CFR 0.152.
 */
package prism;

import dv.DoubleVector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import parser.VarList;
import parser.ast.RelOp;
import parser.type.TypeInt;
import prism.Model;
import prism.PrismException;
import prism.PrismLog;
import prism.StateValues;
import prism.StateValuesMTBDD;

public class StateValuesDV
implements StateValues {
    DoubleVector values;
    Model model;
    JDDVars vars;
    int numVars;
    ODDNode odd;
    VarList varList;
    int[] varSizes;
    int[] varValues;
    int currentVar;
    int currentVarLevel;
    int counter;
    PrismLog outputLog;
    boolean printSparse = true;
    boolean printMatlab = false;
    boolean printStates = true;
    boolean printIndices = true;

    public StateValuesDV(DoubleVector doubleVector, Model model) {
        this.values = doubleVector;
        this.model = model;
        this.vars = this.model.getAllDDRowVars();
        this.numVars = this.vars.n();
        this.odd = this.model.getODD();
        this.varList = this.model.getVarList();
        this.varSizes = new int[this.varList.getNumVars()];
        for (int i = 0; i < this.varList.getNumVars(); ++i) {
            this.varSizes[i] = this.varList.getRangeLogTwo(i);
        }
        this.varValues = new int[this.varList.getNumVars()];
    }

    public StateValuesDV(JDDNode jDDNode, Model model) {
        this(new DoubleVector(jDDNode, model.getAllDDRowVars(), model.getODD()), model);
    }

    @Override
    public StateValuesDV convertToStateValuesDV() {
        return this;
    }

    @Override
    public StateValuesMTBDD convertToStateValuesMTBDD() {
        StateValuesMTBDD stateValuesMTBDD = new StateValuesMTBDD(this.values.convertToMTBDD(this.vars, this.odd), this.model);
        this.clear();
        return stateValuesMTBDD;
    }

    private void setElement(int n, double d) {
        this.values.setElement(n, d);
    }

    @Override
    public void readFromFile(File file) throws PrismException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = this.values.getSize();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                if (!"".equals(string = string.trim())) {
                    if (string.contains("=")) {
                        bl = true;
                        String[] stringArray = string.split("=");
                        n2 = Integer.parseInt(stringArray[0]);
                        string = stringArray[1];
                    }
                    if (n2 + 1 > n3) {
                        bufferedReader.close();
                        throw new PrismException("Too many values in file \"" + file + "\" (more than " + n3 + ")");
                    }
                    double d = Double.parseDouble(string);
                    this.setElement(n2, d);
                    ++n2;
                }
                string = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
            if (!bl && n2 < n3) {
                throw new PrismException("Too few values in file \"" + file + "\" (" + n2 + ", not " + n3 + ")");
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of file \"" + file + "\"");
        }
    }

    @Override
    public void roundOff(int n) {
        this.values.roundOff(n);
    }

    @Override
    public void subtractFromOne() {
        this.values.subtractFromOne();
    }

    @Override
    public void add(StateValues stateValues) {
        this.values.add(((StateValuesDV)stateValues).values);
    }

    @Override
    public void timesConstant(double d) {
        this.values.timesConstant(d);
    }

    @Override
    public double dotProduct(StateValues stateValues) {
        return this.values.dotProduct(((StateValuesDV)stateValues).values);
    }

    @Override
    public void filter(JDDNode jDDNode) {
        this.values.filter(jDDNode, this.vars, this.odd);
    }

    @Override
    public void maxMTBDD(JDDNode jDDNode) {
        this.values.maxMTBDD(jDDNode, this.vars, this.odd);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public int getSize() {
        return this.values.getSize();
    }

    @Override
    public Object getValue(int n) {
        return this.values.getElement(n);
    }

    public DoubleVector getDoubleVector() {
        return this.values;
    }

    @Override
    public int getNNZ() {
        return this.values.getNNZ();
    }

    @Override
    public String getNNZString() {
        return "" + this.getNNZ();
    }

    @Override
    public double firstFromBDD(JDDNode jDDNode) {
        return this.values.firstFromBDD(jDDNode, this.vars, this.odd);
    }

    @Override
    public double minOverBDD(JDDNode jDDNode) {
        return this.values.minOverBDD(jDDNode, this.vars, this.odd);
    }

    @Override
    public double maxOverBDD(JDDNode jDDNode) {
        return this.values.maxOverBDD(jDDNode, this.vars, this.odd);
    }

    @Override
    public double sumOverBDD(JDDNode jDDNode) {
        return this.values.sumOverBDD(jDDNode, this.vars, this.odd);
    }

    @Override
    public double sumOverMTBDD(JDDNode jDDNode) {
        return this.values.sumOverMTBDD(jDDNode, this.vars, this.odd);
    }

    @Override
    public StateValues sumOverDDVars(JDDVars jDDVars, Model model) throws PrismException {
        DoubleVector doubleVector = this.values.sumOverDDVars(this.model.getAllDDRowVars(), this.odd, model.getODD(), jDDVars.getMinVarIndex(), jDDVars.getMaxVarIndex());
        return new StateValuesDV(doubleVector, model);
    }

    @Override
    public JDDNode getBDDFromInterval(String string, double d) {
        return this.getBDDFromInterval(RelOp.parseSymbol(string), d);
    }

    @Override
    public JDDNode getBDDFromInterval(RelOp relOp, double d) {
        return this.values.getBDDFromInterval(relOp, d, this.vars, this.odd);
    }

    @Override
    public JDDNode getBDDFromInterval(double d, double d2) {
        return this.values.getBDDFromInterval(d, d2, this.vars, this.odd);
    }

    @Override
    public JDDNode getBDDFromCloseValue(double d, double d2, boolean bl) {
        if (bl) {
            return this.values.getBDDFromCloseValueAbs(d, d2, this.vars, this.odd);
        }
        return this.values.getBDDFromCloseValueRel(d, d2, this.vars, this.odd);
    }

    @Override
    public JDDNode getBDDFromCloseValueAbs(double d, double d2) {
        return this.values.getBDDFromCloseValueAbs(d, d2, this.vars, this.odd);
    }

    @Override
    public JDDNode getBDDFromCloseValueRel(double d, double d2) {
        return this.values.getBDDFromCloseValueRel(d, d2, this.vars, this.odd);
    }

    @Override
    public void print(PrismLog prismLog) throws PrismException {
        this.print(prismLog, true, false, true, true);
    }

    @Override
    public void print(PrismLog prismLog, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        this.print(prismLog, bl, bl2, bl3, true);
    }

    @Override
    public void print(PrismLog prismLog, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PrismException {
        this.printSparse = bl;
        this.printMatlab = bl2;
        this.printStates = bl3;
        this.printIndices = bl4;
        if (bl2) {
            prismLog.println(!bl ? "v = [" : "v = sparse(" + this.values.getSize() + ",1);");
        }
        if (bl && !bl2 && this.values.getNNZ() == 0) {
            prismLog.println("(all zero)");
            return;
        }
        this.outputLog = prismLog;
        for (int i = 0; i < this.varList.getNumVars(); ++i) {
            this.varValues[i] = 0;
        }
        this.currentVar = 0;
        this.currentVarLevel = 0;
        this.printRec(0, this.odd, 0);
        if (bl2 && !bl) {
            prismLog.println("];");
        }
    }

    private void printRec(int n, ODDNode oDDNode, int n2) {
        if (n == this.numVars) {
            double d = this.values.getElement(n2);
            this.printLine(n2, d);
            return;
        }
        if (oDDNode.getEOff() > 0L) {
            ++this.currentVarLevel;
            if (this.currentVarLevel == this.varSizes[this.currentVar]) {
                ++this.currentVar;
                this.currentVarLevel = 0;
            }
            this.printRec(n + 1, oDDNode.getElse(), n2);
            --this.currentVarLevel;
            if (this.currentVarLevel == -1) {
                --this.currentVar;
                this.currentVarLevel = this.varSizes[this.currentVar] - 1;
            }
        }
        if (oDDNode.getTOff() > 0L) {
            int n3 = this.currentVar;
            this.varValues[n3] = this.varValues[n3] + (1 << this.varSizes[this.currentVar] - 1 - this.currentVarLevel);
            ++this.currentVarLevel;
            if (this.currentVarLevel == this.varSizes[this.currentVar]) {
                ++this.currentVar;
                this.currentVarLevel = 0;
            }
            this.printRec(n + 1, oDDNode.getThen(), (int)((long)n2 + oDDNode.getEOff()));
            --this.currentVarLevel;
            if (this.currentVarLevel == -1) {
                --this.currentVar;
                this.currentVarLevel = this.varSizes[this.currentVar] - 1;
            }
            int n4 = this.currentVar;
            this.varValues[n4] = this.varValues[n4] - (1 << this.varSizes[this.currentVar] - 1 - this.currentVarLevel);
        }
    }

    @Override
    public void printFiltered(PrismLog prismLog, JDDNode jDDNode) throws PrismException {
        this.printFiltered(prismLog, jDDNode, true, false, true, true);
    }

    @Override
    public void printFiltered(PrismLog prismLog, JDDNode jDDNode, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        this.printFiltered(prismLog, jDDNode, bl, bl2, bl3, true);
    }

    public void printFiltered(PrismLog prismLog, JDDNode jDDNode, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PrismException {
        this.printSparse = bl;
        this.printMatlab = bl2;
        this.printStates = bl3;
        this.printIndices = bl4;
        if (bl2) {
            prismLog.println(!bl ? "v = [" : "v = sparse(" + this.values.getSize() + ",1);");
        }
        this.counter = 0;
        this.outputLog = prismLog;
        for (int i = 0; i < this.varList.getNumVars(); ++i) {
            this.varValues[i] = 0;
        }
        this.currentVar = 0;
        this.currentVarLevel = 0;
        this.printFilteredRec(0, this.odd, 0, jDDNode);
        if (bl && !bl2 && this.counter == 0) {
            prismLog.println("(all zero)");
            return;
        }
        if (bl2 && !bl) {
            prismLog.println("];");
        }
    }

    private void printFilteredRec(int n, ODDNode oDDNode, int n2, JDDNode jDDNode) {
        JDDNode jDDNode2;
        if (jDDNode.equals(JDD.ZERO)) {
            return;
        }
        if (n == this.numVars) {
            double d = this.values.getElement(n2);
            this.printLine(n2, d);
            return;
        }
        if (oDDNode.getEOff() > 0L) {
            ++this.currentVarLevel;
            if (this.currentVarLevel == this.varSizes[this.currentVar]) {
                ++this.currentVar;
                this.currentVarLevel = 0;
            }
            JDD.Ref(jDDNode);
            JDD.Ref(this.vars.getVar(n));
            jDDNode2 = JDD.Apply(3, jDDNode, JDD.Not(this.vars.getVar(n)));
            this.printFilteredRec(n + 1, oDDNode.getElse(), n2, jDDNode2);
            JDD.Deref(jDDNode2);
            --this.currentVarLevel;
            if (this.currentVarLevel == -1) {
                --this.currentVar;
                this.currentVarLevel = this.varSizes[this.currentVar] - 1;
            }
        }
        if (oDDNode.getTOff() > 0L) {
            int n3 = this.currentVar;
            this.varValues[n3] = this.varValues[n3] + (1 << this.varSizes[this.currentVar] - 1 - this.currentVarLevel);
            ++this.currentVarLevel;
            if (this.currentVarLevel == this.varSizes[this.currentVar]) {
                ++this.currentVar;
                this.currentVarLevel = 0;
            }
            JDD.Ref(jDDNode);
            JDD.Ref(this.vars.getVar(n));
            jDDNode2 = JDD.Apply(3, jDDNode, this.vars.getVar(n));
            this.printFilteredRec(n + 1, oDDNode.getThen(), (int)((long)n2 + oDDNode.getEOff()), jDDNode2);
            JDD.Deref(jDDNode2);
            --this.currentVarLevel;
            if (this.currentVarLevel == -1) {
                --this.currentVar;
                this.currentVarLevel = this.varSizes[this.currentVar] - 1;
            }
            int n4 = this.currentVar;
            this.varValues[n4] = this.varValues[n4] - (1 << this.varSizes[this.currentVar] - 1 - this.currentVarLevel);
        }
    }

    private void printLine(int n, double d) {
        if (d > 0.0) {
            ++this.counter;
        }
        if (!this.printSparse || d != 0.0) {
            if (this.printMatlab) {
                if (this.printSparse) {
                    this.outputLog.println("v(" + (n + 1) + ")=" + d + ";");
                } else {
                    this.outputLog.println(d);
                }
            } else {
                if (this.printIndices) {
                    this.outputLog.print(n);
                }
                if (this.printStates) {
                    this.outputLog.print(":");
                    this.outputLog.print("(");
                    int n2 = this.varList.getNumVars();
                    for (int i = 0; i < n2; ++i) {
                        if (this.varList.getType(i) instanceof TypeInt) {
                            this.outputLog.print(this.varValues[i] + this.varList.getLow(i));
                        } else {
                            this.outputLog.print(this.varValues[i] == 1);
                        }
                        if (i >= n2 - 1) continue;
                        this.outputLog.print(",");
                    }
                    this.outputLog.print(")");
                }
                if (this.printIndices || this.printStates) {
                    this.outputLog.print("=");
                }
                this.outputLog.println(d);
            }
        }
    }

    @Override
    public StateValuesDV deepCopy() throws PrismException {
        DoubleVector doubleVector = new DoubleVector(this.values.getSize());
        doubleVector.add(this.values);
        return new StateValuesDV(doubleVector, this.model);
    }
}

