/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import parser.Values;
import parser.VarList;
import parser.type.TypeInt;
import prism.Model;
import prism.PrismException;
import prism.PrismLog;
import prism.StateList;

public class StateListMTBDD
implements StateList {
    JDDNode states;
    JDDVars vars;
    int numVars;
    ODDNode odd;
    VarList varList;
    double size;
    int[] varSizes;
    int[] varValues;
    int currentVar;
    int currentVarLevel;
    boolean limit;
    int numToPrint;
    int count;
    PrismLog outputLog;
    List<String> strList;
    OutputFormat outputFormat = OutputFormat.NORMAL;

    public StateListMTBDD(JDDNode jDDNode, Model model) {
        this.states = jDDNode;
        this.vars = model.getAllDDRowVars();
        this.numVars = this.vars.n();
        this.odd = model.getODD();
        this.varList = model.getVarList();
        this.size = JDD.GetNumMinterms(this.states, model.getNumDDRowVars());
        this.varSizes = new int[this.varList.getNumVars()];
        for (int i = 0; i < this.varList.getNumVars(); ++i) {
            this.varSizes[i] = this.varList.getRangeLogTwo(i);
        }
        this.varValues = new int[this.varList.getNumVars()];
    }

    public StateListMTBDD(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode, VarList varList) {
        this.states = jDDNode;
        this.vars = jDDVars;
        this.numVars = jDDVars.n();
        this.odd = oDDNode;
        this.varList = varList;
        this.size = JDD.GetNumMinterms(this.states, this.numVars);
        this.varSizes = new int[varList.getNumVars()];
        for (int i = 0; i < varList.getNumVars(); ++i) {
            this.varSizes[i] = varList.getRangeLogTwo(i);
        }
        this.varValues = new int[varList.getNumVars()];
    }

    @Override
    public int size() {
        return this.size > 2.147483647E9 ? -1 : (int)Math.round(this.size);
    }

    @Override
    public String sizeString() {
        return this.size > 9.223372036854776E18 ? "" + this.size : "" + Math.round(this.size);
    }

    @Override
    public void print(PrismLog prismLog) {
        this.outputFormat = OutputFormat.NORMAL;
        this.limit = false;
        this.outputLog = prismLog;
        this.doPrint();
        if (this.count == 0) {
            this.outputLog.println("(none)");
        }
    }

    @Override
    public void printMatlab(PrismLog prismLog) {
        this.outputFormat = OutputFormat.MATLAB;
        this.limit = false;
        this.outputLog = prismLog;
        this.doPrint();
    }

    @Override
    public void printDot(PrismLog prismLog) {
        this.outputFormat = OutputFormat.DOT;
        this.limit = false;
        this.outputLog = prismLog;
        this.doPrint();
    }

    @Override
    public List<String> exportToStringList() {
        this.strList = new ArrayList<String>((int)this.size);
        this.outputFormat = OutputFormat.STRINGS;
        this.limit = false;
        this.doPrint();
        return this.strList;
    }

    @Override
    public void print(PrismLog prismLog, int n) {
        this.outputFormat = OutputFormat.NORMAL;
        this.limit = true;
        this.numToPrint = n;
        this.outputLog = prismLog;
        this.doPrint();
        if (this.count == 0) {
            this.outputLog.println("(none)");
        }
    }

    @Override
    public void printMatlab(PrismLog prismLog, int n) {
        this.outputFormat = OutputFormat.MATLAB;
        this.limit = true;
        this.numToPrint = n;
        this.outputLog = prismLog;
        this.doPrint();
    }

    public void doPrint() {
        this.count = 0;
        for (int i = 0; i < this.varList.getNumVars(); ++i) {
            this.varValues[i] = 0;
        }
        this.currentVar = 0;
        this.currentVarLevel = 0;
        this.printRec(this.states, 0, this.odd, 0L);
    }

    private void printRec(JDDNode jDDNode, int n, ODDNode oDDNode, long l) {
        JDDNode jDDNode2;
        JDDNode jDDNode3;
        if (this.limit && this.count >= this.numToPrint) {
            return;
        }
        if (jDDNode.equals(JDD.ZERO)) {
            return;
        }
        if (n == this.numVars) {
            switch (this.outputFormat) {
                case NORMAL: {
                    this.outputLog.print(l + ":(");
                    break;
                }
                case MATLAB: {
                    break;
                }
                case DOT: {
                    this.outputLog.print(l + " [label=\"" + l + "\\n(");
                }
            }
            int n2 = this.varList.getNumVars();
            String string = "";
            for (int i = 0; i < n2; ++i) {
                string = this.varList.getType(i) instanceof TypeInt ? string + (this.varValues[i] + this.varList.getLow(i)) : string + (this.varValues[i] == 1);
                if (i >= n2 - 1) continue;
                string = string + ",";
            }
            switch (this.outputFormat) {
                case NORMAL: {
                    this.outputLog.println(string + ")");
                    break;
                }
                case MATLAB: {
                    this.outputLog.println(string);
                    break;
                }
                case DOT: {
                    this.outputLog.println(string + ")\"];");
                    break;
                }
                case STRINGS: {
                    this.strList.add(string);
                }
            }
            ++this.count;
            return;
        }
        if (jDDNode.getIndex() > this.vars.getVarIndex(n)) {
            jDDNode2 = jDDNode3 = jDDNode;
        } else {
            jDDNode2 = jDDNode.getElse();
            jDDNode3 = jDDNode.getThen();
        }
        ++this.currentVarLevel;
        if (this.currentVarLevel == this.varSizes[this.currentVar]) {
            ++this.currentVar;
            this.currentVarLevel = 0;
        }
        this.printRec(jDDNode2, n + 1, oDDNode.getElse(), l);
        --this.currentVarLevel;
        if (this.currentVarLevel == -1) {
            --this.currentVar;
            this.currentVarLevel = this.varSizes[this.currentVar] - 1;
        }
        int n3 = this.currentVar;
        this.varValues[n3] = this.varValues[n3] + (1 << this.varSizes[this.currentVar] - 1 - this.currentVarLevel);
        ++this.currentVarLevel;
        if (this.currentVarLevel == this.varSizes[this.currentVar]) {
            ++this.currentVar;
            this.currentVarLevel = 0;
        }
        this.printRec(jDDNode3, n + 1, oDDNode.getThen(), l + oDDNode.getEOff());
        --this.currentVarLevel;
        if (this.currentVarLevel == -1) {
            --this.currentVar;
            this.currentVarLevel = this.varSizes[this.currentVar] - 1;
        }
        int n4 = this.currentVar;
        this.varValues[n4] = this.varValues[n4] - (1 << this.varSizes[this.currentVar] - 1 - this.currentVarLevel);
    }

    @Override
    public boolean includes(JDDNode jDDNode) {
        JDD.Ref(this.states);
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = JDD.And(this.states, jDDNode);
        boolean bl = !jDDNode2.equals(JDD.ZERO);
        JDD.Deref(jDDNode2);
        return bl;
    }

    public boolean includesAll(JDDNode jDDNode) {
        JDD.Ref(this.states);
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = JDD.And(this.states, jDDNode);
        boolean bl = jDDNode2.equals(jDDNode);
        JDD.Deref(jDDNode2);
        return bl;
    }

    @Override
    public Values getFirstAsValues() throws PrismException {
        if (this.size < 1.0) {
            throw new PrismException("The state list contains no states");
        }
        JDD.Ref(this.states);
        JDDNode jDDNode = JDD.RestrictToFirst(this.states, this.vars);
        JDDNode jDDNode2 = this.states;
        Values values = new Values();
        int n = this.varList.getNumVars();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            int n4 = this.varSizes[i];
            for (int j = 0; j < n4; ++j) {
                if (jDDNode2.getIndex() <= this.vars.getVarIndex(n2)) {
                    if (!jDDNode2.getElse().equals(JDD.ZERO)) {
                        jDDNode2 = jDDNode2.getElse();
                    } else {
                        jDDNode2 = jDDNode2.getThen();
                        n3 += 1 << n4 - 1 - j;
                    }
                }
                ++n2;
            }
            Constable constable = this.varList.getType(i) instanceof TypeInt ? (Constable)new Integer(n3) : (Constable)new Boolean((n3 += this.varList.getLow(i)) == 1);
            values.addValue(this.varList.getName(i), constable);
        }
        JDD.Deref(jDDNode);
        return values;
    }

    @Override
    public void clear() {
        JDD.Deref(this.states);
    }

    static enum OutputFormat {
        NORMAL,
        MATLAB,
        DOT,
        STRINGS;

    }
}

