/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.List;
import parser.Values;
import parser.ast.Property;
import prism.DefinedConstant;

public class ResultsExporter {
    private List<DefinedConstant> rangingConstants;
    private Values nonRangingConstantValues;
    private Property property;
    private ResultsExportFormat format = ResultsExportFormat.PLAIN;
    private boolean printHeader;
    private boolean printNames;
    private String separator;
    private String equals;
    private ResultsExportDestination destination = ResultsExportDestination.STRING;
    private String exportString = "";

    public ResultsExporter() {
        this.setFormat(ResultsExportFormat.PLAIN);
        this.setDestination(ResultsExportDestination.STRING);
    }

    public ResultsExporter(ResultsExportFormat resultsExportFormat, ResultsExportDestination resultsExportDestination) {
        this.setFormat(resultsExportFormat);
        this.setDestination(resultsExportDestination);
    }

    public ResultsExporter(String string, String string2) {
        this.setFormatByName(string);
        this.setDestinationByName(string2);
    }

    public void setFormat(ResultsExportFormat resultsExportFormat) {
        this.format = resultsExportFormat;
        switch (resultsExportFormat) {
            case PLAIN: {
                this.printHeader = true;
                this.printNames = false;
                this.separator = "\t";
                this.equals = "\t";
                break;
            }
            case CSV: {
                this.printHeader = true;
                this.printNames = false;
                this.separator = ", ";
                this.equals = ", ";
                break;
            }
        }
    }

    public void setFormatByName(String string) {
        this.setFormat(ResultsExportFormat.parse(string));
    }

    public void setDestination(ResultsExportDestination resultsExportDestination) {
        this.destination = resultsExportDestination;
    }

    public void setDestinationByName(String string) {
        this.setDestination(ResultsExportDestination.parse(string));
    }

    public void setRangingConstants(List<DefinedConstant> list) {
        this.rangingConstants = list;
    }

    public void setNonRangingConstantValues(Values values) {
        this.nonRangingConstantValues = values;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public String getExportString() {
        return this.exportString;
    }

    public void start() {
        this.exportString = "";
        if (this.property != null) {
            switch (this.format) {
                case PLAIN: {
                    this.exportString = this.exportString + this.property.toString() + ":\n";
                    break;
                }
                case CSV: {
                    this.exportString = this.exportString + "\"" + this.property.toString().replaceAll("\"", "\"\"") + "\"\n";
                    break;
                }
                case COMMENT: {
                    break;
                }
            }
        }
        if (this.printHeader && this.rangingConstants != null) {
            String string = "";
            for (int i = 0; i < this.rangingConstants.size(); ++i) {
                if (i > 0) {
                    string = string + this.separator;
                }
                string = string + this.rangingConstants.get(i).getName();
            }
            this.exportString = this.exportString + string + (string.length() > 0 ? this.equals : "") + "Result\n";
        }
    }

    public void exportResult(Values values, Object object) {
        switch (this.format) {
            case PLAIN: 
            case CSV: {
                String string = values.toString(this.printNames, this.separator);
                this.exportString = this.exportString + string + (string.length() > 0 ? this.equals : "") + object + "\n";
                break;
            }
            case COMMENT: {
                Values values2 = new Values(this.nonRangingConstantValues, values);
                this.exportString = this.exportString + "// RESULT";
                if (values2.getNumValues() > 0) {
                    this.exportString = this.exportString + " (" + values2.toString(true, ",") + ")";
                }
                this.exportString = this.exportString + ": " + object + "\n";
            }
        }
    }

    public void end() {
        if (this.property != null && this.format == ResultsExportFormat.COMMENT) {
            this.exportString = this.exportString + this.property.toString() + "\n";
        }
        if (this.destination == ResultsExportDestination.STRING && this.exportString.charAt(this.exportString.length() - 1) == '\n') {
            this.exportString = this.exportString.substring(0, this.exportString.length() - 1);
        }
    }

    public static enum ResultsExportDestination {
        STRING;


        public String fullName() {
            switch (this) {
                case STRING: {
                    return "string";
                }
            }
            return this.toString();
        }

        public static ResultsExportDestination parse(String string) {
            switch (string) {
                case "string": {
                    return STRING;
                }
            }
            return STRING;
        }
    }

    public static enum ResultsExportFormat {
        PLAIN,
        CSV,
        COMMENT;


        public String fullName() {
            switch (this) {
                case PLAIN: {
                    return "plain text";
                }
                case CSV: {
                    return "CSV";
                }
                case COMMENT: {
                    return "comment";
                }
            }
            return this.toString();
        }

        public static ResultsExportFormat parse(String string) {
            switch (string) {
                case "plain": {
                    return PLAIN;
                }
                case "csv": {
                    return CSV;
                }
                case "comment": {
                    return COMMENT;
                }
            }
            return PLAIN;
        }
    }
}

