/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismPrintStreamLog;
import prism.Reactions2Prism;

public class ReactionsText2Prism
extends Reactions2Prism {
    public static void main(String[] stringArray) {
        PrismPrintStreamLog prismPrintStreamLog = new PrismPrintStreamLog(System.err);
        try {
            if (stringArray.length < 1) {
                System.err.println("Usage: java -cp classes prism.ReactionsText2Prism <file> [max_amount]");
                System.exit(1);
            }
            ReactionsText2Prism reactionsText2Prism = new ReactionsText2Prism(prismPrintStreamLog);
            try {
                if (stringArray.length > 1) {
                    reactionsText2Prism.setMaxAmount(Integer.parseInt(stringArray[1]));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid max amount \"" + stringArray[1] + "\"");
            }
            reactionsText2Prism.translate(new File(stringArray[0]));
        }
        catch (PrismException prismException) {
            prismPrintStreamLog.println("Error: " + prismException.getMessage() + ".");
        }
    }

    public ReactionsText2Prism() {
    }

    public ReactionsText2Prism(PrismLog prismLog) {
        super(prismLog);
    }

    public void translate(File file) throws PrismException {
        this.extractModelFromFile(file);
        this.prismCodeHeader = "// File generated by reactions-to-PRISM conversion\n";
        this.prismCodeHeader = this.prismCodeHeader + "// Original file: " + file.getPath() + "\n\n";
        this.convertToPRISMCode(System.out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractModelFromFile(File file) throws PrismException {
        Enum enum_ = null;
        int n = 0;
        String string = null;
        String string2 = null;
        this.speciesList = new ArrayList();
        this.parameterList = new ArrayList();
        this.reactionList = new ArrayList();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = bufferedReader.readLine();
            ++n;
            while (string3 != null) {
                string3 = string3.replaceFirst(" *#.*", "");
                if ((string3 = string3.trim()).length() > 0) {
                    int n2;
                    String string4;
                    if (string3.charAt(0) == '@') {
                        string4 = string3.substring(1);
                        if (string4.equals("species")) {
                            enum_ = SectionType.SPECIES;
                        } else if (string4.equals("parameters")) {
                            enum_ = SectionType.PARAMETERS;
                        } else if (string4.equals("reactions")) {
                            enum_ = SectionType.REACTIONS;
                        } else if (string4.startsWith("rr=")) {
                            enum_ = SectionType.RR;
                            n2 = (string4 = string4.substring(3)).indexOf(32);
                            string = string4.substring(0, n2 > 0 ? n2 : string4.length());
                            string2 = n2 > 0 ? string4.substring(n2 + 1).replaceAll("\"", "") : "";
                        } else {
                            if (!string4.startsWith("r=")) throw new PrismException("@" + string4 + " section not supported");
                            enum_ = SectionType.R;
                            n2 = (string4 = string4.substring(2)).indexOf(32);
                            string = string4.substring(0, n2 > 0 ? n2 : string4.length());
                            string2 = n2 > 0 ? string4.substring(n2 + 1).replaceAll("\"", "") : "";
                        }
                    } else {
                        switch (1.$SwitchMap$prism$ReactionsText2Prism$SectionType[enum_.ordinal()]) {
                            case 1: {
                                String[] stringArray2 = string3.split("=");
                                if (stringArray2.length != 2) {
                                    throw new PrismException("invalid species definition \"" + string3 + "\"");
                                }
                                String string5 = stringArray2[0];
                                n2 = (string4 = stringArray2[1].trim()).indexOf(32);
                                String string6 = string4.substring(0, n2 > 0 ? n2 : string4.length());
                                String string7 = n2 > 0 ? string4.substring(n2 + 1).replaceAll("\"", "") : null;
                                int n3 = Integer.parseInt(string6);
                                Reactions2Prism.Species species = new Reactions2Prism.Species(string5, string7, n3);
                                this.speciesList.add(species);
                                break;
                            }
                            case 2: {
                                Reactions2Prism.Parameter parameter;
                                String[] stringArray;
                                String[] stringArray2 = string3.split("=");
                                if (stringArray2.length == 1) {
                                    stringArray = stringArray2[0];
                                    parameter = new Reactions2Prism.Parameter((String)stringArray, null);
                                } else {
                                    if (stringArray2.length != 2) throw new PrismException("invalid parameter definition \"" + string3 + "\"");
                                    stringArray = stringArray2[0];
                                    try {
                                        Double.parseDouble(stringArray2[1]);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        throw new PrismException("invalid value \"" + stringArray2[1] + "\" for parameter \"" + (String)stringArray + "\"");
                                    }
                                    parameter = new Reactions2Prism.Parameter((String)stringArray, stringArray2[1]);
                                }
                                this.parameterList.add(parameter);
                                break;
                            }
                            case 3: 
                            case 4: {
                                String[] stringArray;
                                String[] stringArray2 = string3.split("->");
                                if (stringArray2.length != 2) {
                                    throw new PrismException("invalid reaction definition \"" + string3 + "\"");
                                }
                                Reactions2Prism.Reaction reaction = new Reactions2Prism.Reaction(string, string2);
                                for (String string8 : stringArray = stringArray2[0].trim().split("\\+")) {
                                    reaction.addReactant(string8, 1);
                                }
                                for (String string8 : stringArray = stringArray2[1].trim().split("\\+")) {
                                    reaction.addProduct(string8, 1);
                                }
                                string3 = bufferedReader.readLine();
                                ++n;
                                if (string3 == null) {
                                    throw new PrismException("missing line in reaction definition");
                                }
                                string3 = string3.replaceFirst(" *#.*", "");
                                string3 = string3.trim();
                                if (enum_ == SectionType.R) {
                                    reaction.setReversible(false);
                                    reaction.setKineticLawString(string3);
                                } else {
                                    reaction.setReversible(true);
                                    stringArray2 = string3.split("-");
                                    if (stringArray2.length != 2) {
                                        throw new PrismException("invalid kinetic law \"" + string3 + "\" for reversible reaction");
                                    }
                                    reaction.setKineticLawString(stringArray2[0].trim());
                                    reaction.setKineticLawReverseString(stringArray2[1].trim());
                                }
                                this.reactionList.add(reaction);
                                break;
                            }
                        }
                    }
                }
                string3 = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of file \"" + file + "\"");
        }
        catch (PrismException prismException) {
            throw new PrismException("Error detected (" + prismException.getMessage() + ") at line " + n + " of file \"" + file + "\"");
        }
    }

    private static enum SectionType {
        SPECIES,
        PARAMETERS,
        REACTIONS,
        RR,
        R;

    }
}

