/*
 * Decompiled with CFR 0.152.
 */
package prism;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceReachDD;
import acceptance.AcceptanceType;
import automata.DA;
import automata.LTL2DA;
import dv.DoubleVector;
import hybrid.PrismHybrid;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.BitSet;
import java.util.List;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import mtbdd.PrismMTBDD;
import parser.ast.Expression;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.PropertiesFile;
import parser.ast.RelOp;
import prism.IntegerBound;
import prism.LTLModelChecker;
import prism.Model;
import prism.NonProbModelChecker;
import prism.OpRelOpBound;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismNative;
import prism.ProbModel;
import prism.SCCComputer;
import prism.StateValues;
import prism.StateValuesDV;
import prism.StateValuesMTBDD;
import sparse.PrismSparse;

public class ProbModelChecker
extends NonProbModelChecker {
    protected ProbModel model;
    protected boolean precomp;
    protected boolean prob0;
    protected boolean prob1;
    protected boolean bsccComp;

    public ProbModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        super(prism, model, propertiesFile);
        if (!(model instanceof ProbModel)) {
            throw new PrismException("Wrong model type passed to ProbModelChecker.");
        }
        this.model = (ProbModel)model;
        this.precomp = prism.getPrecomp();
        this.prob0 = prism.getProb0();
        this.prob1 = prism.getProb1();
        this.bsccComp = prism.getBSCCComp();
        PrismNative.setCompact(prism.getCompact());
        PrismNative.setLinEqMethod(prism.getLinEqMethod());
        PrismNative.setLinEqMethodParam(prism.getLinEqMethodParam());
        PrismNative.setTermCrit(prism.getTermCrit());
        PrismNative.setTermCritParam(prism.getTermCritParam());
        PrismNative.setMaxIters(prism.getMaxIters());
        PrismNative.setSBMaxMem(prism.getSBMaxMem());
        PrismNative.setNumSBLevels(prism.getNumSBLevels());
        PrismNative.setSORMaxMem(prism.getSORMaxMem());
        PrismNative.setNumSORLevels(prism.getNumSORLevels());
        PrismNative.setDoSSDetect(prism.getDoSSDetect());
        PrismNative.setExportAdv(prism.getExportAdv());
        PrismNative.setExportAdvFilename(prism.getExportAdvFilename());
    }

    public ProbModelChecker createNewModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        return new ProbModelChecker(prism, model, propertiesFile);
    }

    @Override
    public StateValues checkExpression(Expression expression) throws PrismException {
        StateValues stateValues = expression instanceof ExpressionProb ? this.checkExpressionProb((ExpressionProb)expression) : (expression instanceof ExpressionReward ? this.checkExpressionReward((ExpressionReward)expression) : (expression instanceof ExpressionSS ? this.checkExpressionSteadyState((ExpressionSS)expression) : super.checkExpression(expression)));
        if (stateValues instanceof StateValuesMTBDD) {
            stateValues.filter(this.reach);
        }
        return stateValues;
    }

    protected StateValues checkExpressionProb(ExpressionProb expressionProb) throws PrismException {
        OpRelOpBound opRelOpBound = expressionProb.getRelopBoundInfo(this.constantValues);
        if (opRelOpBound.isTriviallyTrue()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies all states");
            JDD.Ref(this.reach);
            return new StateValuesMTBDD(this.reach, this.model);
        }
        if (opRelOpBound.isTriviallyFalse()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies no states");
            return new StateValuesMTBDD(JDD.Constant(0.0), this.model);
        }
        if (opRelOpBound.getRelOp() == RelOp.MIN || opRelOpBound.getRelOp() == RelOp.MAX) {
            this.mainLog.printWarning("\"Pmin=?\" and \"Pmax=?\" operators are identical to \"P=?\" for DTMCs/CTMCs");
        }
        boolean bl = opRelOpBound.isQualitative() && this.precomp && this.prob0 && this.prob1;
        StateValues stateValues = this.checkProbPathFormula(expressionProb.getExpression(), bl);
        if (this.prism.getVerbose()) {
            this.mainLog.print("\nProbabilities (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        JDDNode jDDNode = stateValues.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        jDDNode = JDD.And(jDDNode, this.reach);
        stateValues.clear();
        return new StateValuesMTBDD(jDDNode, this.model);
    }

    protected StateValues checkExpressionReward(ExpressionReward expressionReward) throws PrismException {
        Object object;
        OpRelOpBound opRelOpBound = expressionReward.getRelopBoundInfo(this.constantValues);
        Object object2 = expressionReward.getRewardStructIndex();
        JDDNode jDDNode = this.getStateRewardsByIndexObject(object2, this.model, this.constantValues);
        JDDNode jDDNode2 = this.getTransitionRewardsByIndexObject(object2, this.model, this.constantValues);
        if (opRelOpBound.getRelOp() == RelOp.MIN || opRelOpBound.getRelOp() == RelOp.MAX) {
            this.mainLog.printWarning("\"Rmin=?\" and \"Rmax=?\" operators are identical to \"R=?\" for DTMCs/CTMCs");
        }
        StateValues stateValues = null;
        Expression expression = expressionReward.getExpression();
        if (expression instanceof ExpressionTemporal) {
            object = (ExpressionTemporal)expression;
            switch (((ExpressionTemporal)object).getOperator()) {
                case 11: {
                    if (((ExpressionTemporal)object).hasBounds()) {
                        stateValues = this.checkRewardCumul((ExpressionTemporal)object, jDDNode, jDDNode2);
                        break;
                    }
                    stateValues = this.checkRewardTotal((ExpressionTemporal)object, jDDNode, jDDNode2);
                    break;
                }
                case 12: {
                    stateValues = this.checkRewardInst((ExpressionTemporal)object, jDDNode, jDDNode2);
                    break;
                }
                case 13: {
                    stateValues = this.checkRewardReach((ExpressionTemporal)object, jDDNode, jDDNode2);
                    break;
                }
                case 14: {
                    stateValues = this.checkRewardSS((ExpressionTemporal)object, jDDNode, jDDNode2);
                }
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised operator in R operator");
        }
        if (this.prism.getVerbose()) {
            this.mainLog.print("\nRewards (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        object = stateValues.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        object = JDD.And((JDDNode)object, this.reach);
        stateValues.clear();
        return new StateValuesMTBDD((JDDNode)object, this.model);
    }

    protected StateValues checkExpressionSteadyState(ExpressionSS expressionSS) throws PrismException {
        int n;
        List<Object> list = null;
        JDDNode jDDNode = null;
        JDDNode jDDNode2 = null;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        int n2 = 0;
        OpRelOpBound opRelOpBound = expressionSS.getRelopBoundInfo(this.constantValues);
        if (opRelOpBound.isTriviallyTrue()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies all states");
            JDD.Ref(this.reach);
            return new StateValuesMTBDD(this.reach, this.model);
        }
        if (opRelOpBound.isTriviallyFalse()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies no states");
            return new StateValuesMTBDD(JDD.Constant(0.0), this.model);
        }
        try {
            JDDNode jDDNode3;
            jDDNode2 = this.checkExpressionDD(expressionSS.getExpression());
            if (this.bsccComp) {
                SCCComputer sCCComputer = this.prism.getSCCComputer(this.model);
                sCCComputer.computeBSCCs();
                list = sCCComputer.getBSCCs();
                jDDNode = sCCComputer.getNotInBSCCs();
                n2 = list.size();
            } else {
                this.mainLog.println("\nSkipping BSCC computation...");
                list = new Vector();
                JDD.Ref(this.reach);
                list.add(this.reach);
                jDDNode = JDD.Constant(0.0);
                n2 = 1;
            }
            double[] dArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                double d;
                this.mainLog.println("\nComputing steady state probabilities for BSCC " + (n + 1));
                jDDNode3 = (JDDNode)list.get(n);
                stateValues = this.computeSteadyStateProbsForBSCC(this.trans, jDDNode3);
                if (this.verbose) {
                    this.mainLog.print("\nBSCC " + (n + 1) + " steady-state probabilities: \n");
                    stateValues.print(this.mainLog);
                }
                dArray[n] = d = stateValues.sumOverBDD(jDDNode2);
                this.mainLog.print("\nBSCC " + (n + 1) + " probability: " + d + "\n");
                stateValues.clear();
            }
            if (jDDNode.equals(JDD.ZERO)) {
                this.mainLog.println("\nAll states are in BSCCs (so no reachability probabilities computed)");
                JDDNode jDDNode4 = JDD.Constant(0.0);
                for (n = 0; n < n2; ++n) {
                    jDDNode3 = (JDDNode)list.get(n);
                    JDD.Ref(jDDNode3);
                    jDDNode4 = JDD.Apply(1, jDDNode4, JDD.Apply(3, JDD.Constant(dArray[n]), jDDNode3));
                }
                stateValues2 = new StateValuesMTBDD(jDDNode4, this.model);
            } else {
                switch (this.engine) {
                    case 1: {
                        stateValues2 = new StateValuesMTBDD(JDD.Constant(0.0), this.model);
                        break;
                    }
                    case 2: {
                        stateValues2 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                        break;
                    }
                    case 3: {
                        stateValues2 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                    }
                }
                for (n = 0; n < n2; ++n) {
                    if (dArray[n] == 0.0) continue;
                    this.mainLog.println("\nComputing probabilities of reaching BSCC " + (n + 1));
                    jDDNode3 = (JDDNode)list.get(n);
                    stateValues = this.computeUntilProbs(this.trans, this.trans01, jDDNode, jDDNode3);
                    if (this.verbose) {
                        this.mainLog.print("\nBSCC " + (n + 1) + " reachability probabilities: \n");
                        stateValues.print(this.mainLog);
                    }
                    stateValues.timesConstant(dArray[n]);
                    stateValues2.add(stateValues);
                    stateValues.clear();
                }
            }
            if (this.verbose) {
                this.mainLog.print("\nS operator probabilities: \n");
                stateValues2.print(this.mainLog);
            }
        }
        catch (PrismException prismException) {
            if (jDDNode2 != null) {
                JDD.Deref(jDDNode2);
            }
            for (int i = 0; i < n2; ++i) {
                if (list.get(i) == null) continue;
                JDD.Deref((JDDNode)list.get(i));
            }
            if (jDDNode != null) {
                JDD.Deref(jDDNode);
            }
            if (stateValues2 != null) {
                stateValues2.clear();
            }
            throw prismException;
        }
        if (jDDNode2 != null) {
            JDD.Deref(jDDNode2);
        }
        for (n = 0; n < n2; ++n) {
            if (list.get(n) == null) continue;
            JDD.Deref((JDDNode)list.get(n));
        }
        if (jDDNode != null) {
            JDD.Deref(jDDNode);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues2;
        }
        JDDNode jDDNode5 = stateValues2.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        jDDNode5 = JDD.And(jDDNode5, this.reach);
        stateValues2.clear();
        return new StateValuesMTBDD(jDDNode5, this.model);
    }

    protected StateValues checkProbPathFormula(Expression expression, boolean bl) throws PrismException {
        boolean bl2 = expression.isSimplePathFormula();
        if (bl2 && this.prism.getSettings().getBoolean("prism.pathViaAutomata") && LTLModelChecker.isSupportedLTLFormula(this.model.getModelType(), expression)) {
            bl2 = false;
        }
        if (bl2) {
            return this.checkProbPathFormulaSimple(expression, bl);
        }
        return this.checkProbPathFormulaLTL(expression, bl);
    }

    protected StateValues checkProbPathFormulaSimple(Expression expression, boolean bl) throws PrismException {
        boolean bl2 = false;
        StateValues stateValues = null;
        if ((expression = Expression.convertSimplePathFormulaToCanonicalForm(expression)) instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
            bl2 = true;
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperator() == 1) {
                stateValues = this.checkProbNext(expressionTemporal);
            } else if (expressionTemporal.getOperator() == 2) {
                stateValues = expressionTemporal.hasBounds() ? this.checkProbBoundedUntil(expressionTemporal) : this.checkProbUntil(expressionTemporal, bl);
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in P operator");
        }
        if (bl2) {
            stateValues.subtractFromOne();
        }
        return stateValues;
    }

    protected StateValues checkProbPathFormulaLTL(Expression expression, boolean bl) throws PrismException {
        JDDNode jDDNode;
        Object object;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (this.model.getModelType().continuousTime()) {
                throw new PrismException("DA construction for time-bounded operators not supported for " + (Object)((Object)this.model.getModelType()) + ".");
            }
            if (expression.isSimplePathFormula()) {
                expression = Expression.convertSimplePathFormulaToCanonicalForm(expression);
            } else {
                throw new PrismException("Time-bounded operators not supported in LTL: " + expression);
            }
        }
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this.prism);
        Vector<JDDNode> vector = new Vector<JDDNode>();
        Expression expression2 = lTLModelChecker.checkMaximalStateFormulas(this, this.model, expression.deepCopy(), vector);
        this.mainLog.println("\nBuilding deterministic automaton (for " + expression2 + ")...");
        long l = System.currentTimeMillis();
        LTL2DA lTL2DA = new LTL2DA(this.prism);
        AcceptanceType[] acceptanceTypeArray = new AcceptanceType[]{AcceptanceType.RABIN, AcceptanceType.REACH, AcceptanceType.GENERIC};
        DA<BitSet, ? extends AcceptanceOmega> dA = lTL2DA.convertLTLFormulaToDA(expression2, this.constantValues, acceptanceTypeArray);
        dA.checkForCanonicalAPs(vector.size());
        this.mainLog.println(dA.getAutomataType() + " has " + dA.size() + " states, " + dA.getAcceptance().getSizeStatistics() + ".");
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Time for deterministic automaton translation: " + (double)l / 1000.0 + " seconds.");
        if (this.prism.getSettings().getExportPropAut()) {
            this.mainLog.println("Exporting DA to file \"" + this.prism.getSettings().getExportPropAutFilename() + "\"...");
            object = new PrismFileLog(this.prism.getSettings().getExportPropAutFilename());
            dA.print((PrismLog)object, this.prism.getSettings().getExportPropAutType());
            ((PrismLog)object).close();
        }
        this.mainLog.println("\nConstructing MC-" + dA.getAutomataType() + " product...");
        JDDVars jDDVars = new JDDVars();
        JDDVars jDDVars2 = new JDDVars();
        ProbModel probModel = lTLModelChecker.constructProductMC(dA, this.model, vector, jDDVars, jDDVars2);
        this.mainLog.println();
        probModel.printTransInfo(this.mainLog, this.prism.getExtraDDInfo());
        if (this.prism.getExportProductTrans()) {
            try {
                this.mainLog.println("\nExporting product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"...");
                probModel.exportToFile(1, true, new File(this.prism.getExportProductTransFilename()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"");
            }
        }
        if (this.prism.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.prism.getExportProductStatesFilename() + "\"...");
            object = new PrismFileLog(this.prism.getExportProductStatesFilename());
            probModel.exportStates(1, (PrismLog)object);
            ((PrismFileLog)object).close();
        }
        if ((object = dA.getAcceptance().toAcceptanceDD(jDDVars)) instanceof AcceptanceReachDD) {
            this.mainLog.println("\nSkipping BSCC computation since acceptance is defined via goal states...");
            jDDNode = ((AcceptanceReachDD)object).getGoalStates();
            JDD.Ref(probModel.getReach());
            jDDNode = JDD.And(jDDNode, probModel.getReach());
        } else {
            this.mainLog.println("\nFinding accepting BSCCs...");
            jDDNode = lTLModelChecker.findAcceptingBSCCs((AcceptanceOmegaDD)object, probModel);
        }
        object.clear();
        this.mainLog.println("\nComputing reachability probabilities...");
        ProbModelChecker probModelChecker = this.createNewModelChecker(this.prism, probModel, null);
        stateValues = probModelChecker.checkProbUntil(probModel.getReach(), jDDNode, bl);
        JDDNode jDDNode2 = lTLModelChecker.buildStartMask(dA, vector, jDDVars);
        JDD.Ref(this.model.getReach());
        jDDNode2 = JDD.And(this.model.getReach(), jDDNode2);
        stateValues.filter(jDDNode2);
        stateValues2 = stateValues.sumOverDDVars(jDDVars, this.model);
        stateValues.clear();
        probModel.clear();
        for (int i = 0; i < vector.size(); ++i) {
            JDD.Deref(vector.get(i));
        }
        JDD.Deref(jDDNode);
        JDD.Deref(jDDNode2);
        jDDVars.derefAll();
        jDDVars2.derefAll();
        return stateValues2;
    }

    protected StateValues checkProbNext(ExpressionTemporal expressionTemporal) throws PrismException {
        StateValues stateValues = null;
        JDDNode jDDNode = this.checkExpressionDD(expressionTemporal.getOperand2());
        stateValues = this.computeNextProbs(this.trans, jDDNode);
        JDD.Deref(jDDNode);
        return stateValues;
    }

    protected StateValues checkProbBoundedUntil(ExpressionTemporal expressionTemporal) throws PrismException {
        JDDNode jDDNode;
        StateValues stateValues = null;
        IntegerBound integerBound = IntegerBound.fromExpressionTemporal(expressionTemporal, this.constantValues, true);
        JDDNode jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand1());
        try {
            jDDNode = this.checkExpressionDD(expressionTemporal.getOperand2());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode2);
            throw prismException;
        }
        Integer n = integerBound.hasLowerBound() ? integerBound.getLowestInteger() : Integer.valueOf(0);
        Integer n2 = null;
        if (integerBound.hasUpperBound()) {
            n2 = integerBound.getHighestInteger() - n;
        }
        if (n2 == null) {
            try {
                stateValues = this.computeUntilProbs(this.trans, this.trans01, jDDNode2, jDDNode);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode2);
                JDD.Deref(jDDNode);
                throw prismException;
            }
        }
        if (n2 == 0) {
            JDD.Ref(jDDNode);
            stateValues = new StateValuesMTBDD(jDDNode, this.model);
        } else {
            try {
                stateValues = this.computeBoundedUntilProbs(this.trans, this.trans01, jDDNode2, jDDNode, n2);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode2);
                JDD.Deref(jDDNode);
                throw prismException;
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stateValues = this.computeRestrictedNext(this.trans, jDDNode2, stateValues);
            }
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode);
        return stateValues;
    }

    protected StateValues checkProbUntil(ExpressionTemporal expressionTemporal, boolean bl) throws PrismException {
        JDDNode jDDNode;
        StateValues stateValues = null;
        JDDNode jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand1());
        try {
            jDDNode = this.checkExpressionDD(expressionTemporal.getOperand2());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode2);
            throw prismException;
        }
        try {
            stateValues = this.checkProbUntil(jDDNode2, jDDNode, bl);
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode2);
            JDD.Deref(jDDNode);
            throw prismException;
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode);
        return stateValues;
    }

    protected StateValues checkProbUntil(JDDNode jDDNode, JDDNode jDDNode2, boolean bl) throws PrismException {
        StateValues stateValues = null;
        if (bl) {
            this.mainLog.print("\nProbability bound in formula is 0/1 so not computing exact probabilities...\n");
            stateValues = this.computeUntilProbsQual(this.trans01, jDDNode, jDDNode2);
        } else {
            stateValues = this.computeUntilProbs(this.trans, this.trans01, jDDNode, jDDNode2);
        }
        return stateValues;
    }

    protected StateValues checkRewardCumul(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        StateValues stateValues = null;
        if (expressionTemporal.getUpperBound() == null) {
            throw new PrismException("Cumulative reward operator without time bound (C) is only allowed for multi-objective queries");
        }
        int n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
        if (n < 0) {
            throw new PrismException("Invalid time bound " + n + " in cumulative reward formula");
        }
        if (n == 0) {
            stateValues = new StateValuesMTBDD(JDD.Constant(0.0), this.model);
        } else {
            stateValues = this.computeCumulRewards(this.trans, this.trans01, jDDNode, jDDNode2, n);
        }
        return stateValues;
    }

    protected StateValues checkRewardTotal(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        StateValues stateValues = this.computeTotalRewards(this.trans, this.trans01, jDDNode, jDDNode2);
        return stateValues;
    }

    protected StateValues checkRewardInst(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        StateValues stateValues = null;
        int n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
        if (n < 0) {
            throw new PrismException("Invalid bound " + n + " in instantaneous reward property");
        }
        stateValues = this.computeInstRewards(this.trans, jDDNode, n);
        return stateValues;
    }

    protected StateValues checkRewardReach(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        StateValues stateValues = null;
        JDDNode jDDNode3 = this.checkExpressionDD(expressionTemporal.getOperand2());
        try {
            stateValues = this.computeReachRewards(this.trans, this.trans01, jDDNode, jDDNode2, jDDNode3);
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode3);
            throw prismException;
        }
        JDD.Deref(jDDNode3);
        return stateValues;
    }

    protected StateValues checkRewardSS(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        JDDNode jDDNode3;
        JDDNode jDDNode4;
        int n;
        int n2;
        JDDNode jDDNode5;
        List<Object> list;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        JDD.Ref(this.trans);
        JDD.Ref(jDDNode2);
        JDDNode jDDNode6 = JDD.SumAbstract(JDD.Apply(3, this.trans, jDDNode2), this.allDDColVars);
        JDD.Ref(jDDNode);
        jDDNode6 = JDD.Apply(1, jDDNode6, jDDNode);
        if (this.bsccComp) {
            SCCComputer sCCComputer = this.prism.getSCCComputer(this.model);
            sCCComputer.computeBSCCs();
            list = sCCComputer.getBSCCs();
            jDDNode5 = sCCComputer.getNotInBSCCs();
            n2 = list.size();
        } else {
            this.mainLog.println("\nSkipping BSCC computation...");
            list = new Vector();
            JDD.Ref(this.reach);
            list.add(this.reach);
            jDDNode5 = JDD.Constant(0.0);
            n2 = 1;
        }
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            double d;
            this.mainLog.println("\nComputing steady state probabilities for BSCC " + (n + 1));
            jDDNode4 = (JDDNode)list.get(n);
            try {
                stateValues = this.computeSteadyStateProbsForBSCC(this.trans, jDDNode4);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode6);
                for (n = 0; n < n2; ++n) {
                    JDD.Deref((JDDNode)list.get(n));
                }
                JDD.Deref(jDDNode5);
                throw prismException;
            }
            if (this.verbose) {
                this.mainLog.print("\nBSCC " + (n + 1) + " steady-state probabilities: \n");
                stateValues.print(this.mainLog);
            }
            JDD.Ref(jDDNode4);
            JDD.Ref(jDDNode6);
            jDDNode3 = JDD.Apply(3, jDDNode4, jDDNode6);
            dArray[n] = d = stateValues.sumOverMTBDD(jDDNode3);
            this.mainLog.print("\nBSCC " + (n + 1) + " Reward: " + d + "\n");
            JDD.Deref(jDDNode3);
            stateValues.clear();
        }
        if (jDDNode5.equals(JDD.ZERO)) {
            this.mainLog.println("\nAll states are in BSCCs (so no reachability probabilities computed)");
            jDDNode3 = JDD.Constant(0.0);
            for (n = 0; n < n2; ++n) {
                jDDNode4 = (JDDNode)list.get(n);
                JDD.Ref(jDDNode4);
                jDDNode3 = JDD.Apply(1, jDDNode3, JDD.Apply(3, JDD.Constant(dArray[n]), jDDNode4));
            }
            stateValues2 = new StateValuesMTBDD(jDDNode3, this.model);
        } else {
            switch (this.engine) {
                case 1: {
                    stateValues2 = new StateValuesMTBDD(JDD.Constant(0.0), this.model);
                    break;
                }
                case 2: {
                    stateValues2 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                    break;
                }
                case 3: {
                    stateValues2 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                }
            }
            for (n = 0; n < n2; ++n) {
                if (dArray[n] == 0.0) continue;
                this.mainLog.println("\nComputing probabilities of reaching BSCC " + (n + 1));
                jDDNode4 = (JDDNode)list.get(n);
                stateValues = this.computeUntilProbs(this.trans, this.trans01, jDDNode5, jDDNode4);
                if (this.verbose) {
                    this.mainLog.print("\nBSCC " + (n + 1) + " reachability probabilities: \n");
                    stateValues.print(this.mainLog);
                }
                stateValues.timesConstant(dArray[n]);
                stateValues2.add(stateValues);
                stateValues.clear();
            }
        }
        JDD.Deref(jDDNode6);
        for (n = 0; n < n2; ++n) {
            JDD.Deref((JDDNode)list.get(n));
        }
        JDD.Deref(jDDNode5);
        return stateValues2;
    }

    public StateValues doSteadyState() throws PrismException {
        return this.doSteadyState((StateValues)null);
    }

    public StateValues doSteadyState(File file) throws PrismException {
        StateValues stateValues = this.readDistributionFromFile(file);
        return this.doSteadyState(stateValues);
    }

    public StateValues doSteadyState(StateValues stateValues) throws PrismException {
        StateValues stateValues2 = stateValues == null ? this.buildInitialDistribution() : stateValues;
        return this.computeSteadyStateProbs(this.trans, stateValues2);
    }

    public StateValues doTransient(int n) throws PrismException {
        return this.doTransient(n, (StateValues)null);
    }

    public StateValues doTransient(int n, File file) throws PrismException {
        StateValues stateValues = this.readDistributionFromFile(file);
        return this.doTransient(n, stateValues);
    }

    public StateValues doTransient(int n, StateValues stateValues) throws PrismException {
        StateValues stateValues2 = stateValues == null ? this.buildInitialDistribution() : stateValues;
        return this.computeTransientProbs(this.trans, stateValues2, n);
    }

    public StateValues readDistributionFromFile(File file) throws PrismException {
        StateValues stateValues = null;
        if (file != null) {
            this.mainLog.println("\nImporting probability distribution from file \"" + file + "\"...");
            stateValues = this.engine == 1 ? new StateValuesMTBDD(JDD.Constant(0.0), this.model) : new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
            stateValues.readFromFile(file);
        }
        return stateValues;
    }

    private StateValues buildInitialDistribution() {
        StateValues stateValues = null;
        this.start = this.model.getStart();
        JDD.Ref(this.start);
        JDDNode jDDNode = JDD.Apply(4, this.start, JDD.Constant(JDD.GetNumMinterms(this.start, this.allDDRowVars.n())));
        if (this.engine == 1) {
            stateValues = new StateValuesMTBDD(jDDNode, this.model);
        } else {
            stateValues = new StateValuesDV(jDDNode, (Model)this.model);
            JDD.Deref(jDDNode);
        }
        return stateValues;
    }

    protected StateValues computeNextProbs(JDDNode jDDNode, JDDNode jDDNode2) {
        StateValuesMTBDD stateValuesMTBDD = null;
        JDD.Ref(jDDNode2);
        JDDNode jDDNode3 = JDD.PermuteVariables(jDDNode2, this.allDDRowVars, this.allDDColVars);
        JDD.Ref(jDDNode);
        jDDNode3 = JDD.MatrixMultiply(jDDNode, jDDNode3, this.allDDColVars, 2);
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode3, this.model);
        return stateValuesMTBDD;
    }

    protected StateValues computeRestrictedNext(JDDNode jDDNode, JDDNode jDDNode2, StateValues stateValues) {
        StateValuesMTBDD stateValuesMTBDD = null;
        StateValuesMTBDD stateValuesMTBDD2 = stateValues.convertToStateValuesMTBDD();
        JDDNode jDDNode3 = stateValuesMTBDD2.getJDDNode();
        JDD.Ref(jDDNode3);
        jDDNode3 = JDD.PermuteVariables(jDDNode3, this.allDDRowVars, this.allDDColVars);
        JDD.Ref(jDDNode);
        jDDNode3 = JDD.MatrixMultiply(jDDNode, jDDNode3, this.allDDColVars, 2);
        JDD.Ref(jDDNode2);
        jDDNode3 = JDD.Apply(5, jDDNode3, jDDNode2);
        stateValuesMTBDD2.clear();
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode3, this.model);
        return stateValuesMTBDD;
    }

    protected StateValues computeBoundedUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, int n) throws PrismException {
        JDDNode jDDNode5;
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        StateValues stateValues = null;
        if (jDDNode4.equals(JDD.ZERO)) {
            jDDNode7 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode6 = this.reach;
            jDDNode5 = JDD.Constant(0.0);
        } else if (jDDNode3.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode4);
            jDDNode7 = jDDNode4;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode4);
            jDDNode6 = JDD.And(this.reach, JDD.Not(jDDNode4));
            jDDNode5 = JDD.Constant(0.0);
        } else {
            JDD.Ref(jDDNode4);
            jDDNode7 = jDDNode4;
            if (jDDNode7.equals(this.reach)) {
                jDDNode6 = JDD.Constant(0.0);
            } else if (this.precomp && this.prob0) {
                jDDNode6 = PrismMTBDD.Prob0(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, jDDNode3, jDDNode7);
            } else {
                JDD.Ref(this.reach);
                JDD.Ref(jDDNode3);
                JDD.Ref(jDDNode4);
                jDDNode6 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode3, jDDNode4)));
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode7);
            JDD.Ref(jDDNode6);
            jDDNode5 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode7, jDDNode6)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()) + "\n");
        if (jDDNode5.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode7);
            stateValues = new StateValuesMTBDD(jDDNode7, this.model);
        } else {
            this.mainLog.println("\nComputing probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode8 = PrismMTBDD.ProbBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5, n);
                        stateValues = new StateValuesMTBDD(jDDNode8, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = PrismSparse.ProbBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5, n);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = PrismHybrid.ProbBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5, n);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode7);
                JDD.Deref(jDDNode6);
                JDD.Deref(jDDNode5);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode5);
        return stateValues;
    }

    protected StateValues computeUntilProbsQual(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) {
        JDDNode jDDNode4;
        JDDNode jDDNode5;
        JDDNode jDDNode6;
        StateValuesMTBDD stateValuesMTBDD = null;
        if (jDDNode3.equals(JDD.ZERO)) {
            jDDNode6 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode5 = this.reach;
            jDDNode4 = JDD.Constant(0.0);
        } else if (jDDNode2.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode3);
            jDDNode6 = jDDNode3;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode3);
            jDDNode5 = JDD.And(this.reach, JDD.Not(jDDNode3));
            jDDNode4 = JDD.Constant(0.0);
        } else {
            jDDNode5 = PrismMTBDD.Prob0(jDDNode, this.reach, this.allDDRowVars, this.allDDColVars, jDDNode2, jDDNode3);
            jDDNode6 = PrismMTBDD.Prob1(jDDNode, this.reach, this.allDDRowVars, this.allDDColVars, jDDNode2, jDDNode3, jDDNode5);
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode6);
            JDD.Ref(jDDNode5);
            jDDNode4 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode6, jDDNode5)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode4, this.allDDRowVars.n()) + "\n");
        if (jDDNode4.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode6);
            stateValuesMTBDD = new StateValuesMTBDD(jDDNode6, this.model);
        } else {
            JDD.Ref(jDDNode6);
            JDD.Ref(jDDNode4);
            stateValuesMTBDD = new StateValuesMTBDD(JDD.Apply(1, jDDNode6, JDD.Apply(3, jDDNode4, JDD.Constant(0.5))), this.model);
        }
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode4);
        return stateValuesMTBDD;
    }

    protected StateValues computeUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4) throws PrismException {
        JDDNode jDDNode5;
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        StateValues stateValues = null;
        if (this.prism.getExportTarget()) {
            JDDNode[] jDDNodeArray = new JDDNode[]{this.model.getStart(), jDDNode4};
            String[] stringArray = new String[]{"init", "target"};
            try {
                this.mainLog.println("\nExporting target states info to file \"" + this.prism.getExportTargetFilename() + "\"...");
                PrismMTBDD.ExportLabels(jDDNodeArray, stringArray, "l", this.model.getAllDDRowVars(), this.model.getODD(), 1, this.prism.getExportTargetFilename());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export target to file \"" + this.prism.getExportTargetFilename() + "\"");
            }
        }
        if (jDDNode4.equals(JDD.ZERO)) {
            jDDNode7 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode6 = this.reach;
            jDDNode5 = JDD.Constant(0.0);
        } else if (jDDNode3.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode4);
            jDDNode7 = jDDNode4;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode4);
            jDDNode6 = JDD.And(this.reach, JDD.Not(jDDNode4));
            jDDNode5 = JDD.Constant(0.0);
        } else {
            if (this.precomp && (this.prob0 || this.prob1)) {
                jDDNode6 = PrismMTBDD.Prob0(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, jDDNode3, jDDNode4);
            } else {
                JDD.Ref(this.reach);
                JDD.Ref(jDDNode3);
                JDD.Ref(jDDNode4);
                jDDNode6 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode3, jDDNode4)));
            }
            if (this.precomp && this.prob1) {
                jDDNode7 = PrismMTBDD.Prob1(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, jDDNode3, jDDNode4, jDDNode6);
            } else {
                JDD.Ref(jDDNode4);
                jDDNode7 = jDDNode4;
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode7);
            JDD.Ref(jDDNode6);
            jDDNode5 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode7, jDDNode6)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()) + "\n");
        if (jDDNode5.equals(JDD.ZERO)) {
            switch (this.engine) {
                case 1: {
                    JDD.Ref(jDDNode7);
                    stateValues = new StateValuesMTBDD(jDDNode7, this.model);
                    break;
                }
                case 2: 
                case 3: {
                    stateValues = new StateValuesDV(jDDNode7, (Model)this.model);
                }
            }
        } else {
            this.mainLog.println("\nComputing remaining probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode8 = PrismMTBDD.ProbUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5);
                        stateValues = new StateValuesMTBDD(jDDNode8, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = PrismSparse.ProbUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = PrismHybrid.ProbUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode7);
                JDD.Deref(jDDNode6);
                JDD.Deref(jDDNode5);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode5);
        return stateValues;
    }

    protected StateValues computeCumulRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, int n) throws PrismException {
        StateValues stateValues = null;
        this.mainLog.println("\nComputing rewards...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        switch (this.engine) {
            case 1: {
                JDDNode jDDNode5 = PrismMTBDD.ProbCumulReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, n);
                stateValues = new StateValuesMTBDD(jDDNode5, this.model);
                break;
            }
            case 2: {
                DoubleVector doubleVector = PrismSparse.ProbCumulReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, n);
                stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            case 3: {
                DoubleVector doubleVector = PrismHybrid.ProbCumulReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, n);
                stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            default: {
                throw new PrismException("Unknown engine");
            }
        }
        return stateValues;
    }

    protected StateValues computeTotalRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4) throws PrismException {
        StateValues stateValues = null;
        List<JDDNode> list = null;
        JDDNode jDDNode5 = null;
        int n = 0;
        SCCComputer sCCComputer = this.prism.getSCCComputer(this.model);
        sCCComputer.computeBSCCs();
        list = sCCComputer.getBSCCs();
        jDDNode5 = sCCComputer.getNotInBSCCs();
        n = list.size();
        JDD.Ref(jDDNode3);
        JDDNode jDDNode6 = JDD.GreaterThan(jDDNode3, 0.0);
        JDD.Ref(jDDNode4);
        JDDNode jDDNode7 = JDD.GreaterThan(jDDNode4, 0.0);
        JDDNode jDDNode8 = JDD.Constant(0.0);
        for (int i = 0; i < n; ++i) {
            if (!JDD.AreIntersecting(list.get(i), jDDNode6) && !JDD.AreIntersecting(list.get(i), jDDNode7)) continue;
            JDD.Ref(list.get(i));
            jDDNode8 = JDD.Or(jDDNode8, list.get(i));
        }
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode7);
        this.mainLog.print("States in non-zero reward BSCCs: " + JDD.GetNumMintermsString(jDDNode8, this.allDDRowVars.n()));
        JDDNode jDDNode9 = PrismMTBDD.Prob0(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, this.reach, jDDNode8);
        jDDNode9 = JDD.And(this.reach, JDD.Not(jDDNode9));
        JDDNode jDDNode10 = JDD.And(this.reach, JDD.Not(jDDNode9));
        JDD.Ref(jDDNode8);
        this.mainLog.print("\ninf = " + JDD.GetNumMintermsString(jDDNode9, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode10, this.allDDRowVars.n()) + "\n");
        if (jDDNode10.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode9);
            stateValues = new StateValuesMTBDD(JDD.ITE(jDDNode9, JDD.PlusInfinity(), JDD.Constant(0.0)), this.model);
        } else {
            this.mainLog.println("\nComputing remaining rewards...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode11 = PrismMTBDD.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, JDD.ZERO, jDDNode9, jDDNode10);
                        stateValues = new StateValuesMTBDD(jDDNode11, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = PrismSparse.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, JDD.ZERO, jDDNode9, jDDNode10);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = PrismHybrid.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, JDD.ZERO, jDDNode9, jDDNode10);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode9);
                JDD.Deref(jDDNode10);
                throw prismException;
            }
        }
        for (int i = 0; i < n; ++i) {
            if (list.get(i) == null) continue;
            JDD.Deref(list.get(i));
        }
        if (this.start != jDDNode5) {
            JDD.Deref(jDDNode5);
        }
        JDD.Deref(jDDNode9);
        JDD.Deref(jDDNode10);
        return stateValues;
    }

    protected StateValues computeInstRewards(JDDNode jDDNode, JDDNode jDDNode2, int n) throws PrismException {
        StateValues stateValues = null;
        if (n == 0) {
            JDD.Ref(jDDNode2);
            stateValues = new StateValuesMTBDD(jDDNode2, this.model);
        } else {
            this.mainLog.println("\nComputing rewards...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            switch (this.engine) {
                case 1: {
                    JDDNode jDDNode3 = PrismMTBDD.ProbInstReward(jDDNode, jDDNode2, this.odd, this.allDDRowVars, this.allDDColVars, n);
                    stateValues = new StateValuesMTBDD(jDDNode3, this.model);
                    break;
                }
                case 2: {
                    DoubleVector doubleVector = PrismSparse.ProbInstReward(jDDNode, jDDNode2, this.odd, this.allDDRowVars, this.allDDColVars, n);
                    stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                    break;
                }
                case 3: {
                    DoubleVector doubleVector = PrismHybrid.ProbInstReward(jDDNode, jDDNode2, this.odd, this.allDDRowVars, this.allDDColVars, n);
                    stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                    break;
                }
                default: {
                    throw new PrismException("Unknown engine");
                }
            }
        }
        return stateValues;
    }

    protected StateValues computeReachRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5) throws PrismException {
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        StateValues stateValues = null;
        if (jDDNode5.equals(JDD.ZERO)) {
            JDD.Ref(this.reach);
            jDDNode7 = this.reach;
            jDDNode6 = JDD.Constant(0.0);
        } else if (jDDNode5.equals(this.reach)) {
            jDDNode7 = JDD.Constant(0.0);
            jDDNode6 = JDD.Constant(0.0);
        } else {
            JDDNode jDDNode8 = PrismMTBDD.Prob0(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, this.reach, jDDNode5);
            JDDNode jDDNode9 = PrismMTBDD.Prob1(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, this.reach, jDDNode5, jDDNode8);
            JDD.Deref(jDDNode8);
            JDD.Ref(this.reach);
            jDDNode7 = JDD.And(this.reach, JDD.Not(jDDNode9));
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode7);
            JDD.Ref(jDDNode5);
            jDDNode6 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode7, jDDNode5)));
        }
        this.mainLog.print("\ngoal = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()));
        this.mainLog.print(", inf = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()) + "\n");
        if (jDDNode6.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode7);
            stateValues = new StateValuesMTBDD(JDD.ITE(jDDNode7, JDD.PlusInfinity(), JDD.Constant(0.0)), this.model);
        } else {
            this.mainLog.println("\nComputing remaining rewards...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode10 = PrismMTBDD.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode5, jDDNode7, jDDNode6);
                        stateValues = new StateValuesMTBDD(jDDNode10, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = PrismSparse.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode5, jDDNode7, jDDNode6);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = PrismHybrid.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode5, jDDNode7, jDDNode6);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode7);
                JDD.Deref(jDDNode6);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode6);
        return stateValues;
    }

    public StateValues computeSteadyStateProbs(JDDNode jDDNode, StateValues stateValues) throws PrismException {
        int n;
        List<Object> list = null;
        JDDNode jDDNode2 = null;
        JDDNode jDDNode3 = null;
        StateValues stateValues2 = null;
        StateValues stateValues3 = null;
        int n2 = 0;
        int n3 = -1;
        try {
            JDDNode jDDNode4;
            if (this.bsccComp) {
                SCCComputer sCCComputer = this.prism.getSCCComputer(this.model);
                sCCComputer.computeBSCCs();
                list = sCCComputer.getBSCCs();
                jDDNode2 = sCCComputer.getNotInBSCCs();
                n2 = list.size();
            } else {
                this.mainLog.println("\nSkipping BSCC computation...");
                list = new Vector();
                JDD.Ref(this.reach);
                list.add(this.reach);
                jDDNode2 = JDD.Constant(0.0);
                n2 = 1;
            }
            jDDNode3 = stateValues.getBDDFromInterval(">", 0.0);
            n3 = -1;
            for (n = 0; n < n2; ++n) {
                if (!JDD.IsContainedIn(jDDNode3, (JDDNode)list.get(n))) continue;
                n3 = n;
                break;
            }
            if (n3 != -1) {
                this.mainLog.println("\nInitial states all in one BSCC (so no reachability probabilities computed)");
                jDDNode4 = (JDDNode)list.get(n3);
                stateValues3 = this.computeSteadyStateProbsForBSCC(this.trans, jDDNode4);
            } else {
                switch (this.engine) {
                    case 1: {
                        stateValues3 = new StateValuesMTBDD(JDD.Constant(0.0), this.model);
                        break;
                    }
                    case 2: {
                        stateValues3 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                        break;
                    }
                    case 3: {
                        stateValues3 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                    }
                }
                double[] dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    this.mainLog.println("\nComputing probability of reaching BSCC " + (n + 1));
                    jDDNode4 = (JDDNode)list.get(n);
                    stateValues2 = this.computeUntilProbs(this.trans, this.trans01, jDDNode2, jDDNode4);
                    dArray[n] = stateValues2.dotProduct(stateValues);
                    this.mainLog.print("\nProbability of reaching BSCC " + (n + 1) + ": " + dArray[n] + "\n");
                    stateValues2.clear();
                }
                for (n = 0; n < n2; ++n) {
                    this.mainLog.println("\nComputing steady-state probabilities for BSCC " + (n + 1));
                    jDDNode4 = (JDDNode)list.get(n);
                    stateValues2 = this.computeSteadyStateProbsForBSCC(this.trans, jDDNode4);
                    if (this.verbose) {
                        this.mainLog.print("\nBSCC " + (n + 1) + " Steady-State Probabilities: \n");
                        stateValues2.print(this.mainLog);
                    }
                    stateValues2.timesConstant(dArray[n]);
                    stateValues3.add(stateValues2);
                    stateValues2.clear();
                }
            }
        }
        catch (PrismException prismException) {
            if (jDDNode3 != null) {
                JDD.Deref(jDDNode3);
            }
            for (int i = 0; i < n2; ++i) {
                if (list.get(i) == null) continue;
                JDD.Deref((JDDNode)list.get(i));
            }
            if (jDDNode3 != jDDNode2) {
                JDD.Deref(jDDNode2);
            }
            if (stateValues3 != null) {
                stateValues3.clear();
            }
            throw prismException;
        }
        if (jDDNode3 != null) {
            JDD.Deref(jDDNode3);
        }
        for (n = 0; n < n2; ++n) {
            if (list.get(n) == null) continue;
            JDD.Deref((JDDNode)list.get(n));
        }
        if (jDDNode3 != jDDNode2) {
            JDD.Deref(jDDNode2);
        }
        return stateValues3;
    }

    protected StateValues computeSteadyStateProbsForBSCC(JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        StateValues stateValues = null;
        long l = jDDNode2.equals(this.reach) ? this.model.getNumStates() : Math.round(JDD.GetNumMinterms(jDDNode2, this.allDDRowVars.n()));
        if (l == 1L) {
            switch (this.engine) {
                case 1: {
                    JDD.Ref(jDDNode2);
                    return new StateValuesMTBDD(jDDNode2, this.model);
                }
                case 2: {
                    return new StateValuesDV(jDDNode2, (Model)this.model);
                }
                case 3: {
                    return new StateValuesDV(jDDNode2, (Model)this.model);
                }
            }
        }
        JDD.Ref(jDDNode);
        JDD.Ref(jDDNode2);
        JDDNode jDDNode3 = JDD.Apply(3, jDDNode, jDDNode2);
        JDD.Ref(jDDNode2);
        jDDNode3 = JDD.Apply(3, jDDNode3, JDD.PermuteVariables(jDDNode2, this.allDDRowVars, this.allDDColVars));
        JDD.Ref(jDDNode2);
        JDDNode jDDNode4 = JDD.Apply(4, jDDNode2, JDD.Constant(l));
        this.mainLog.println("\nComputing probabilities...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        try {
            switch (this.engine) {
                case 1: {
                    JDDNode jDDNode5 = PrismMTBDD.StochSteadyState(jDDNode3, this.odd, jDDNode4, this.allDDRowVars, this.allDDColVars);
                    stateValues = new StateValuesMTBDD(jDDNode5, this.model);
                    break;
                }
                case 2: {
                    DoubleVector doubleVector = PrismSparse.StochSteadyState(jDDNode3, this.odd, jDDNode4, this.allDDRowVars, this.allDDColVars);
                    stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                    break;
                }
                case 3: {
                    DoubleVector doubleVector = PrismHybrid.StochSteadyState(jDDNode3, this.odd, jDDNode4, this.allDDRowVars, this.allDDColVars);
                    stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                    break;
                }
                default: {
                    throw new PrismException("Unknown engine");
                }
            }
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode3);
            JDD.Deref(jDDNode4);
            throw prismException;
        }
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode4);
        return stateValues;
    }

    protected StateValues computeTransientProbs(JDDNode jDDNode, StateValues stateValues, int n) throws PrismException {
        StateValues stateValues2 = null;
        if (n == 0) {
            return stateValues;
        }
        this.mainLog.println("\nComputing probabilities...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        switch (this.engine) {
            case 1: {
                JDDNode jDDNode2 = PrismMTBDD.ProbTransient(jDDNode, this.odd, ((StateValuesMTBDD)stateValues).getJDDNode(), this.allDDRowVars, this.allDDColVars, n);
                stateValues2 = new StateValuesMTBDD(jDDNode2, this.model);
                break;
            }
            case 2: {
                DoubleVector doubleVector = PrismSparse.ProbTransient(jDDNode, this.odd, ((StateValuesDV)stateValues).getDoubleVector(), this.allDDRowVars, this.allDDColVars, n);
                stateValues2 = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            case 3: {
                DoubleVector doubleVector = PrismHybrid.ProbTransient(jDDNode, this.odd, ((StateValuesDV)stateValues).getDoubleVector(), this.allDDRowVars, this.allDDColVars, n);
                stateValues2 = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            default: {
                throw new PrismException("Unknown engine");
            }
        }
        return stateValues2;
    }
}

