/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import prism.PrismException;

public class PrismUtils {
    public static double epsilonDouble = 1.0E-12;
    private static DecimalFormat formatterPercent1dp = new DecimalFormat("#0.0%", DecimalFormatSymbols.getInstance(Locale.UK));
    private static DecimalFormat formatterDouble2dp = new DecimalFormat("#0.00", DecimalFormatSymbols.getInstance(Locale.UK));

    public static double log(double d, double d2) {
        if (d2 <= 0.0 || d2 == 1.0 || Double.isInfinite(d2) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return Math.log(d) / Math.log(d2);
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static boolean doublesAreCloseAbs(double d, double d2, double d3) {
        if (Double.isInfinite(d)) {
            return Double.isInfinite(d2) && d > 0.0 == d2 > 0.0;
        }
        if (Double.isInfinite(d2)) {
            return false;
        }
        return Math.abs(d - d2) < d3;
    }

    public static boolean doublesAreCloseRel(double d, double d2, double d3) {
        if (Double.isInfinite(d)) {
            return Double.isInfinite(d2) && d > 0.0 == d2 > 0.0;
        }
        if (Double.isInfinite(d2)) {
            return false;
        }
        d = Math.abs(d);
        d2 = Math.abs(d2);
        if (d < epsilonDouble) {
            return d2 < epsilonDouble;
        }
        return Math.abs(d - d2) / d < d3;
    }

    public static boolean doublesAreClose(double d, double d2, double d3, boolean bl) {
        if (bl) {
            return PrismUtils.doublesAreCloseAbs(d, d2, d3);
        }
        return PrismUtils.doublesAreCloseRel(d, d2, d3);
    }

    public static boolean doublesAreClose(double[] dArray, double[] dArray2, double d, boolean bl) {
        int n = Math.min(dArray.length, dArray2.length);
        if (bl) {
            for (int i = 0; i < n; ++i) {
                if (PrismUtils.doublesAreCloseAbs(dArray[i], dArray2[i], d)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (PrismUtils.doublesAreCloseRel(dArray[i], dArray2[i], d)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean doublesAreEqual(double d, double d2) {
        return PrismUtils.doublesAreCloseAbs(d, d2, epsilonDouble);
    }

    public static String bigIntToString(double d) {
        if (d <= 9.223372036854776E18) {
            return "" + Math.round(d);
        }
        return "" + d;
    }

    public static String addCounterSuffixToFilename(String string, int n) {
        return PrismUtils.addSuffixToFilename(string, "" + n);
    }

    public static String addSuffixToFilename(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(0, n) + string2 + string.substring(n);
        }
        return string + string2;
    }

    public static String formatPercent1dp(double d) {
        return formatterPercent1dp.format(d);
    }

    public static String formatDouble2dp(double d) {
        return formatterDouble2dp.format(d);
    }

    public static String formatDouble(double d) {
        return String.format(Locale.UK, "%.12g", d).replaceFirst("\\.?0+(e|$)", "$1");
    }

    public static String formatDouble(int n, double d) {
        return String.format(Locale.UK, "%." + n + "g", d).replaceFirst("\\.?0+(e|$)", "$1");
    }

    public static String joinString(List<?> list, String string) {
        String string2 = "";
        boolean bl = true;
        for (Object obj : list) {
            if (bl) {
                bl = false;
            } else {
                string2 = string2 + string;
            }
            string2 = string2 + obj.toString();
        }
        return string2;
    }

    public static String joinString(Object[] objectArray, String string) {
        String string2 = "";
        boolean bl = true;
        for (Object object : objectArray) {
            if (bl) {
                bl = false;
            } else {
                string2 = string2 + string;
            }
            string2 = string2 + object.toString();
        }
        return string2;
    }

    public static int findCycle(boolean[][] blArray) {
        int n = blArray.length;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                if (!blArray[n3][n3]) continue;
                n2 = n3;
                break;
            }
            if (n2 != -1) break;
            for (n3 = 0; n3 < n; ++n3) {
                for (int j = 0; j < n; ++j) {
                    if (!blArray[n3][j]) continue;
                    for (int k = 0; k < n; ++k) {
                        boolean[] blArray2 = blArray[n3];
                        int n4 = k;
                        blArray2[n4] = blArray2[n4] | blArray[j][k];
                    }
                }
            }
        }
        return n2;
    }

    public static long convertMemoryStringtoKB(String string) throws PrismException {
        long l;
        Pattern pattern = Pattern.compile("([0-9]+)([kmg]?)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new PrismException("Invalid amount of memory \"" + string + "\"");
        }
        try {
            l = Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Invalid amount of memory \"" + string + "\"");
        }
        switch (matcher.group(2)) {
            case "": 
            case "k": {
                return l;
            }
            case "m": {
                return l * 1024L;
            }
            case "g": {
                return l * 0x100000L;
            }
        }
        throw new PrismException("Invalid amount of memory \"" + string + "\"");
    }

    public static String convertBytesToMemoryString(long l) throws PrismException {
        String[] stringArray = new String[]{"b", "k", "m", "g"};
        for (int i = 3; i > 0; --i) {
            long l2 = 1 << i * 10;
            if (l < l2) continue;
            return (l % l2 == 0L ? Long.valueOf(l / l2) : String.format(Locale.UK, "%.1f", (double)l / (double)l2)) + stringArray[i];
        }
        return l + stringArray[0];
    }
}

