/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import prism.OpRelOpBound;
import prism.Operator;

public class OpsAndBoundsList {
    private BitSet probNegated = new BitSet();
    protected List<OpRelOpBound> opInfos;
    protected List<Operator> relOps;
    protected List<Operator> relOpsProb;
    protected List<Operator> relOpsReward;
    protected List<Double> bounds;
    protected List<Double> boundsProb;
    protected List<Double> boundsReward;
    protected List<Integer> stepBounds;
    protected List<Integer> stepBoundsProb;
    protected List<Integer> stepBoundsReward;

    public OpsAndBoundsList() {
        this(1);
    }

    public OpsAndBoundsList(int n) {
        this.opInfos = new ArrayList<OpRelOpBound>(n);
        this.relOps = new ArrayList<Operator>(n);
        this.bounds = new ArrayList<Double>(n);
        this.stepBounds = new ArrayList<Integer>(n);
        this.relOpsProb = new ArrayList<Operator>();
        this.boundsProb = new ArrayList<Double>();
        this.stepBoundsProb = new ArrayList<Integer>(n);
        this.relOpsReward = new ArrayList<Operator>();
        this.boundsReward = new ArrayList<Double>();
        this.stepBoundsReward = new ArrayList<Integer>(n);
    }

    public void add(OpRelOpBound opRelOpBound, Operator operator, double d, int n) {
        this.opInfos.add(opRelOpBound);
        this.relOps.add(operator);
        this.bounds.add(d);
        this.stepBounds.add(n);
        switch (operator) {
            case P_MAX: 
            case P_MIN: 
            case P_GE: 
            case P_LE: {
                this.relOpsProb.add(operator);
                this.boundsProb.add(d);
                this.stepBoundsProb.add(n);
                break;
            }
            case R_MAX: 
            case R_MIN: 
            case R_GE: 
            case R_LE: {
                this.relOpsReward.add(operator);
                this.boundsReward.add(d);
                this.stepBoundsReward.add(n);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Don't know how to add operator " + (Object)((Object)operator) + ", the handling code does not exist.");
            }
        }
    }

    public Operator getOperator(int n) {
        return this.relOps.get(n);
    }

    public double getBound(int n) {
        return this.bounds.get(n);
    }

    public int getStepBound(int n) {
        return this.stepBounds.get(n);
    }

    public OpRelOpBound getOpRelOpBound(int n) {
        return this.opInfos.get(n);
    }

    public Operator getProbOperator(int n) {
        return this.relOpsProb.get(n);
    }

    public double getProbBound(int n) {
        return this.boundsProb.get(n);
    }

    public int getProbStepBound(int n) {
        return this.stepBoundsProb.get(n);
    }

    public Operator getRewardOperator(int n) {
        return this.relOpsReward.get(n);
    }

    public double getRewardBound(int n) {
        return this.boundsReward.get(n);
    }

    public int getRewardStepBound(int n) {
        return this.stepBoundsReward.get(n);
    }

    public boolean isProbabilityObjective(int n) {
        switch (this.relOps.get(n)) {
            case P_MAX: 
            case P_MIN: 
            case P_GE: 
            case P_LE: {
                return true;
            }
        }
        return false;
    }

    public boolean isProbNegated(int n) {
        return this.probNegated.get(n);
    }

    public void makeAllProbUp() {
        for (int i = 0; i < this.relOpsProb.size(); ++i) {
            if (this.relOpsProb.get(i) == Operator.P_MIN) {
                this.relOpsProb.remove(i);
                this.relOpsProb.add(i, Operator.P_MAX);
                this.probNegated.set(i);
                continue;
            }
            if (this.relOpsProb.get(i) != Operator.P_LE) continue;
            this.relOpsProb.remove(i);
            this.relOpsProb.add(i, Operator.P_GE);
            this.probNegated.set(i);
        }
    }

    public int rewardSize() {
        return this.relOpsReward.size();
    }

    public int probSize() {
        return this.relOpsProb.size();
    }

    public boolean contains(Operator operator) {
        return this.relOps.contains((Object)operator);
    }

    public int numberOfNumerical() {
        int n = 0;
        for (OpRelOpBound opRelOpBound : this.opInfos) {
            if (!opRelOpBound.isNumeric()) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.opInfos.size(); ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + this.opInfos.get(i);
            string = string + this.stepBounds.get(i);
        }
        return string;
    }
}

