/*
 * Decompiled with CFR 0.152.
 */
package prism;

import explicit.MinMax;
import parser.ast.RelOp;
import prism.ModelType;
import prism.PrismException;

public class OpRelOpBound {
    protected String op;
    protected RelOp relOp;
    protected boolean numeric;
    protected double bound;

    public OpRelOpBound(String string, RelOp relOp, Double d) {
        this.op = string;
        this.relOp = relOp;
        boolean bl = this.numeric = d == null;
        if (d != null) {
            this.bound = d;
        }
    }

    public boolean isProbabilistic() {
        return "P".equals(this.op);
    }

    public boolean isReward() {
        return "R".equals(this.op);
    }

    public RelOp getRelOp() {
        return this.relOp;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public double getBound() {
        return this.bound;
    }

    public boolean isQualitative() {
        return !this.isNumeric() && this.op.equals("P") && (this.bound == 0.0 || this.bound == 1.0);
    }

    public boolean isTriviallyTrue() {
        if (!this.isNumeric() && this.op.equals("P")) {
            if (this.bound == 0.0 && this.relOp == RelOp.GEQ) {
                return true;
            }
            if (this.bound == 1.0 && this.relOp == RelOp.LEQ) {
                return true;
            }
        }
        return false;
    }

    public boolean isTriviallyFalse() {
        if (!this.isNumeric() && this.op.equals("P")) {
            if (this.bound == 0.0 && this.relOp == RelOp.LT) {
                return true;
            }
            if (this.bound == 1.0 && this.relOp == RelOp.GT) {
                return true;
            }
        }
        return false;
    }

    public MinMax getMinMax(ModelType modelType) throws PrismException {
        MinMax minMax = MinMax.blank();
        if (modelType.nondeterministic()) {
            if (this.relOp == RelOp.EQ && this.isNumeric()) {
                throw new PrismException("Can't use \"" + this.op + "=?\" for nondeterministic models; use e.g. \"" + this.op + "min=?\" or \"" + this.op + "max=?\"");
            }
            if (modelType == ModelType.MDP || modelType == ModelType.CTMDP) {
                minMax = this.relOp.isLowerBound() || this.relOp.isMin() ? MinMax.min() : MinMax.max();
            } else {
                throw new PrismException("Don't know how to model check " + this.getTypeOfOperator() + " properties for " + (Object)((Object)modelType) + "s");
            }
        }
        return minMax;
    }

    public String getTypeOfOperator() {
        String string = "";
        string = string + this.op + (Object)((Object)this.relOp);
        string = string + (this.isNumeric() ? "?" : "p");
        return string;
    }

    public String relOpBoundString() {
        return this.relOp.toString() + this.bound;
    }

    public String toString() {
        return this.op + this.relOp.toString() + this.bound;
    }
}

