/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import mtbdd.PrismMTBDD;
import odd.ODDUtils;
import parser.Values;
import parser.VarList;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;
import prism.ProbModel;
import sparse.PrismSparse;

public class NondetModel
extends ProbModel {
    protected double numChoices;
    protected JDDNode nondetMask;
    protected JDDVars allDDSynchVars;
    protected JDDVars allDDSchedVars;
    protected JDDVars allDDChoiceVars;
    protected JDDVars allDDNondetVars;
    protected JDDNode transInd;
    protected JDDNode[] transSynch;

    @Override
    public ModelType getModelType() {
        return ModelType.MDP;
    }

    public long getNumChoices() {
        return this.numChoices > 9.223372036854776E18 ? -1L : Math.round(this.numChoices);
    }

    public String getNumChoicesString() {
        return PrismUtils.bigIntToString(this.numChoices);
    }

    public JDDNode getNondetMask() {
        return this.nondetMask;
    }

    public JDDVars getAllDDSynchVars() {
        return this.allDDSynchVars;
    }

    public JDDVars getAllDDSchedVars() {
        return this.allDDSchedVars;
    }

    public JDDVars getAllDDChoiceVars() {
        return this.allDDChoiceVars;
    }

    public JDDVars getAllDDNondetVars() {
        return this.allDDNondetVars;
    }

    public JDDNode getTransInd() {
        return this.transInd;
    }

    public JDDNode[] getTransSynch() {
        return this.transSynch;
    }

    public int getNumDDNondetVars() {
        return this.allDDNondetVars.n();
    }

    @Override
    public int getNumDDVarsInTrans() {
        return this.allDDRowVars.n() * 2 + this.allDDNondetVars.n();
    }

    @Override
    public String getTransName() {
        return "Transition matrix";
    }

    @Override
    public String getTransSymbol() {
        return "S";
    }

    public boolean areAllChoiceActionsUnique() {
        for (int i = 0; i < this.numSynchs; ++i) {
            JDD.Ref(this.transActions);
            JDDNode jDDNode = JDD.Equals(this.transActions, i + 1);
            jDDNode = JDD.SumAbstract(jDDNode, this.allDDNondetVars);
            double d = JDD.FindMax(jDDNode);
            JDD.Deref(jDDNode);
            if (!(d > 1.0)) continue;
            return false;
        }
        JDD.Ref(this.reach);
        JDD.Ref(this.transActions);
        JDD.Ref(this.nondetMask);
        JDDNode jDDNode = JDD.And(this.reach, JDD.And(JDD.LessThanEquals(this.transActions, 0.0), JDD.Not(this.nondetMask)));
        jDDNode = JDD.SumAbstract(jDDNode, this.allDDNondetVars);
        double d = JDD.FindMax(jDDNode);
        JDD.Deref(jDDNode);
        return !(d > 1.0);
    }

    public void setTransInd(JDDNode jDDNode) {
        this.transInd = jDDNode;
    }

    public void setTransSynch(JDDNode[] jDDNodeArray) {
        this.transSynch = jDDNodeArray;
    }

    public NondetModel(JDDNode jDDNode, JDDNode jDDNode2, JDDNode[] jDDNodeArray, JDDNode[] jDDNodeArray2, String[] stringArray, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDVars jDDVars4, JDDVars jDDVars5, JDDVars jDDVars6, Vector<String> vector, int n, String[] stringArray2, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, int n2, VarList varList, JDDVars[] jDDVarsArray3, JDDVars[] jDDVarsArray4, Values values) {
        super(jDDNode, jDDNode2, jDDNodeArray, jDDNodeArray2, stringArray, jDDVars, jDDVars2, vector, n, stringArray2, jDDVarsArray, jDDVarsArray2, n2, varList, jDDVarsArray3, jDDVarsArray4, values);
        this.allDDSynchVars = jDDVars3;
        this.allDDSchedVars = jDDVars4;
        this.allDDChoiceVars = jDDVars5;
        this.allDDNondetVars = jDDVars6;
        this.transInd = null;
        this.transSynch = null;
    }

    @Override
    public void doReachability() {
        JDD.Ref(this.trans01);
        JDDNode jDDNode = JDD.MaxAbstract(this.trans01, this.allDDNondetVars);
        this.reach = PrismMTBDD.Reachability(jDDNode, this.allDDRowVars, this.allDDColVars, this.start);
        JDD.Deref(jDDNode);
        this.numStates = JDD.GetNumMinterms(this.reach, this.allDDRowVars.n());
        this.odd = ODDUtils.BuildODD(this.reach, this.allDDRowVars);
    }

    @Override
    public void filterReachableStates() {
        super.filterReachableStates();
        if (this.transInd != null) {
            JDD.Ref(this.reach);
            this.transInd = JDD.Apply(3, this.reach, this.transInd);
            for (int i = 0; i < this.numSynchs; ++i) {
                JDD.Ref(this.reach);
                this.transSynch[i] = JDD.Apply(3, this.reach, this.transSynch[i]);
            }
        }
        JDD.Ref(this.trans01);
        JDD.Ref(this.reach);
        if (this.nondetMask != null) {
            JDD.Deref(this.nondetMask);
        }
        this.nondetMask = JDD.And(JDD.ThereExists(this.trans01, this.allDDColVars), this.reach);
        this.numChoices = JDD.GetNumMinterms(this.nondetMask, this.getNumDDRowVars() + this.getNumDDNondetVars());
        JDD.Ref(this.reach);
        this.nondetMask = JDD.And(JDD.Not(this.nondetMask), this.reach);
    }

    @Override
    public void findDeadlocks(boolean bl) {
        JDD.Ref(this.trans01);
        this.deadlocks = JDD.ThereExists(this.trans01, this.allDDColVars);
        this.deadlocks = JDD.ThereExists(this.deadlocks, this.allDDNondetVars);
        JDD.Ref(this.reach);
        this.deadlocks = JDD.And(this.reach, JDD.Not(this.deadlocks));
        if (bl && !this.deadlocks.equals(JDD.ZERO)) {
            JDD.Ref(this.deadlocks);
            JDDNode jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.allDDNondetVars, 0L, 1.0);
            jDDNode = JDD.And(jDDNode, JDD.Identity(this.allDDRowVars, this.allDDColVars));
            jDDNode = JDD.And(this.deadlocks, jDDNode);
            JDD.Ref(jDDNode);
            this.trans = JDD.Apply(1, this.trans, jDDNode);
            JDD.Ref(jDDNode);
            this.trans01 = JDD.Apply(1, this.trans01, jDDNode);
            if (this.transInd != null) {
                JDD.Ref(jDDNode);
                this.transInd = JDD.Or(this.transInd, JDD.ThereExists(jDDNode, this.allDDColVars));
            }
            JDD.Deref(jDDNode);
            this.numTransitions = JDD.GetNumMinterms(this.trans01, this.getNumDDVarsInTrans());
            JDD.Ref(this.trans01);
            JDD.Ref(this.reach);
            if (this.nondetMask != null) {
                JDD.Deref(this.nondetMask);
            }
            this.nondetMask = JDD.And(JDD.ThereExists(this.trans01, this.allDDColVars), this.reach);
            this.numChoices = JDD.GetNumMinterms(this.nondetMask, this.getNumDDRowVars() + this.getNumDDNondetVars());
            JDD.Ref(this.reach);
            this.nondetMask = JDD.And(JDD.Not(this.nondetMask), this.reach);
        }
    }

    @Override
    public void printTransInfo(PrismLog prismLog, boolean bl) {
        prismLog.print("States:      " + this.getNumStatesString() + " (" + this.getNumStartStatesString() + " initial)" + "\n");
        prismLog.print("Transitions: " + this.getNumTransitionsString() + "\n");
        prismLog.print("Choices:     " + this.getNumChoicesString() + "\n");
        prismLog.println();
        prismLog.print(this.getTransName() + ": " + JDD.GetInfoString(this.trans, this.getNumDDVarsInTrans()));
        prismLog.print(", vars: " + this.getNumDDRowVars() + "r/" + this.getNumDDColVars() + "c/" + this.getNumDDNondetVars() + "nd\n");
        if (bl) {
            int n;
            int n2;
            prismLog.print("DD vars (nd):");
            int n3 = this.allDDNondetVars.getNumVars();
            for (n2 = 0; n2 < n3; ++n2) {
                n = this.allDDNondetVars.getVarIndex(n2);
                prismLog.print(" " + n + ":" + (String)this.ddVarNames.get(n));
            }
            prismLog.println();
            prismLog.print("DD vars (r/c):");
            n3 = this.allDDRowVars.getNumVars();
            for (n2 = 0; n2 < n3; ++n2) {
                n = this.allDDRowVars.getVarIndex(n2);
                prismLog.print(" " + n + ":" + (String)this.ddVarNames.get(n));
                n = this.allDDColVars.getVarIndex(n2);
                prismLog.print(" " + n + ":" + (String)this.ddVarNames.get(n));
            }
            prismLog.println();
            prismLog.print(this.getTransName() + " terminals: " + JDD.GetTerminalsAndNumbersString(this.trans, this.getNumDDVarsInTrans()) + "\n");
            prismLog.print("Reach: " + JDD.GetNumNodes(this.reach) + " nodes\n");
            prismLog.print("ODD: " + ODDUtils.GetNumODDNodes() + " nodes\n");
            prismLog.print("Mask: " + JDD.GetNumNodes(this.nondetMask) + " nodes, ");
            prismLog.print(JDD.GetNumMintermsString(this.nondetMask, this.getNumDDRowVars() + this.getNumDDNondetVars()) + " minterms\n");
            for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
                if (this.stateRewards[n2] != null && !this.stateRewards[n2].equals(JDD.ZERO)) {
                    prismLog.print("State rewards (" + (n2 + 1) + ("".equals(this.rewardStructNames[n2]) ? "" : ":\"" + this.rewardStructNames[n2] + "\"") + "): ");
                    prismLog.print(JDD.GetNumNodes(this.stateRewards[n2]) + " nodes (");
                    prismLog.print(JDD.GetNumTerminals(this.stateRewards[n2]) + " terminal), ");
                    prismLog.print(JDD.GetNumMintermsString(this.stateRewards[n2], this.getNumDDRowVars()) + " minterms\n");
                    if (bl) {
                        prismLog.print("State rewards terminals (" + (n2 + 1) + ("".equals(this.rewardStructNames[n2]) ? "" : ":\"" + this.rewardStructNames[n2] + "\"") + "): ");
                        prismLog.print(JDD.GetTerminalsAndNumbersString(this.stateRewards[n2], this.getNumDDRowVars()) + "\n");
                    }
                }
                if (this.transRewards[n2] == null || this.transRewards[n2].equals(JDD.ZERO)) continue;
                prismLog.print("Transition rewards (" + (n2 + 1) + ("".equals(this.rewardStructNames[n2]) ? "" : ":\"" + this.rewardStructNames[n2] + "\"") + "): ");
                prismLog.print(JDD.GetNumNodes(this.transRewards[n2]) + " nodes (");
                prismLog.print(JDD.GetNumTerminals(this.transRewards[n2]) + " terminal), ");
                prismLog.print(JDD.GetNumMintermsString(this.transRewards[n2], this.getNumDDVarsInTrans()) + " minterms\n");
                if (!bl) continue;
                prismLog.print("Transition rewards terminals (" + (n2 + 1) + ("".equals(this.rewardStructNames[n2]) ? "" : ":\"" + this.rewardStructNames[n2] + "\"") + "): ");
                prismLog.print(JDD.GetTerminalsAndNumbersString(this.transRewards[n2], this.getNumDDVarsInTrans()) + "\n");
            }
            if (this.transActions != null && !this.transActions.equals(JDD.ZERO)) {
                prismLog.print("Action label indices: ");
                prismLog.print(JDD.GetNumNodes(this.transActions) + " nodes (");
                prismLog.print(JDD.GetNumTerminals(this.transActions) + " terminal)\n");
            }
        }
    }

    @Override
    public void exportToFile(int n, boolean bl, File file) throws FileNotFoundException, PrismException {
        if (bl) {
            PrismSparse.ExportMDP(this.trans, this.transActions, this.getSynchs(), this.getTransSymbol(), this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.odd, n, file != null ? file.getPath() : null);
        }
    }

    @Override
    public String exportStateRewardsToFile(int n, File file) throws FileNotFoundException, PrismException {
        if (this.numRewardStructs == 0) {
            throw new PrismException("There are no state rewards to export");
        }
        String string = "";
        for (int i = 0; i < this.numRewardStructs; ++i) {
            String string2;
            String string3 = string2 = file != null ? file.getPath() : null;
            if (string2 != null && this.numRewardStructs > 1) {
                string2 = PrismUtils.addCounterSuffixToFilename(string2, i + 1);
                string = string + (i > 0 ? ", " : "") + string2;
            }
            PrismMTBDD.ExportVector(this.stateRewards[i], "c" + (i + 1), this.allDDRowVars, this.odd, n, string2);
        }
        return string.length() > 0 ? string : null;
    }

    @Override
    public String exportTransRewardsToFile(int n, boolean bl, File file) throws FileNotFoundException, PrismException {
        if (this.numRewardStructs == 0) {
            throw new PrismException("There are no transition rewards to export");
        }
        String string = "";
        for (int i = 0; i < this.numRewardStructs; ++i) {
            String string2;
            String string3 = string2 = file != null ? file.getPath() : null;
            if (string2 != null && this.numRewardStructs > 1) {
                string2 = PrismUtils.addCounterSuffixToFilename(string2, i + 1);
                string = string + (i > 0 ? ", " : "") + string2;
            }
            if (!bl) continue;
            PrismSparse.ExportSubMDP(this.trans, this.transRewards[i], "C" + (i + 1), this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.odd, n, string2);
        }
        return string.length() > 0 ? string : null;
    }

    @Override
    public void clear() {
        super.clear();
        this.allDDSynchVars.derefAll();
        this.allDDSchedVars.derefAll();
        this.allDDChoiceVars.derefAll();
        this.allDDNondetVars.derefAll();
        JDD.Deref(this.nondetMask);
        if (this.transInd != null) {
            JDD.Deref(this.transInd);
        }
        if (this.transSynch != null) {
            for (int i = 0; i < this.numSynchs; ++i) {
                JDD.Deref(this.transSynch[i]);
            }
        }
    }
}

