/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lpsolve.LpSolve;
import lpsolve.LpSolveException;
import prism.PermutedLexicographicComparator;
import prism.Point;
import prism.PrismException;
import prism.TileList;

public class MultiObjUtils {
    public static Point getWeights(Point point, List<Point> list) throws PrismException {
        int n = point.getDimension();
        if (list == null || list.size() == 0) {
            Point point2;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (point.getCoord(i) == 0.0) continue;
                bl = true;
                break;
            }
            if (bl) {
                point2 = point.normalize();
            } else {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = 1.0;
                }
                point2 = new Point(dArray).normalize();
            }
            return point2;
        }
        int n2 = n + 1;
        try {
            int n3;
            LpSolve lpSolve = LpSolve.makeLp((int)0, (int)(n + 2));
            lpSolve.setVerbose(1);
            double[] dArray = new double[n + 3];
            for (int i = 0; i < n; ++i) {
                dArray[i + 1] = point.getCoord(i);
            }
            dArray[n + 2] = -1.0;
            lpSolve.addConstraint(dArray, 2, 0.0);
            for (Point object2 : list) {
                dArray = new double[n + 3];
                for (int dArray2 = 0; dArray2 < n; ++dArray2) {
                    dArray[dArray2 + 1] = object2.getCoord(dArray2);
                }
                dArray[n2] = 1.0;
                dArray[n + 2] = -1.0;
                lpSolve.addConstraint(dArray, 1, 0.0);
            }
            for (n3 = 0; n3 < n; ++n3) {
                dArray = new double[n + 3];
                dArray[n3 + 1] = 1.0;
                lpSolve.addConstraint(dArray, 2, 0.0);
            }
            dArray = new double[n + 3];
            for (n3 = 0; n3 < n; ++n3) {
                dArray[n3 + 1] = 1.0;
            }
            lpSolve.addConstraint(dArray, 1, 1.0);
            dArray = new double[n + 3];
            dArray[n2] = 1.0;
            lpSolve.setBounds(n + 2, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            lpSolve.setObjFn(dArray);
            lpSolve.setMaxim();
            n3 = lpSolve.solve();
            if (n3 == 2) {
                System.out.println("The solution is infeasible");
                return null;
            }
            if (n3 == 3) {
                throw new PrismException("The solution of a linear program is unbounded.");
            }
            if (n3 != 0) {
                throw new PrismException("LpSolve returns an unexpected value: " + n3);
            }
            double[] dArray2 = lpSolve.getPtrVariables();
            if (dArray2[n2 - 1] == 0.0) {
                return null;
            }
            double[] dArray3 = new double[n];
            for (int point3 = 0; point3 < n; ++point3) {
                dArray3[point3] = dArray2[point3];
            }
            Point point2 = new Point(dArray3).normalize();
            return point2;
        }
        catch (LpSolveException lpSolveException) {
            PrismException prismException = new PrismException("lpsolve threw an exception: " + lpSolveException.getMessage());
            throw prismException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void printGraphFileDebug(Point point, List<Point> list, List<Point> list2, String string, int n) throws PrismException {
        double d;
        double d2 = 1.2;
        double d3 = point.getCoord(0) * d2;
        double d4 = point.getCoord(1) * d2;
        for (Point object : list) {
            double point3 = object.getCoord(0) * d2;
            d = object.getCoord(1) * d2;
            d3 = d3 >= point3 ? d3 : point3;
            d4 = d4 >= d ? d4 : d;
        }
        try {
            void var12_13;
            Object object;
            if (point != null) {
                object = new FileWriter(new File(string, "dataT" + n + ".dat"));
                ((Writer)object).write(point.getCoord(0) + " " + point.getCoord(1));
                ((OutputStreamWriter)object).close();
            }
            object = new FileWriter(new File(string, "dataP" + n + ".dat"));
            for (Point point2 : list) {
                ((Writer)object).write(point2.getCoord(0) + " " + point2.getCoord(1) + "\n");
            }
            ((OutputStreamWriter)object).close();
            object = new FileWriter(new File(string, "plot" + n + ".plot"));
            ((Writer)object).write("set parametric\n");
            ((Writer)object).write("set trange [0:" + d3 + "]\n");
            ((Writer)object).write("set xrange [0:" + d3 + "]\n");
            ((Writer)object).write("set yrange [0:" + d4 + "]\n");
            ((Writer)object).write("set term aqua\n");
            ((Writer)object).write("plot ");
            if (point != null) {
                ((Writer)object).write("\"dataT" + n + ".dat\" with points pt 9, ");
            }
            ((Writer)object).write("\"< sort dataP" + n + ".dat\"  with linespoints pt 9 lw 3");
            boolean bl = false;
            while (var12_13 < list.size()) {
                Point point3 = list.get((int)var12_13);
                Point point4 = list2.get((int)var12_13);
                d = point3.getCoord(0) * point4.getCoord(0) + point3.getCoord(1) * point4.getCoord(1);
                if (point4.getCoord(1) > 0.0) {
                    ((Writer)object).write(", t,(-" + point4.getCoord(0) + "*t + " + d + ")/" + point4.getCoord(1) + " with lines lc 3");
                } else {
                    ((Writer)object).write(", " + point3.getCoord(0) + ",t with lines lc 3");
                }
                ++var12_13;
            }
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            throw new PrismException("An IOException error occured when writing graph files (exception message: " + iOException.getMessage() + ").");
        }
    }

    public static void exportPareto(TileList tileList, String string) throws PrismException {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(tileList.toString());
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new PrismException("An IOException error occured when writing graph files (exception message: " + iOException.getMessage() + ").");
        }
    }

    protected static Map<Point, Point> fillDirections(List<Point> list, List<Point> list2, boolean bl) {
        HashMap<Point, Point> hashMap = new HashMap<Point, Point>();
        for (int i = 0; i < list.size(); ++i) {
            Point point = list.get(i);
            Point point2 = list2.get(i);
            boolean bl2 = false;
            for (Point point3 : hashMap.keySet()) {
                double d;
                if (!point3.isCloseTo(point)) continue;
                double d2 = point2.getCoord(1) == 0.0 ? Double.POSITIVE_INFINITY : point2.getCoord(0) / point2.getCoord(1);
                double d3 = d = hashMap.get(point3).getCoord(1) == 0.0 ? Double.POSITIVE_INFINITY : hashMap.get(point3).getCoord(0) / hashMap.get(point3).getCoord(1);
                if (!(bl && d2 < d) && (bl || !(d2 > d))) continue;
                hashMap.put(point3, point2);
                break;
            }
            if (bl2) continue;
            hashMap.put(point, point2);
        }
        return hashMap;
    }

    protected static List<Point> removeDuplicities(List<Point> list) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        if (list.size() == 0) {
            return arrayList;
        }
        arrayList.add(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            Point point = list.get(i);
            boolean bl = false;
            for (Point point2 : arrayList) {
                if (!point2.isCloseTo(point)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(point);
        }
        return arrayList;
    }

    protected static List<Point> upperBoundPoints(List<Point> list, List<Point> list2) {
        Map<Point, Point> map = MultiObjUtils.fillDirections(list, list2, true);
        Map<Point, Point> map2 = MultiObjUtils.fillDirections(list, list2, false);
        PermutedLexicographicComparator permutedLexicographicComparator = new PermutedLexicographicComparator(new int[]{0, 1}, new boolean[]{true, false});
        List<Point> list3 = MultiObjUtils.removeDuplicities(list);
        Collections.sort(list3, permutedLexicographicComparator);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < list3.size() - 1; ++i) {
            Point point;
            double d;
            double d2;
            Point point2 = list3.get(i);
            Point point3 = list3.get(i + 1);
            Point point4 = map2.get(point2);
            Point point5 = map.get(point3);
            if (point5.getCoord(1) > 1.0E-5) {
                d2 = point2.getCoord(0) * point4.getCoord(0) + point2.getCoord(1) * point4.getCoord(1);
                d = point3.getCoord(0) * point5.getCoord(0) + point3.getCoord(1) * point5.getCoord(1);
                double[][] dArrayArray = new double[][]{{point4.getCoord(0), point4.getCoord(1)}, {point5.getCoord(0), point5.getCoord(1)}};
                double[] dArray = MultiObjUtils.solveEqns(dArrayArray, new double[]{d2, d});
                if (dArray == null) continue;
                point = new Point(dArray);
            } else if (point4.getCoord(0) < 1.0E-5 && point5.getCoord(1) < 1.0E-5) {
                point = new Point(new double[]{point3.getCoord(0), point2.getCoord(1)});
            } else {
                d2 = point3.getCoord(0);
                d = point2.getCoord(0) * point4.getCoord(0) + point2.getCoord(1) * point4.getCoord(1);
                double d3 = (d - point4.getCoord(0) * d2) / point4.getCoord(1);
                point = new Point(new double[]{d2, d3});
            }
            boolean bl = false;
            for (Point point6 : list) {
                if (!point6.isCloseTo(point)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(point);
        }
        return arrayList;
    }

    protected static Point getNewTarget(List<Point> list, List<Point> list2, double d, double[] dArray) {
        if (list.size() == 0) {
            return new Point(new double[]{dArray[0], 0.0});
        }
        if (list.size() == 1) {
            return new Point(new double[]{0.0, dArray[1]});
        }
        PermutedLexicographicComparator permutedLexicographicComparator = new PermutedLexicographicComparator(new int[]{0, 1}, new boolean[]{true, false});
        List<Point> list3 = MultiObjUtils.removeDuplicities(list);
        Collections.sort(list3, permutedLexicographicComparator);
        System.out.println("sortedLP" + list3);
        List<Point> list4 = MultiObjUtils.upperBoundPoints(list, list2);
        Collections.sort(list4, permutedLexicographicComparator);
        System.out.println("sortedUP: " + list4);
        int n = 0;
        int n2 = 0;
        double d2 = 0.0;
        int n3 = -1;
        while (n < list3.size() - 1 && n2 < list4.size()) {
            if (list4.get(n2).getCoord(0) > list3.get(n + 1).getCoord(0)) {
                ++n;
                continue;
            }
            if (!(list4.get(n2).getCoord(0) <= list3.get(n + 1).getCoord(0))) break;
            double d3 = list3.get(n).getCoord(0);
            double d4 = list3.get(n).getCoord(1);
            double d5 = list3.get(n + 1).getCoord(0);
            double d6 = list3.get(n + 1).getCoord(1);
            double d7 = list4.get(n2).getCoord(1);
            double d8 = (d3 - d5) * (d7 - d6) / (d4 - d6) + d5;
            double d9 = Math.abs((list4.get(n2).getCoord(0) - d8) / d8);
            if (d2 < d9) {
                d2 = d9;
                n3 = n2;
            }
            d8 = list4.get(n2).getCoord(0);
            d7 = (d4 - d6) * (d8 - d5) / (d3 - d5) + d6;
            d9 = Math.abs((list4.get(n2).getCoord(1) - d7) / d7);
            if (d2 < d9) {
                d2 = d9;
                n3 = n2;
            }
            ++n2;
        }
        if (n3 != -1 && d2 > d) {
            return list4.get(n3);
        }
        return null;
    }

    protected static double[] solveEqns(double[][] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3 = dArray[0].length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = n2;
            for (int i = n2 + 1; i < n3; ++i) {
                if (!(dArray[i][n2] > dArray[n][n2])) continue;
                n = i;
            }
            double[] dArray3 = dArray[n2];
            dArray[n2] = dArray[n];
            dArray[n] = dArray3;
            double d = dArray2[n2];
            dArray2[n2] = dArray2[n];
            dArray2[n] = d;
            if (!(Math.abs(dArray[n2][n2]) > 1.0E-5)) continue;
            int n4 = n2 + 1;
            while (n4 < dArray.length) {
                double d2 = dArray[n4][n2] / dArray[n2][n2];
                for (int i = n2; i < n3; ++i) {
                    double[] dArray4 = dArray[n4];
                    int n5 = i;
                    dArray4[n5] = dArray4[n5] - d2 * dArray[n2][i];
                }
                int n6 = n4++;
                dArray2[n6] = dArray2[n6] - d2 * dArray2[n2];
            }
        }
        for (n2 = n3; n2 < dArray.length; ++n2) {
            if (!(Math.abs(dArray[n2][n3 - 1]) > 1.0E-5) && !(Math.abs(dArray2[n2]) > 1.0E-5)) continue;
            System.out.println("m " + Arrays.deepToString((Object[])dArray) + " " + Arrays.toString(dArray2));
            return null;
        }
        double[] dArray5 = new double[dArray[0].length];
        for (n = dArray[0].length - 1; n >= 0; --n) {
            double d = 0.0;
            for (int i = n + 1; i < dArray[0].length; ++i) {
                d += dArray[n][i] * dArray5[i];
            }
            dArray5[n] = dArray[n][n] < 1.0E-5 && Math.abs(dArray2[n] - d) < 1.0E-5 ? 0.0 : (dArray2[n] - d) / dArray[n][n];
        }
        return dArray5;
    }
}

