/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import java.util.Vector;
import parser.ast.ASTElement;
import parser.ast.Command;
import parser.ast.ConstantList;
import parser.ast.Declaration;
import parser.ast.DeclarationArray;
import parser.ast.DeclarationClock;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionFormula;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionVar;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.SystemHide;
import parser.ast.SystemParallel;
import parser.ast.SystemReference;
import parser.ast.SystemRename;
import parser.ast.Update;
import parser.type.TypeClock;
import parser.visitor.ASTTraverse;
import prism.ModelType;
import prism.PrismLangException;

public class SemanticCheck
extends ASTTraverse {
    private ModulesFile modulesFile;
    private PropertiesFile propertiesFile;
    private ModulesFile inModulesFile = null;
    private Module inModule = null;
    private Expression inInvariant = null;
    private Expression inGuard = null;
    private Update inUpdate = null;

    public SemanticCheck() {
        this(null, null);
    }

    public SemanticCheck(ModulesFile modulesFile) {
        this(modulesFile, null);
    }

    public SemanticCheck(ModulesFile modulesFile, PropertiesFile propertiesFile) {
        this.setModulesFile(modulesFile);
        this.setPropertiesFile(propertiesFile);
    }

    public void setModulesFile(ModulesFile modulesFile) {
        this.modulesFile = modulesFile;
    }

    public void setPropertiesFile(PropertiesFile propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    @Override
    public void visitPre(ModulesFile modulesFile) throws PrismLangException {
        this.inModulesFile = modulesFile;
    }

    @Override
    public void visitPost(ModulesFile modulesFile) throws PrismLangException {
        int n;
        int n2;
        this.inModulesFile = null;
        if (modulesFile.getInitialStates() != null) {
            n2 = modulesFile.getNumGlobals();
            for (n = 0; n < n2; ++n) {
                if (!modulesFile.getGlobal(n).isStartSpecified()) continue;
                throw new PrismLangException("Cannot use both \"init...endinit\" and initial values for variables", modulesFile.getGlobal(n).getStart());
            }
            n2 = modulesFile.getNumModules();
            for (n = 0; n < n2; ++n) {
                Module module = modulesFile.getModule(n);
                int n3 = module.getNumDeclarations();
                for (int i = 0; i < n3; ++i) {
                    if (!module.getDeclaration(i).isStartSpecified()) continue;
                    throw new PrismLangException("Cannot use both \"init...endinit\" and initial values for variables", module.getDeclaration(i).getStart());
                }
            }
        }
        if (modulesFile.getSystemDefn() != null) {
            Vector<String> vector = new Vector<String>();
            modulesFile.getSystemDefn().getModules(vector, this.modulesFile);
            n2 = modulesFile.getNumModules();
            for (n = 0; n < n2; ++n) {
                int n4 = vector.indexOf(modulesFile.getModuleName(n));
                if (n4 == -1) {
                    throw new PrismLangException("Module " + modulesFile.getModuleName(n) + " does not appear in the \"system\" construct", modulesFile.getSystemDefn());
                }
                if (vector.indexOf(modulesFile.getModuleName(n), n4 + 1) == -1) continue;
                throw new PrismLangException("Module " + modulesFile.getModuleName(n) + " appears more than once in the \"system\" construct", modulesFile.getSystemDefn());
            }
        }
    }

    @Override
    public Object visit(SystemReference systemReference) throws PrismLangException {
        if (this.modulesFile.getSystemDefnByName(systemReference.getName()) == null) {
            throw new PrismLangException("Reference to system " + systemReference.getName() + " which does not exist", systemReference);
        }
        return null;
    }

    @Override
    public Object visit(FormulaList formulaList) throws PrismLangException {
        return null;
    }

    @Override
    public void visitPost(LabelList labelList) throws PrismLangException {
        int n = labelList.size();
        for (int i = 0; i < n; ++i) {
            String string = labelList.getLabelName(i);
            if ("deadlock".equals(string)) {
                throw new PrismLangException("Cannot define a label called \"deadlock\" - this is a built-in label", labelList.getLabel(i));
            }
            if (!"init".equals(string)) continue;
            throw new PrismLangException("Cannot define a label called \"init\" - this is a built-in label", labelList.getLabel(i));
        }
    }

    @Override
    public void visitPost(ConstantList constantList) throws PrismLangException {
        int n = constantList.size();
        for (int i = 0; i < n; ++i) {
            if (constantList.getConstant(i) == null || constantList.getConstant(i).isConstant()) continue;
            throw new PrismLangException("Definition of constant \"" + constantList.getConstantName(i) + "\" is not constant", constantList.getConstant(i));
        }
    }

    @Override
    public void visitPost(Declaration declaration) throws PrismLangException {
        if (declaration.getStart() != null && !declaration.getStart().isConstant()) {
            throw new PrismLangException("Initial variable value of variable \"" + declaration.getName() + "\" is not constant", declaration.getStart());
        }
        if (declaration.getStart() != null && declaration.getType() instanceof TypeClock) {
            throw new PrismLangException("Cannot specify initial value for a clock", declaration);
        }
    }

    @Override
    public void visitPost(DeclarationInt declarationInt) throws PrismLangException {
        if (declarationInt.getLow() != null && !declarationInt.getLow().isConstant()) {
            throw new PrismLangException("Integer range lower bound \"" + declarationInt.getLow() + "\" is not constant", declarationInt.getLow());
        }
        if (declarationInt.getHigh() != null && !declarationInt.getHigh().isConstant()) {
            throw new PrismLangException("Integer range upper bound \"" + declarationInt.getLow() + "\" is not constant", declarationInt.getLow());
        }
    }

    @Override
    public void visitPost(DeclarationArray declarationArray) throws PrismLangException {
        if (declarationArray.getLow() != null && !declarationArray.getLow().isConstant()) {
            throw new PrismLangException("Array lower bound \"" + declarationArray.getLow() + "\" is not constant", declarationArray.getLow());
        }
        if (declarationArray.getHigh() != null && !declarationArray.getHigh().isConstant()) {
            throw new PrismLangException("Array upper bound \"" + declarationArray.getLow() + "\" is not constant", declarationArray.getLow());
        }
    }

    @Override
    public void visitPost(DeclarationClock declarationClock) throws PrismLangException {
        if (this.modulesFile.getModelType() != ModelType.PTA) {
            throw new PrismLangException("Clock variables are only allowed in PTA models", declarationClock);
        }
    }

    @Override
    public void visitPre(Module module) throws PrismLangException {
        this.inModule = module;
    }

    @Override
    public Object visit(Module module) throws PrismLangException {
        int n;
        this.visitPre(module);
        int n2 = module.getNumDeclarations();
        for (n = 0; n < n2; ++n) {
            if (module.getDeclaration(n) == null) continue;
            module.getDeclaration(n).accept(this);
        }
        this.inInvariant = module.getInvariant();
        if (module.getInvariant() != null) {
            module.getInvariant().accept(this);
        }
        this.inInvariant = null;
        n2 = module.getNumCommands();
        for (n = 0; n < n2; ++n) {
            if (module.getCommand(n) == null) continue;
            module.getCommand(n).accept(this);
        }
        this.visitPost(module);
        return null;
    }

    @Override
    public void visitPost(Module module) throws PrismLangException {
        this.inModule = null;
    }

    @Override
    public Object visit(Command command) throws PrismLangException {
        this.visitPre(command);
        this.inGuard = command.getGuard();
        command.getGuard().accept(this);
        this.inGuard = null;
        command.getUpdates().accept(this);
        this.visitPost(command);
        return null;
    }

    @Override
    public void visitPre(Update update) throws PrismLangException {
        this.inUpdate = update;
    }

    @Override
    public void visitPost(Update update) throws PrismLangException {
        this.inUpdate = null;
        Command command = update.getParent().getParent();
        Module module = command.getParent();
        ModulesFile modulesFile = module.getParent();
        int n = update.getNumElements();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            String string = update.getVar(i);
            boolean bl2 = module.isLocalVariable(string);
            boolean bl3 = bl = bl2 ? false : modulesFile.isGlobalVariable(string);
            if (!bl2 && !bl) {
                String string2 = "Module \"" + module.getName() + "\" is not allowed to modify variable \"" + string + "\"";
                throw new PrismLangException(string2, update.getVarIdent(i));
            }
            if (!bl || command.getSynch().equals("")) continue;
            String string3 = "Synchronous command cannot modify global variable";
            throw new PrismLangException(string3, update.getVarIdent(i));
        }
    }

    @Override
    public void visitPost(SystemRename systemRename) throws PrismLangException {
        Vector<String> vector = new Vector<String>();
        int n = systemRename.getNumRenames();
        for (int i = 0; i < n; ++i) {
            String string = systemRename.getFrom(i);
            if (!this.modulesFile.isSynch(string)) {
                throw new PrismLangException("Invalid action \"" + string + "\" in \"system\" construct", systemRename);
            }
            if (vector.contains(string)) {
                throw new PrismLangException("Duplicated action \"" + string + "\" in parallel composition in \"system\" construct", systemRename);
            }
            vector.addElement(string);
        }
    }

    @Override
    public void visitPost(SystemHide systemHide) throws PrismLangException {
        Vector<String> vector = new Vector<String>();
        int n = systemHide.getNumActions();
        for (int i = 0; i < n; ++i) {
            String string = systemHide.getAction(i);
            if (!this.modulesFile.isSynch(string)) {
                throw new PrismLangException("Invalid action \"" + string + "\" in \"system\" construct", systemHide);
            }
            if (vector.contains(string)) {
                throw new PrismLangException("Duplicated action \"" + string + "\" in parallel composition in \"system\" construct", systemHide);
            }
            vector.addElement(string);
        }
    }

    @Override
    public void visitPost(SystemParallel systemParallel) throws PrismLangException {
        Vector<String> vector = new Vector<String>();
        int n = systemParallel.getNumActions();
        for (int i = 0; i < n; ++i) {
            String string = systemParallel.getAction(i);
            if (!this.modulesFile.isSynch(string)) {
                throw new PrismLangException("Invalid action \"" + string + "\" in \"system\" construct", systemParallel);
            }
            if (vector.contains(string)) {
                throw new PrismLangException("Duplicated action \"" + string + "\" in parallel composition in \"system\" construct", systemParallel);
            }
            vector.addElement(string);
        }
    }

    @Override
    public void visitPost(ExpressionTemporal expressionTemporal) throws PrismLangException {
        int n = expressionTemporal.getOperator();
        Expression expression = expressionTemporal.getOperand1();
        Expression expression2 = expressionTemporal.getOperand2();
        Expression expression3 = expressionTemporal.getLowerBound();
        Expression expression4 = expressionTemporal.getUpperBound();
        if (expression3 != null && !expression3.isConstant()) {
            throw new PrismLangException("Lower bound in " + expressionTemporal.getOperatorSymbol() + " operator is not constant", expression3);
        }
        if (expression4 != null && !expression4.isConstant()) {
            throw new PrismLangException("Upper bound in " + expressionTemporal.getOperatorSymbol() + " operator is not constant", expression4);
        }
        if (n == 1 && (expression != null || expression2 == null || expression3 != null || expression4 != null)) {
            throw new PrismLangException("Cannot attach bounds to " + expressionTemporal.getOperatorSymbol() + " operator", expressionTemporal);
        }
        if (n == 11 && (expression != null || expression2 != null || expression3 != null)) {
            throw new PrismLangException("Badly formed " + expressionTemporal.getOperatorSymbol() + " operator", expressionTemporal);
        }
        if (n == 12 && (expression != null || expression2 != null || expression3 != null || expression4 == null)) {
            throw new PrismLangException("Badly formed " + expressionTemporal.getOperatorSymbol() + " operator", expressionTemporal);
        }
        if (n == 13 && (expression != null || expression2 == null || expression3 != null || expression4 != null)) {
            throw new PrismLangException("Badly formed " + expressionTemporal.getOperatorSymbol() + " operator", expressionTemporal);
        }
        if (n == 14 && (expression != null || expression2 != null || expression3 != null || expression4 != null)) {
            throw new PrismLangException("Badly formed " + expressionTemporal.getOperatorSymbol() + " operator", expressionTemporal);
        }
    }

    @Override
    public void visitPost(ExpressionFunc expressionFunc) throws PrismLangException {
        if (expressionFunc.getNameCode() == -1) {
            throw new PrismLangException("Unknown function \"" + expressionFunc.getName() + "\"", expressionFunc);
        }
        if (expressionFunc.getNumOperands() < expressionFunc.getMinArity()) {
            throw new PrismLangException("Not enough arguments to \"" + expressionFunc.getName() + "\" function", expressionFunc);
        }
        if (expressionFunc.getMaxArity() != -1 && expressionFunc.getNumOperands() > expressionFunc.getMaxArity()) {
            throw new PrismLangException("Too many arguments to \"" + expressionFunc.getName() + "\" function", expressionFunc);
        }
    }

    @Override
    public void visitPost(ExpressionIdent expressionIdent) throws PrismLangException {
        throw new PrismLangException("Undeclared identifier", expressionIdent);
    }

    @Override
    public void visitPost(ExpressionFormula expressionFormula) throws PrismLangException {
        if (expressionFormula.getDefinition() == null) {
            throw new PrismLangException("Unexpanded formula", expressionFormula);
        }
    }

    @Override
    public void visitPost(ExpressionVar expressionVar) throws PrismLangException {
        if (expressionVar.getType() instanceof TypeClock && this.inModulesFile != null && this.inInvariant == null && this.inGuard == null) {
            throw new PrismLangException("Reference to a clock variable cannot appear here", expressionVar);
        }
    }

    @Override
    public void visitPost(ExpressionProb expressionProb) throws PrismLangException {
        if (expressionProb.getModifier() != null) {
            throw new PrismLangException("Modifier \"" + expressionProb.getModifier() + "\" not supported for P operator");
        }
        if (expressionProb.getProb() != null && !expressionProb.getProb().isConstant()) {
            throw new PrismLangException("P operator probability bound is not constant", expressionProb.getProb());
        }
    }

    @Override
    public void visitPost(ExpressionReward expressionReward) throws PrismLangException {
        Object object;
        if (expressionReward.getModifier() != null) {
            throw new PrismLangException("Modifier \"" + expressionReward.getModifier() + "\" not supported for R operator");
        }
        if (expressionReward.getRewardStructIndex() != null) {
            if (expressionReward.getRewardStructIndex() instanceof Expression) {
                object = (Expression)expressionReward.getRewardStructIndex();
                if (!((Expression)object).isConstant()) {
                    throw new PrismLangException("R operator reward struct index is not constant", (ASTElement)object);
                }
            } else if (expressionReward.getRewardStructIndex() instanceof String) {
                object = (String)expressionReward.getRewardStructIndex();
                if (this.modulesFile != null && this.modulesFile.getRewardStructIndex((String)object) == -1) {
                    throw new PrismLangException("R operator reward struct index \"" + (String)object + "\" does not exist", expressionReward);
                }
            }
        }
        if (expressionReward.getRewardStructIndexDiv() != null) {
            if (expressionReward.getRewardStructIndexDiv() instanceof Expression) {
                object = (Expression)expressionReward.getRewardStructIndexDiv();
                if (!((Expression)object).isConstant()) {
                    throw new PrismLangException("R operator reward struct index is not constant", (ASTElement)object);
                }
            } else if (expressionReward.getRewardStructIndexDiv() instanceof String) {
                object = (String)expressionReward.getRewardStructIndexDiv();
                if (this.modulesFile != null && this.modulesFile.getRewardStructIndex((String)object) == -1) {
                    throw new PrismLangException("R operator reward struct index \"" + (String)object + "\" does not exist", expressionReward);
                }
            }
        }
        if (expressionReward.getReward() != null && !expressionReward.getReward().isConstant()) {
            throw new PrismLangException("R operator reward bound is not constant", expressionReward.getReward());
        }
    }

    @Override
    public void visitPost(ExpressionSS expressionSS) throws PrismLangException {
        if (expressionSS.getModifier() != null) {
            throw new PrismLangException("Modifier \"" + expressionSS.getModifier() + "\" not supported for S operator");
        }
        if (expressionSS.getProb() != null && !expressionSS.getProb().isConstant()) {
            throw new PrismLangException("S operator probability bound is not constant", expressionSS.getProb());
        }
    }

    @Override
    public void visitPost(ExpressionLabel expressionLabel) throws PrismLangException {
        LabelList labelList;
        if (this.propertiesFile != null) {
            labelList = this.propertiesFile.getCombinedLabelList();
        } else if (this.modulesFile != null) {
            labelList = this.modulesFile.getLabelList();
        } else {
            throw new PrismLangException("Undeclared label", expressionLabel);
        }
        String string = expressionLabel.getName();
        if ("deadlock".equals(string) || "init".equals(string)) {
            return;
        }
        if (labelList == null || labelList.getLabelIndex(string) == -1) {
            throw new PrismLangException("Undeclared label", expressionLabel);
        }
    }

    @Override
    public void visitPost(ExpressionFilter expressionFilter) throws PrismLangException {
        if (expressionFilter.getOperatorType() == null) {
            throw new PrismLangException("Unknown filter type \"" + expressionFilter.getOperatorName() + "\"", expressionFilter);
        }
    }
}

