/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import java.util.Vector;
import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionProp;
import parser.ast.LabelList;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.visitor.ASTTraverse;
import prism.PrismLangException;

public class GetAllUndefinedConstantsRecursively
extends ASTTraverse {
    private Vector<String> v;
    private ConstantList constantList;
    private LabelList labelList;
    private PropertiesFile propertiesFile;

    public GetAllUndefinedConstantsRecursively(Vector<String> vector, ConstantList constantList, LabelList labelList, PropertiesFile propertiesFile) {
        this.v = vector;
        this.constantList = constantList;
        this.labelList = labelList;
        this.propertiesFile = propertiesFile;
    }

    @Override
    public void visitPost(ExpressionConstant expressionConstant) throws PrismLangException {
        int n = this.constantList.getConstantIndex(expressionConstant.getName());
        if (n == -1) {
            return;
        }
        Expression expression = this.constantList.getConstant(n);
        if (expression == null) {
            if (!this.v.contains(expressionConstant.getName())) {
                this.v.addElement(expressionConstant.getName());
            }
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visitPost(ExpressionLabel expressionLabel) throws PrismLangException {
        if (expressionLabel.getName().equals("deadlock") || expressionLabel.getName().equals("init")) {
            return;
        }
        if (this.labelList == null) {
            return;
        }
        int n = this.labelList.getLabelIndex(expressionLabel.getName());
        if (n == -1) {
            return;
        }
        Expression expression = this.labelList.getLabel(n);
        expression.accept(this);
    }

    @Override
    public void visitPost(ExpressionProp expressionProp) throws PrismLangException {
        if (this.propertiesFile == null) {
            return;
        }
        Property property = this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
        if (property == null) {
            return;
        }
        property.getExpression().accept(this);
    }
}

