/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import java.util.Vector;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionVar;
import parser.ast.Update;
import parser.type.Type;
import parser.visitor.ASTTraverseModify;
import prism.PrismLangException;

public class FindAllVars
extends ASTTraverseModify {
    private Vector<String> varIdents;
    private Vector<Type> varTypes;

    public FindAllVars(Vector<String> vector, Vector<Type> vector2) {
        this.varIdents = vector;
        this.varTypes = vector2;
    }

    @Override
    public void visitPost(Update update) throws PrismLangException {
        int n = update.getNumElements();
        for (int i = 0; i < n; ++i) {
            int n2 = this.varIdents.indexOf(update.getVar(i));
            if (n2 == -1) {
                String string = "Unknown variable \"" + update.getVar(i) + "\" in update";
                throw new PrismLangException(string, update.getVarIdent(i));
            }
            update.setType(i, this.varTypes.elementAt(n2));
            update.setVarIndex(i, n2);
        }
    }

    @Override
    public Object visit(ExpressionIdent expressionIdent) throws PrismLangException {
        int n = this.varIdents.indexOf(expressionIdent.getName());
        if (n != -1) {
            ExpressionVar expressionVar = new ExpressionVar(expressionIdent.getName(), this.varTypes.elementAt(n));
            expressionVar.setPosition(expressionIdent);
            expressionVar.setIndex(n);
            return expressionVar;
        }
        return expressionIdent;
    }

    @Override
    public Object visit(ExpressionVar expressionVar) throws PrismLangException {
        int n = this.varIdents.indexOf(expressionVar.getName());
        if (n != -1) {
            expressionVar.setIndex(n);
            return expressionVar;
        }
        throw new PrismLangException("Unknown variable " + expressionVar.getName() + " in ExpressionVar object", expressionVar);
    }
}

