/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import java.util.List;
import parser.ast.Command;
import parser.ast.RewardStructItem;
import parser.visitor.ASTTraverseModify;
import prism.PrismLangException;

public class FindAllActions
extends ASTTraverseModify {
    private List<String> synchs;

    public FindAllActions(List<String> list) {
        this.synchs = list;
    }

    @Override
    public void visitPost(Command command) throws PrismLangException {
        if (command.getSynch().equals("")) {
            command.setSynchIndex(0);
            return;
        }
        int n = this.synchs.indexOf(command.getSynch());
        if (n != -1) {
            command.setSynchIndex(n + 1);
            return;
        }
        throw new PrismLangException("Unknown action name " + command.getSynch() + " in command", command);
    }

    @Override
    public void visitPost(RewardStructItem rewardStructItem) throws PrismLangException {
        if (!rewardStructItem.isTransitionReward()) {
            return;
        }
        if (rewardStructItem.getSynch().equals("")) {
            rewardStructItem.setSynchIndex(0);
            return;
        }
        int n = this.synchs.indexOf(rewardStructItem.getSynch());
        if (n != -1) {
            rewardStructItem.setSynchIndex(n + 1);
            return;
        }
        throw new PrismLangException("Unknown action name " + rewardStructItem.getSynch() + " in reward structure item", rewardStructItem);
    }
}

