/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import java.util.Hashtable;
import jltl2ba.SimpleLTL;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import parser.visitor.ASTTraverseModify;
import prism.PrismLangException;

public class ConvertForJltl2ba
extends ASTTraverseModify {
    private Hashtable<ASTElement, SimpleLTL> formulas = new Hashtable();

    public Object setFormula(ASTElement aSTElement, SimpleLTL simpleLTL) {
        return this.formulas.put(aSTElement, simpleLTL);
    }

    public SimpleLTL getFormula(ASTElement aSTElement) {
        return this.formulas.get(aSTElement);
    }

    @Override
    public void visitPost(ExpressionTemporal expressionTemporal) throws PrismLangException {
        SimpleLTL simpleLTL = null;
        SimpleLTL simpleLTL2 = null;
        SimpleLTL simpleLTL3 = null;
        if (expressionTemporal.getOperand1() != null) {
            simpleLTL = this.getFormula(expressionTemporal.getOperand1());
        }
        if (expressionTemporal.getOperand2() != null) {
            simpleLTL2 = this.getFormula(expressionTemporal.getOperand2());
        }
        switch (expressionTemporal.getOperator()) {
            case 1: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.NEXT, simpleLTL2);
                break;
            }
            case 2: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.UNTIL, simpleLTL, simpleLTL2);
                break;
            }
            case 3: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.FINALLY, simpleLTL2);
                break;
            }
            case 4: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.GLOBALLY, simpleLTL2);
                break;
            }
            case 5: 
            case 6: {
                Expression expression = expressionTemporal.convertToUntilForm();
                expression.accept(this);
                simpleLTL3 = this.getFormula(expression);
                break;
            }
            default: {
                throw new PrismLangException("Cannot convert expression to jltl2ba form", expressionTemporal);
            }
        }
        this.setFormula(expressionTemporal, simpleLTL3);
    }

    @Override
    public void visitPost(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
        SimpleLTL simpleLTL = null;
        SimpleLTL simpleLTL2 = null;
        SimpleLTL simpleLTL3 = null;
        if (expressionBinaryOp.getOperand1() != null) {
            simpleLTL = this.getFormula(expressionBinaryOp.getOperand1());
        }
        if (expressionBinaryOp.getOperand2() != null) {
            simpleLTL2 = this.getFormula(expressionBinaryOp.getOperand2());
        }
        switch (expressionBinaryOp.getOperator()) {
            case 1: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.IMPLIES, simpleLTL, simpleLTL2);
                break;
            }
            case 2: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.EQUIV, simpleLTL, simpleLTL2);
                break;
            }
            case 3: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.OR, simpleLTL, simpleLTL2);
                break;
            }
            case 4: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.AND, simpleLTL, simpleLTL2);
                break;
            }
            default: {
                throw new PrismLangException("Cannot convert expression to jltl2ba form", expressionBinaryOp);
            }
        }
        this.setFormula(expressionBinaryOp, simpleLTL3);
    }

    @Override
    public void visitPost(ExpressionUnaryOp expressionUnaryOp) throws PrismLangException {
        SimpleLTL simpleLTL = null;
        SimpleLTL simpleLTL2 = null;
        if (expressionUnaryOp.getOperand() != null) {
            simpleLTL = this.getFormula(expressionUnaryOp.getOperand());
        }
        switch (expressionUnaryOp.getOperator()) {
            case 1: {
                simpleLTL2 = new SimpleLTL(SimpleLTL.LTLType.NOT, simpleLTL);
                break;
            }
            case 3: {
                simpleLTL2 = simpleLTL;
                break;
            }
            default: {
                throw new PrismLangException("Cannot convert expression to jltl2ba form", expressionUnaryOp);
            }
        }
        this.setFormula(expressionUnaryOp, simpleLTL2);
    }

    @Override
    public void visitPost(ExpressionLiteral expressionLiteral) throws PrismLangException {
        if (!(expressionLiteral.getType() instanceof TypeBool)) {
            throw new PrismLangException("Cannot convert expression to jltl2ba form", expressionLiteral);
        }
        this.setFormula(expressionLiteral, new SimpleLTL(expressionLiteral.evaluateBoolean()));
    }

    @Override
    public void visitPost(ExpressionLabel expressionLabel) throws PrismLangException {
        this.setFormula(expressionLabel, new SimpleLTL(expressionLabel.getName()));
    }
}

