/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import parser.EvaluateContextSubstate;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.ast.Updates;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class Update
extends ASTElement {
    private ArrayList<String> vars = new ArrayList();
    private ArrayList<Expression> exprs = new ArrayList();
    private ArrayList<Type> types = new ArrayList();
    private ArrayList<ExpressionIdent> varIdents = new ArrayList();
    private ArrayList<Integer> indices = new ArrayList();
    private Updates parent;

    public void addElement(ExpressionIdent expressionIdent, Expression expression) {
        this.vars.add(expressionIdent.getName());
        this.exprs.add(expression);
        this.types.add(null);
        this.varIdents.add(expressionIdent);
        this.indices.add(-1);
    }

    public void setVar(int n, ExpressionIdent expressionIdent) {
        this.vars.set(n, expressionIdent.getName());
        this.varIdents.set(n, expressionIdent);
    }

    public void setExpression(int n, Expression expression) {
        this.exprs.set(n, expression);
    }

    public void setType(int n, Type type) {
        this.types.set(n, type);
    }

    public void setVarIndex(int n, int n2) {
        this.indices.set(n, n2);
    }

    public void setParent(Updates updates) {
        this.parent = updates;
    }

    public int getNumElements() {
        return this.vars.size();
    }

    public String getVar(int n) {
        return this.vars.get(n);
    }

    public Expression getExpression(int n) {
        return this.exprs.get(n);
    }

    public Type getType(int n) {
        return this.types.get(n);
    }

    public ExpressionIdent getVarIdent(int n) {
        return this.varIdents.get(n);
    }

    public int getVarIndex(int n) {
        return this.indices.get(n);
    }

    public Updates getParent() {
        return this.parent;
    }

    public Values update(Values values, Values values2) throws PrismLangException {
        Values values3 = new Values(values2);
        int n = this.exprs.size();
        for (int i = 0; i < n; ++i) {
            values3.setValue(this.getVar(i), this.getExpression(i).evaluate(values, values2));
        }
        return values3;
    }

    public void update(Values values, Values values2, Values values3) throws PrismLangException {
        int n = this.exprs.size();
        for (int i = 0; i < n; ++i) {
            values3.setValue(this.getVar(i), this.getExpression(i).evaluate(values, values2));
        }
    }

    public State update(State state) throws PrismLangException {
        State state2 = new State(state);
        int n = this.exprs.size();
        for (int i = 0; i < n; ++i) {
            state2.setValue(this.getVarIndex(i), this.getExpression(i).evaluate(state));
        }
        return state2;
    }

    public void update(State state, State state2) throws PrismLangException {
        int n = this.exprs.size();
        for (int i = 0; i < n; ++i) {
            state2.setValue(this.getVarIndex(i), this.getExpression(i).evaluate(state));
        }
    }

    public void updatePartially(State state, State state2, int[] nArray) throws PrismLangException {
        int n = this.exprs.size();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[this.getVarIndex(i)];
            if (n2 == -1) continue;
            state2.setValue(n2, this.getExpression(i).evaluate(new EvaluateContextSubstate(state, nArray)));
        }
    }

    public State checkUpdate(State state, VarList varList) throws PrismLangException {
        State state2 = new State(state);
        int n = this.exprs.size();
        for (int i = 0; i < n; ++i) {
            int n2 = varList.encodeToInt(i, this.getExpression(i).evaluate(state));
            if (n2 >= varList.getLow(i) && n2 <= varList.getHigh(i)) continue;
            throw new PrismLangException("Value of variable " + this.getVar(i) + " overflows", this.getExpression(i));
        }
        return state2;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        int n = this.exprs.size();
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                string = string + "(" + this.vars.get(i) + "'=" + this.exprs.get(i) + ") & ";
            }
            string = string + "(" + this.vars.get(n - 1) + "'=" + this.exprs.get(n - 1) + ")";
        } else {
            string = "true";
        }
        return string;
    }

    @Override
    public ASTElement deepCopy() {
        Update update = new Update();
        int n = this.getNumElements();
        for (int i = 0; i < n; ++i) {
            update.addElement((ExpressionIdent)this.getVarIdent(i).deepCopy(), this.getExpression(i).deepCopy());
            update.setType(i, this.getType(i));
            update.setVarIndex(i, this.getVarIndex(i));
        }
        update.setPosition(this);
        return update;
    }
}

