/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.Vector;
import parser.ast.ModulesFile;
import parser.ast.SystemDefn;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class SystemRename
extends SystemDefn {
    private SystemDefn operand;
    private Vector<String> from;
    private Vector<String> to;

    public SystemRename() {
        this.from = new Vector();
        this.to = new Vector();
    }

    public SystemRename(SystemDefn systemDefn) {
        this.operand = systemDefn;
        this.from = new Vector();
        this.to = new Vector();
    }

    public void setOperand(SystemDefn systemDefn) {
        this.operand = systemDefn;
    }

    public void addRename(String string, String string2) {
        this.from.addElement(string);
        this.to.addElement(string2);
    }

    public void setRename(int n, String string, String string2) {
        this.from.setElementAt(string, n);
        this.to.setElementAt(string2, n);
    }

    public SystemDefn getOperand() {
        return this.operand;
    }

    public int getNumRenames() {
        return this.from.size();
    }

    public String getFrom(int n) {
        return this.from.elementAt(n);
    }

    public String getTo(int n) {
        return this.to.elementAt(n);
    }

    public String getNewName(String string) {
        int n = this.from.indexOf(string);
        if (n == -1) {
            return string;
        }
        return this.to.elementAt(n);
    }

    @Override
    public void getModules(Vector<String> vector) {
        this.operand.getModules(vector);
    }

    @Override
    public void getModules(Vector<String> vector, ModulesFile modulesFile) {
        this.operand.getModules(vector, modulesFile);
    }

    @Override
    public void getSynchs(Vector<String> vector) {
        int n = this.getNumRenames();
        for (int i = 0; i < n; ++i) {
            String string = this.getTo(i);
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        this.operand.getSynchs(vector);
    }

    @Override
    public void getSynchs(Vector<String> vector, ModulesFile modulesFile) {
        int n = this.getNumRenames();
        for (int i = 0; i < n; ++i) {
            String string = this.getTo(i);
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        this.operand.getSynchs(vector, modulesFile);
    }

    @Override
    public void getReferences(Vector<String> vector) {
        this.operand.getReferences(vector);
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        string = string + this.operand + "{";
        int n = this.getNumRenames();
        for (int i = 0; i < n - 1; ++i) {
            string = string + this.getFrom(i) + "<-" + this.getTo(i) + ",";
        }
        if (n > 0) {
            string = string + this.getFrom(n - 1) + "<-" + this.getTo(n - 1);
        }
        string = string + "}";
        return string;
    }

    @Override
    public SystemDefn deepCopy() {
        SystemRename systemRename = new SystemRename(this.getOperand().deepCopy());
        int n = this.getNumRenames();
        for (int i = 0; i < n; ++i) {
            systemRename.addRename(this.getFrom(i), this.getTo(i));
        }
        systemRename.setPosition(this);
        return systemRename;
    }
}

